package com.ejianc.foundation.report.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 数据表
 * 
 * @author guoming
 */
@TableName("ejc_report_tbl")
public class TableEntity extends BaseEntity {

	private static final long serialVersionUID = 5542455641344731158L;

	@TableField(value = "code")
	private String code; // 报表编码

	@TableField(value = "table_name")
	private String tableName;// 报表名称

	@TableField(value = "index_name")
	private String indexName; // 对应的索引库

	@TableField(value = "dataset_id")
	private String datasetIds; // 对应的数据集

	@TableField(value = "dataset_names")
	private String datasetNames; // 对应的数据集

	@TableField(value = "report_type")
	private Integer reportType; // 报表类型(1:表格， 2：树表)

	@TableField(value = "left_tree_url")
	private String leftTreeUrl; // 左侧树的服务地址

	@TableField(value = "request_mode")
	private String requestMode; // get / post

	@TableField(value = "tree_key")
	private String treeKey;

	@TableField(value = "tree_name")
	private String treeName;

	@TableField(value = "condition_json")
	private String conditionJson; // 报表配置的筛选条件

	// 报表排序条件
	@TableField(value = "order_item_json")
	private String orderItemJson;

	// 参数Url
	@TableField(value = "param_url")
	private String paramUrl;

	//是否 支持图表
	@TableField(value = "support_image")
	private Boolean supportImage;

	//主报表id
	@TableField(value = "pid")
	private Long pid;

	// 百度大模型 prompt模板id
	@TableField(value = "prompt_tmp_id")
	private String promptTmpId;

	public String getPromptTmpId() {
		return promptTmpId;
	}

	public void setPromptTmpId(String promptTmpId) {
		this.promptTmpId = promptTmpId;
	}

	public Boolean getSupportImage() {
		return supportImage;
	}

	public void setSupportImage(Boolean supportImage) {
		this.supportImage = supportImage;
	}

	public Long getPid() {
		return pid;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public String getIndexName() {
		return indexName;
	}

	public void setIndexName(String indexName) {
		this.indexName = indexName;
	}

	public Integer getReportType() {
		return reportType;
	}

	public void setReportType(Integer reportType) {
		this.reportType = reportType;
	}

	public String getLeftTreeUrl() {
		return leftTreeUrl;
	}

	public void setLeftTreeUrl(String leftTreeUrl) {
		this.leftTreeUrl = leftTreeUrl;
	}

	public String getRequestMode() {
		return requestMode;
	}

	public void setRequestMode(String requestMode) {
		this.requestMode = requestMode;
	}

	public String getTreeKey() {
		return treeKey;
	}

	public void setTreeKey(String treeKey) {
		this.treeKey = treeKey;
	}

	public String getTreeName() {
		return treeName;
	}

	public void setTreeName(String treeName) {
		this.treeName = treeName;
	}

	public String getConditionJson() {
		return conditionJson;
	}

	public void setConditionJson(String conditionJson) {
		this.conditionJson = conditionJson;
	}

	public String getOrderItemJson() {
		return orderItemJson;
	}

	public void setOrderItemJson(String orderItemJson) {
		this.orderItemJson = orderItemJson;
	}

	public String getDatasetIds() {
		return datasetIds;
	}

	public void setDatasetIds(String datasetIds) {
		this.datasetIds = datasetIds;
	}

	public String getDatasetNames() {
		return datasetNames;
	}

	public void setDatasetNames(String datasetNames) {
		this.datasetNames = datasetNames;
	}

	public String getParamUrl() {
		return paramUrl;
	}

	public void setParamUrl(String paramUrl) {
		this.paramUrl = paramUrl;
	}
}
