/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.bean.RefreshTimeEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.IRefreshTimeService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/data"})
public class DataExtractController
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DataExtractController.class);
    private static final long serialVersionUID = 169770636614492806L;
    private static final Integer BATCH_SIZE = 1000;
    @Autowired
    private IDatasetService datasetService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private RedissonLocker redissonLocker;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IRefreshTimeService refreshTimeService;
    @Autowired
    private EnvironmentTools environmentTools;

    @RequestMapping(value={"/extract"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> extractData(@RequestBody Map<String, String> param, HttpServletRequest request) {
        String tableIdStr = param.get("tableId");
        String tableCode = param.get("tableCode");
        TableEntity tableEntity = null;
        if (StringUtils.isNotBlank((CharSequence)tableIdStr)) {
            tableEntity = (TableEntity)((Object)this.tableService.selectById(Long.valueOf(tableIdStr)));
        } else if (StringUtils.isNotBlank((CharSequence)tableCode)) {
            tableEntity = this.tableService.getByCode(tableCode);
        }
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6267\u884c\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        return this.syncDbDataToReport(tableEntity, param, request.getHeader("authority"), RequestContextHolder.getRequestAttributes());
    }

    @PostMapping(value={"/refreshAllTenantData"}, consumes={"application/x-www-form-urlencoded"})
    public CommonResponse<String> refreshAllTenantData(@RequestParam Map<String, String> params, HttpServletRequest request) {
        logger.info("\u62a5\u8868\u5237\u65b0\u63a5\u6536\u5230\u7684\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(params));
        JSONArray param = JSONObject.parseArray((String)params.get("param"));
        String pageIndex = null;
        String pageSize = null;
        if (param.getJSONObject(0).getJSONArray("parameters") != null) {
            JSONArray parameters = param.getJSONObject(0).getJSONArray("parameters");
            for (Object o : parameters) {
                JSONObject pa = (JSONObject)o;
                if ("pageIndex".equals(pa.getString("property"))) {
                    pageIndex = pa.getString("value");
                    continue;
                }
                if (!"pageSize".equals(pa.getString("property"))) continue;
                pageSize = pa.getString("value");
            }
        }
        Long startTime = System.currentTimeMillis();
        int sperateLen = 10;
        CommonResponse tenantIdListResp = this.tenantApi.getAllValidTenantId();
        if (!tenantIdListResp.isSuccess()) {
            logger.error("\u83b7\u53d6\u6240\u6709\u6709\u6548\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff0c{}", (Object)tenantIdListResp.getMsg());
            return CommonResponse.error((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u6240\u6709\u6709\u6548\u79df\u6237Id\u5217\u8868\u5931\u8d25");
        }
        List tenantIdList = (List)tenantIdListResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIdList)) {
            return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff0c\u5f85\u5904\u7406\u6570\u636e\u7684\u79df\u6237\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        QueryWrapper tableQuery = new QueryWrapper();
        tableQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        if (StringUtils.isNotEmpty((CharSequence)pageIndex) && StringUtils.isNotEmpty(pageSize)) {
            tableQuery.last(" LIMIT " + pageIndex + "," + pageSize);
        }
        if (StringUtils.isNotBlank((CharSequence)pageIndex) && StringUtils.isBlank((CharSequence)pageSize)) {
            tableQuery.last(" LIMIT " + pageIndex + ",10000");
        }
        tableQuery.orderByAsc((Object)"id");
        List tableList = this.tableService.list((Wrapper)tableQuery);
        if (CollectionUtils.isEmpty((Collection)tableList)) {
            return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u9700\u5237\u65b0\u6570\u636e\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        logger.info("\u6b64\u6b21\u5237\u65b0\u62a5\u8868\u6570\u91cf\uff1a" + tableList.size() + " LIMIT " + pageIndex + "," + pageSize);
        for (TableEntity table : tableList) {
            logger.info("\u62a5\u8868\u540d\u79f0create\uff1a" + table.getTableName());
            String dropTblSql = "DROP TABLE IF EXISTS `report_" + table.getIndexName() + "` ";
            this.tableService.executeSql(dropTblSql);
            String createTblSql = this.columnService.getCurrentTableCreateSql(table.getId());
            this.tableService.executeSql(createTblSql);
        }
        int len = tenantIdList.size() < sperateLen ? tenantIdList.size() : tenantIdList.size() / sperateLen;
        ArrayList<Future<String>> handlers = new ArrayList<Future<String>>();
        ExecutorService threadPool = Executors.newFixedThreadPool(sperateLen);
        List tenantIds = null;
        for (int i = 0; i <= sperateLen && i * len < tenantIdList.size(); ++i) {
            tenantIds = tenantIdList.subList(i * len, (i + 1) * len < tenantIdList.size() ? (i + 1) * len : tenantIdList.size());
            TenantDataRefreshHandle tenantDataRefreshHandle = new TenantDataRefreshHandle(tenantIds, request.getHeader("authority"), tableList, RequestContextHolder.getRequestAttributes());
            Future<String> childFuture = threadPool.submit(tenantDataRefreshHandle);
            handlers.add(childFuture);
        }
        for (Future future : handlers) {
            try {
                String result = (String)future.get();
                logger.info(result);
            }
            catch (Exception e) {
                logger.error("\u5237\u65b0\u79df\u6237-{}\u7edf\u8ba1\u62a5\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Object)StringUtils.join(tenantIds, (String)","), (Object)e);
            }
        }
        Long endTime = System.currentTimeMillis();
        logger.info("\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210, \u8017\u65f6\uff08ms\uff09\uff1a{}", (Object)(endTime - startTime));
        return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff01");
    }

    @PostMapping(value={"/refreshPrjTenantData"})
    public CommonResponse<String> refreshPrjTenantData(HttpServletRequest request) {
        Long startTime = System.currentTimeMillis();
        int sperateLen = 10;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(1607618595976462337L);
        arrayList.add(1382528964577914881L);
        ArrayList<Long> tenantIdList = arrayList;
        if (CollectionUtils.isEmpty(tenantIdList)) {
            return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff0c\u5f85\u5904\u7406\u6570\u636e\u7684\u79df\u6237\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        QueryWrapper tableQuery = new QueryWrapper();
        tableQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        tableQuery.isNotNull((Object)"dataset_id");
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById((Serializable)((Object)"473856794272874585")));
        ArrayList<TableEntity> arrayList1 = new ArrayList<TableEntity>();
        arrayList1.add(tableEntity);
        ArrayList<TableEntity> tableList = arrayList1;
        if (CollectionUtils.isEmpty(tableList)) {
            return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u9700\u5237\u65b0\u6570\u636e\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        HashMap param = new HashMap();
        int len = tenantIdList.size() < sperateLen ? tenantIdList.size() : tenantIdList.size() / sperateLen;
        ArrayList<Future<String>> handlers = new ArrayList<Future<String>>();
        ExecutorService threadPool = Executors.newFixedThreadPool(sperateLen);
        List tenantIds = null;
        for (int i = 0; i <= sperateLen && i * len < tenantIdList.size(); ++i) {
            tenantIds = tenantIdList.subList(i * len, (i + 1) * len < tenantIdList.size() ? (i + 1) * len : tenantIdList.size());
            TenantDataRefreshHandle tenantDataRefreshHandle = new TenantDataRefreshHandle(tenantIds, request.getHeader("authority"), tableList, RequestContextHolder.getRequestAttributes());
            Future<String> childFuture = threadPool.submit(tenantDataRefreshHandle);
            handlers.add(childFuture);
        }
        for (Future future : handlers) {
            try {
                String result = (String)future.get();
                logger.info(result);
            }
            catch (Exception e) {
                logger.error("\u5237\u65b0\u79df\u6237-{}\u7edf\u8ba1\u62a5\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Object)StringUtils.join(tenantIds, (String)","), (Object)e);
            }
        }
        Long endTime = System.currentTimeMillis();
        logger.info("\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210, \u8017\u65f6\uff08ms\uff09\uff1a{}", (Object)(endTime - startTime));
        return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff01");
    }

    @RequestMapping(value={"/extractByCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> extractDataByCode(@RequestBody Map<String, String> param, HttpServletRequest request) {
        TableEntity tableEntity = this.tableService.getByCode(param.get("tableCode"));
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6267\u884c\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        return this.syncDbDataToReport(tableEntity, param, request.getHeader("authority"), RequestContextHolder.getRequestAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private CommonResponse<String> syncDbDataToReport(TableEntity tableEntity, Map<String, String> param, String authority, RequestAttributes context) {
        block33: {
            Long tenantId;
            Long l = tenantId = null != param.get("tenantId") ? Long.valueOf(param.get("tenantId")) : InvocationInfoProxy.getTenantid();
            if (StringUtils.isBlank((CharSequence)tableEntity.getDatasetIds())) {
                return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
            }
            List datasetIds = new ArrayList<String>(Arrays.asList(tableEntity.getDatasetIds().split(","))).stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
            boolean hasReq = false;
            AtomicInteger count = new AtomicInteger(0);
            ConcurrentHashMap<Long, MdProjectVO> projectCache = new ConcurrentHashMap<Long, MdProjectVO>();
            String baseHost = this.environmentTools.getBaseHost(tenantId);
            ExecutorService threadPool = null;
            String lockKey = tenantId + "_" + tableEntity.getId();
            boolean locked = this.redissonLocker.isLocked(lockKey);
            if (locked) {
                throw new BusinessException("\u6570\u636e\u5237\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u83b7\u53d6\u6570\u636e");
            }
            try {
                this.redissonLocker.lock(lockKey, 1200);
                if (CollectionUtil.isNotEmpty(datasetIds)) {
                    threadPool = Executors.newFixedThreadPool(datasetIds.size());
                }
                logger.info("----------------\u4e3b\u7ebf\u7a0b\u6c60\u6570\u91cf\uff1a{}", (Object)datasetIds.size());
                ArrayList<Future<List<Map<String, Object>>>> futureList = new ArrayList<Future<List<Map<String, Object>>>>();
                for (Object datasetId : datasetIds) {
                    MainDatasetCallable mainDatasetCallable = new MainDatasetCallable(baseHost, count, context, (Long)datasetId, tableEntity, authority, tenantId, projectCache);
                    Future<List<Map<String, Object>>> childFuture = threadPool.submit(mainDatasetCallable);
                    futureList.add(childFuture);
                }
                ArrayList<Map> allIndexRequest = new ArrayList<Map>();
                for (Future future : futureList) {
                    List list = (List)future.get(3000L, TimeUnit.SECONDS);
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    logger.info("mainDatasetCallable,\u7ec4\u88c5\u8981\u63d2\u5165\u7684\u6570\u636e-------{}", (Object)list.size());
                    hasReq = true;
                    for (Map ir : list) {
                        allIndexRequest.add(ir);
                    }
                }
                if (hasReq) {
                    void var17_24;
                    logger.info("\u63d2\u5165\u6570\u636e\u5f00\u59cb------");
                    Long batchInsertTimes = (long)(allIndexRequest.size() / 500) + (allIndexRequest.size() % 500 == 0 ? 0L : 1L);
                    logger.info("------\u63d2\u5165\u6570\u636e\u9875\u6570\uff1a{}", (Object)batchInsertTimes);
                    boolean bl = false;
                    while ((long)var17_24 < batchInsertTimes) {
                        void fromIndex = var17_24 * 500;
                        int toIndex = Math.min((int)(fromIndex + 500), allIndexRequest.size());
                        List insertRequestList = allIndexRequest.subList((int)fromIndex, toIndex);
                        if (insertRequestList != null && insertRequestList.size() > 0) {
                            List<ColumnEntity> columnList = this.columnService.queryColumnListByTblId(tableEntity.getId());
                            String insertSql = "INSERT INTO report_" + tableEntity.getIndexName() + " ( `uuid`,`creator_space`,`data_sequence`,";
                            for (ColumnEntity column : columnList) {
                                insertSql = insertSql + "`" + column.getProperty() + "`,";
                            }
                            insertSql = insertSql.substring(0, insertSql.length() - 1);
                            insertSql = insertSql + ") VALUES ";
                            for (int index = 0; index < insertRequestList.size(); ++index) {
                                Map indexRequest = (Map)insertRequestList.get(index);
                                insertSql = insertSql + "( " + IdWorker.getId() + "," + tenantId + "," + (int)(var17_24 * 500 + index + true) + ",";
                                block22: for (ColumnEntity column : columnList) {
                                    String columnType = column.getType();
                                    Object columnObject = indexRequest.get(column.getProperty());
                                    switch (columnType) {
                                        case "number": 
                                        case "decimal": {
                                            if (columnObject == null || "null".equals(columnObject) || StringUtils.isBlank((CharSequence)columnObject.toString())) {
                                                insertSql = insertSql + "null,";
                                                continue block22;
                                            }
                                            insertSql = insertSql + "" + columnObject + ",";
                                            continue block22;
                                        }
                                    }
                                    if (columnObject == null || "null".equals(columnObject)) {
                                        insertSql = insertSql + "null,";
                                        continue;
                                    }
                                    String paramValue = columnObject.toString();
                                    if (StringUtils.isNotBlank((CharSequence)paramValue)) {
                                        int textLength = paramValue.length();
                                        int end = Math.min(250, textLength);
                                        paramValue = paramValue.substring(0, end);
                                        paramValue = paramValue.replace("\"", "");
                                        paramValue = paramValue.replace("'", "");
                                        paramValue = paramValue.replace("\\", "");
                                        paramValue = paramValue.replace("[", "");
                                        paramValue = paramValue.replace("]", "");
                                        paramValue = paramValue.replace("\n", "");
                                        paramValue = paramValue.replace("\t", "");
                                        paramValue = paramValue.replace(";", "\uff1b");
                                        paramValue = paramValue.replace("^", "");
                                        paramValue = paramValue.replace("--", "\u2015");
                                        insertSql = insertSql + "'" + paramValue + "',";
                                        continue;
                                    }
                                    insertSql = insertSql + "'',";
                                }
                                insertSql = insertSql.substring(0, insertSql.length() - 1);
                                insertSql = insertSql + "),";
                            }
                            insertSql = insertSql.substring(0, insertSql.length() - 1);
                            this.tableService.executeInsertSql(insertSql);
                        }
                        ++var17_24;
                    }
                }
                try {
                    QueryWrapper refreshTimeWrapper = new QueryWrapper();
                    refreshTimeWrapper.eq((Object)"table_id", (Object)tableEntity.getId());
                    refreshTimeWrapper.eq((Object)"tenant_id", (Object)tenantId);
                    RefreshTimeEntity refreshTimeEntity = (RefreshTimeEntity)((Object)this.refreshTimeService.getOne((Wrapper)refreshTimeWrapper));
                    if (refreshTimeEntity == null) {
                        RefreshTimeEntity refreshTimeEntity2 = new RefreshTimeEntity();
                        refreshTimeEntity2.setTableId(tableEntity.getId());
                        refreshTimeEntity2.setLastRefreshTime(new Date());
                        refreshTimeEntity2.setTenantId(tenantId);
                        this.refreshTimeService.save((Object)refreshTimeEntity2);
                        break block33;
                    }
                    refreshTimeEntity.setLastRefreshTime(new Date());
                    this.refreshTimeService.updateById((Object)refreshTimeEntity);
                }
                catch (Exception e) {
                    logger.info("\u4fee\u6539\u5237\u65b0\u65f6\u95f4\u5931\u8d25\uff0c", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.info("\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25\uff0c", (Throwable)e);
                CommonResponse commonResponse = CommonResponse.error((String)"\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25");
                return commonResponse;
            }
            finally {
                this.redissonLocker.unlock(lockKey);
                if (null != threadPool) {
                    threadPool.shutdown();
                }
            }
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }

    private Long queryDataSize(String indexName, Long creatorSpace) {
        String dataCountSql = "SELECT COUNT(*) FROM report_" + indexName + " WHERE creator_space = " + creatorSpace;
        Long dataCount = this.tableService.queryCountBySql(dataCountSql);
        return dataCount;
    }

    private String getSubSqlContent(String sqlContent, String[] childParamArr, List<JSONObject> mainDataList, Long tenantId) {
        StringBuffer sqlContentBuffer = new StringBuffer(" select * from ( \n");
        int mainDataListSize = mainDataList.size();
        for (int i = 0; i < mainDataListSize; ++i) {
            JSONObject mainData = mainDataList.get(i);
            String childSql = new String(sqlContent);
            if (childParamArr != null) {
                for (String childParam : childParamArr) {
                    String value = mainData.getString(childParam);
                    childSql = childSql.replace("#{" + childParam + "}", "'" + value + "'");
                }
            }
            childSql = childSql.replace("${tenantId}", tenantId.toString());
            childSql = "SELECT " + i + " AS _mainDataId, inner_t.* FROM (" + childSql + ") inner_t";
            sqlContentBuffer.append(childSql);
            if (i >= mainDataList.size() - 1) continue;
            sqlContentBuffer.append("\n").append(" UNION ALL ").append("\n");
        }
        sqlContentBuffer.append("\n").append(" ) as out_t ");
        return sqlContentBuffer.toString();
    }

    public static void main(String[] args) {
        String str = "dddddd\\";
        System.out.println(str.replace("\\", ""));
    }

    class ChildDatasetCallable
    implements Callable<List<JSONObject>> {
        private String baseHost;
        private DatasetEntity childDataset;
        private List<JSONObject> mainDataset;
        private RequestAttributes context;
        private Long tenantId;
        private String authority;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public ChildDatasetCallable() {
        }

        public ChildDatasetCallable(String baseHost, DatasetEntity childDataset, List<JSONObject> mainDataset, RequestAttributes context, Long tenantId, String authority, ConcurrentHashMap<Long, MdProjectVO> projectCache) {
            this.baseHost = baseHost;
            this.childDataset = childDataset;
            this.mainDataset = mainDataset;
            this.context = context;
            this.tenantId = tenantId;
            this.authority = authority;
            this.projectCache = projectCache;
        }

        @Override
        public List<JSONObject> call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            MdProjectVO projectVO = this.projectCache.get((long)this.childDataset.getMdProjectId());
            logger.info("children-----tenantid--------" + this.tenantId);
            if (null == projectVO) {
                String url = this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", this.childDataset.getMdProjectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)this.childDataset.getMdProjectId(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put((long)projectVO.getId(), projectVO);
                } else {
                    logger.error("\u6570\u636e\u5b50\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.childDataset.getId(), (Object)response.getMsg());
                }
            }
            if (null != projectVO) {
                String childDatasetUrl = this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject childParamJson = new JSONObject();
                String[] childParamArr = null;
                if (StringUtils.isNotBlank((CharSequence)this.childDataset.getChildParam())) {
                    childParamArr = this.childDataset.getChildParam().split(",");
                }
                String sql = DataExtractController.this.getSubSqlContent(this.childDataset.getSqlContent(), childParamArr, this.mainDataset, this.tenantId);
                childParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)sql));
                childParamJson.put("datasetType", (Object)"1");
                childParamJson.put("params", (Object)new JSONObject());
                String childResponseStr = ReferHttpClientUtils.postByJson((String)childDatasetUrl, (String)JSON.toJSONString((Object)childParamJson));
                CommonResponse childResponse = (CommonResponse)JSON.parseObject((String)childResponseStr, CommonResponse.class);
                if (childResponse.isSuccess()) {
                    return (List)childResponse.getData();
                }
            }
            return dataList;
        }
    }

    class MainDatasetCallable
    implements Callable<List<Map<String, Object>>> {
        private String baseHost;
        private AtomicInteger count;
        private RequestAttributes context;
        private TableEntity tableEntity;
        private Long datasetId;
        private String authority;
        private Long tenantId;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public MainDatasetCallable(String baseHost, AtomicInteger count, RequestAttributes context, Long datasetId, TableEntity tableEntity, String authority, Long tenantId, ConcurrentHashMap<Long, MdProjectVO> projectCache) {
            this.baseHost = baseHost;
            this.count = count;
            this.context = context;
            this.tableEntity = tableEntity;
            this.datasetId = datasetId;
            this.authority = authority;
            this.tenantId = tenantId;
            this.projectCache = projectCache;
        }

        @Override
        public List<Map<String, Object>> call() throws Exception {
            InvocationInfoProxy.setTenantid((Long)this.tenantId);
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<Map<String, Object>> irList = new ArrayList<Map<String, Object>>();
            HashMap resp = new HashMap();
            List mainDatasetList = new ArrayList();
            DatasetEntity datasetEntity = (DatasetEntity)((Object)DataExtractController.this.datasetService.selectById(this.datasetId));
            MdProjectVO projectVO = this.projectCache.get((long)datasetEntity.getMdProjectId());
            if (null == projectVO) {
                String url = this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", datasetEntity.getMdProjectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)datasetEntity.getMdProjectId().toString(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put((long)projectVO.getId(), projectVO);
                } else {
                    logger.error("\u4e3b\u6570\u636e\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.datasetId, (Object)response.getMsg());
                }
            }
            if (null != projectVO) {
                String mainDatasetUrl = this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject mainParamJson = new JSONObject();
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", (Object)this.tenantId);
                String sql = "SELECT dsq.* FROM (" + datasetEntity.getSqlContent() + " ) dsq WHERE dsq.tenantId =#{tenantId}";
                mainParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)sql));
                mainParamJson.put("datasetType", (Object)"1");
                mainParamJson.put("params", (Object)mainQueryParam);
                String mainResponseStr = ReferHttpClientUtils.postByJson((String)mainDatasetUrl, (String)JSON.toJSONString((Object)mainParamJson));
                CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
                if (mainResponse.isSuccess()) {
                    mainDatasetList = (List)mainResponse.getData();
                    List<DatasetEntity> childDatasetList = DataExtractController.this.datasetService.queryChildrenByParentId(datasetEntity.getId());
                    Long resultSize = DataExtractController.this.queryDataSize(this.tableEntity.getIndexName(), this.tenantId);
                    Long deleteTimes = resultSize / (long)BATCH_SIZE.intValue() + (resultSize % (long)BATCH_SIZE.intValue() == 0L ? 0L : 1L);
                    logger.info("\u672c\u6b21\u5f85\u5220\u9664\u6570\u636e\u603b\u6570\uff1a{}\uff0c\u6bcf\u6b21\u5220\u9664\u91cf\uff1a{}\uff0c\u6267\u884c\u5220\u9664\u6b21\u6570\uff1a{}", new Object[]{resultSize, BATCH_SIZE, deleteTimes});
                    int i = 0;
                    while ((long)i < deleteTimes) {
                        String deleteSql = "DELETE FROM report_" + this.tableEntity.getIndexName() + " WHERE creator_space = " + this.tenantId + " LIMIT " + BATCH_SIZE;
                        DataExtractController.this.tableService.executeSql(deleteSql);
                        logger.info("\u7b2c{}\u6b21\u6267\u884c \u7d22\u5f15-{} \u5220\u9664\u64cd\u4f5c\uff0c\u53c2\u6570-creator_space\uff1a{}", new Object[]{i, this.tableEntity.getIndexName(), this.tenantId});
                        ++i;
                    }
                    if (mainDatasetList != null && mainDatasetList.size() > 0) {
                        logger.info("\u672c\u6b21\u5f85\u63d2\u5165\u6570\u636e\u603b\u6570\uff1a{}", (Object)mainDatasetList.size());
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("tableId", this.tableEntity.getId());
                        paramMap.put("tenantId", this.tenantId);
                        List<ColumnEntity> columnEntities = DataExtractController.this.columnService.queryTenantColumnList(paramMap);
                        HashMap<String, String> columnMap = new HashMap<String, String>();
                        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
                        ArrayList<String> columnProperties = new ArrayList<String>();
                        if (columnEntities != null && columnEntities.size() > 0) {
                            for (ColumnEntity columnEntity : columnEntities) {
                                if (!StringUtils.isNotBlank((CharSequence)columnEntity.getProperty())) continue;
                                if (StringUtils.isBlank((CharSequence)columnEntity.getFormula())) {
                                    columnEntityMap.put(columnEntity.getProperty(), columnEntity);
                                    columnMap.put(columnEntity.getProperty(), columnEntity.getType());
                                    columnProperties.add(columnEntity.getProperty());
                                    continue;
                                }
                                columnProperties.add(columnEntity.getProperty());
                                columnMap.put(columnEntity.getProperty(), columnEntity.getFormula());
                            }
                        }
                        try {
                            if (childDatasetList != null && childDatasetList.size() > 0) {
                                ArrayList batchList = new ArrayList();
                                ArrayList<JSONObject> batch = new ArrayList<JSONObject>();
                                int mainDatasetListSize = mainDatasetList.size();
                                for (int i2 = 0; i2 < mainDatasetListSize; ++i2) {
                                    JSONObject mainDataset = (JSONObject)mainDatasetList.get(i2);
                                    batch.add(mainDataset);
                                    if ((i2 + 1) % 100 != 0) continue;
                                    batchList.add(batch);
                                    batch = new ArrayList();
                                }
                                if (!batch.isEmpty()) {
                                    batchList.add(batch);
                                }
                                Iterator i2 = batchList.iterator();
                                while (i2.hasNext()) {
                                    List mainDataList = (List)i2.next();
                                    ExecutorService threadPool = Executors.newFixedThreadPool(childDatasetList.size());
                                    logger.info("----------------\u5b50\u7ebf\u7a0b\u6c60\u6570\u91cf\uff1a{}", (Object)childDatasetList.size());
                                    ArrayList<Future<List<JSONObject>>> futureList = new ArrayList<Future<List<JSONObject>>>();
                                    for (DatasetEntity datasetEntity2 : childDatasetList) {
                                        ChildDatasetCallable childCallable = new ChildDatasetCallable(this.baseHost, datasetEntity2, mainDataList, this.context, this.tenantId, this.authority, this.projectCache);
                                        Future<List<JSONObject>> childFuture = threadPool.submit(childCallable);
                                        futureList.add(childFuture);
                                    }
                                    for (Future future : futureList) {
                                        List childList = (List)future.get(3000L, TimeUnit.SECONDS);
                                        if (childList == null || childList.isEmpty()) continue;
                                        for (int i3 = 0; i3 < mainDataList.size(); ++i3) {
                                            JSONObject mainDataset = (JSONObject)mainDataList.get(i3);
                                            for (JSONObject childObject : childList) {
                                                if (childObject.getInteger("_mainDataId") != i3) continue;
                                                for (Map.Entry entry : childObject.entrySet()) {
                                                    if ("_mainDataId".equals(entry.getKey())) continue;
                                                    mainDataset.put((String)entry.getKey(), entry.getValue());
                                                }
                                            }
                                        }
                                    }
                                    if (null == threadPool) continue;
                                    threadPool.shutdown();
                                }
                            }
                            for (JSONObject mainDataset : mainDatasetList) {
                                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                                dataMap.put("creator_space", this.tenantId);
                                dataMap.put("data_sequence", this.count.incrementAndGet());
                                String columnType = null;
                                for (String key : columnProperties) {
                                    columnType = (String)columnMap.get(key);
                                    if ("time".equals(columnType)) {
                                        if (null == mainDataset.get((Object)key)) continue;
                                        dataMap.put(key, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainDataset.get((Object)key)));
                                        mainDataset.put(key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainDataset.get((Object)key)));
                                        continue;
                                    }
                                    if ("string".equals(columnType) || "number".equals(columnType) || "decimal".equals(columnType)) {
                                        dataMap.put(key, mainDataset.get((Object)key));
                                        mainDataset.put(key, mainDataset.get((Object)key));
                                        continue;
                                    }
                                    if ("pic".equals(columnType)) continue;
                                    dataMap.put(key, CalculatorUtils.getResult(columnType, mainDataset));
                                    mainDataset.put(key, (Object)CalculatorUtils.getResult(columnType, mainDataset));
                                }
                                for (String key : columnProperties) {
                                    columnType = (String)columnMap.get(key);
                                    if (!"pic".equals(columnType)) continue;
                                    if (StringUtils.isNotEmpty((CharSequence)((ColumnEntity)((Object)columnEntityMap.get(key))).getFormatter())) {
                                        ScriptEngineManager manager = new ScriptEngineManager();
                                        ScriptEngine engine = manager.getEngineByName("js");
                                        try {
                                            engine.eval(((ColumnEntity)((Object)columnEntityMap.get(key))).getFormatter());
                                            if (engine instanceof Invocable) {
                                                Invocable invocable = (Invocable)((Object)engine);
                                                Integer r = (Integer)invocable.invokeFunction("getIconByRowData", mainDataset);
                                                dataMap.put(key, r);
                                                mainDataset.put(key, (Object)r);
                                                continue;
                                            }
                                            dataMap.put(key, 1);
                                            mainDataset.put(key, (Object)1);
                                        }
                                        catch (NoSuchMethodException | ScriptException exception) {
                                            exception.printStackTrace();
                                            dataMap.put(key, 1);
                                            mainDataset.put(key, (Object)1);
                                        }
                                        continue;
                                    }
                                    dataMap.put(key, 1);
                                    mainDataset.put(key, (Object)1);
                                }
                                irList.add(dataMap);
                            }
                        }
                        catch (Exception e) {
                            logger.error("******************* \u6267\u884cSQL\u67e5\u8be2\u5f02\u5e38\uff1a *******************", (Throwable)e);
                        }
                    }
                } else {
                    logger.error("******************* \u6267\u884cSQL\u67e5\u8be2\u5931\u8d25\uff1a{}  *******************", (Object)mainResponse.getMsg());
                }
            }
            return irList;
        }
    }

    class TenantDataRefreshHandle
    implements Callable<String> {
        private List<Long> tenantIds;
        private String authority;
        private List<TableEntity> tableList;
        private RequestAttributes context;

        private TenantDataRefreshHandle(List<Long> tenantIds, String authority, List<TableEntity> tableList, RequestAttributes context) {
            this.tableList = tableList;
            this.tenantIds = tenantIds;
            this.authority = authority;
            this.context = context;
        }

        @Override
        public String call() throws Exception {
            HashMap<String, String> param = new HashMap<String, String>();
            CommonResponse dataRefresh = null;
            for (Long tenantId : this.tenantIds) {
                param.put("tenantId", tenantId.toString());
                for (TableEntity table : this.tableList) {
                    dataRefresh = DataExtractController.this.syncDbDataToReport(table, param, this.authority, this.context);
                    logger.info("\u5237\u65b0\u79df\u6237-{},\u62a5\u8868-[\u540d\u79f0:{}\uff0c\u7f16\u7801\uff1a{}]\u6570\u636e\u7ed3\u679c\uff1a{}", new Object[]{tenantId, table.getTableName(), table.getCode(), dataRefresh.getMsg()});
                }
            }
            return "\u79df\u6237-[" + StringUtils.join(this.tenantIds, (String)",") + "]\u6570\u636e\u5237\u65b0\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff01";
        }
    }
}

