package com.ejianc.foundation.chat.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.chat.bean.ChatExcelMsgEntity;
import com.ejianc.foundation.chat.controller.param.ChatExcelParam;
import com.ejianc.foundation.chat.service.IChatExcelMsgService;
import com.ejianc.foundation.chat.vo.ChatExcelMsgVO;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/chatExcel")
public class ChatExcelController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IChatExcelMsgService chatExcelMsgService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;

    @PostMapping(value = "/sendChatExcel", produces = MediaType.TEXT_EVENT_STREAM_VALUE)
    @ResponseBody
    public SseEmitter sendChatExcel(@RequestBody ChatExcelParam chatExcelParam, HttpServletRequest request) {
        return chatExcelMsgService.sendChatExcel(chatExcelParam, request);
    }

    @RequestMapping(value = "/queryGridHeaderList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<GridHeader>> queryGridHeaderList(@RequestParam String tableCode) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TableEntity tableEntity = tableService.getByCode(tableCode);
        List<GridHeader> gridHeaders = columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        return CommonResponse.success(gridHeaders);
    }

    /**
     * 根据 id 查询某个报表的信息
     * */
    @RequestMapping(value = "/queryTableInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TableEntity> queryTableInfo(@RequestParam Long id) {
        TableEntity tableEntity = tableService.selectById(id);
        return CommonResponse.success(tableEntity);
    }

    /**
     * 根据chatExcelId查询某个 聊天记录 详情
     * */
    @RequestMapping(value = "/queryChatExcelMsgDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChatExcelMsgVO> queryChatExcelMsgDetail(@RequestParam Long id) {
        ChatExcelMsgEntity chatExcelMsgEntity = chatExcelMsgService.selectById(id);
        ChatExcelMsgVO vo = BeanMapper.map(chatExcelMsgEntity, ChatExcelMsgVO.class);
        QueryParam param = QueryParam.getInstance();
        param.getParams().put("parentId", new Parameter(QueryParam.EQ, id));
        param.getOrderMap().put("createTime", QueryParam.ASC);
        List<ChatExcelMsgEntity> childrenList = chatExcelMsgService.queryList(param,false);
        vo.setChildren(BeanMapper.mapList(childrenList,  ChatExcelMsgVO.class));
        return CommonResponse.success(vo);
    }

    /**
     * 根据chatExcelId查询某个用户的聊天记录
     * */
    @RequestMapping(value = "/queryChatExcelLogs", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ChatExcelMsgVO>> queryChatExcelLogs(@RequestParam(required = false) String tableCode, @RequestParam(required = false) String tableId) {
        TableEntity tableEntity = null;
        if(StringUtils.isNotBlank(tableCode)) {
            tableEntity = tableService.getByCode(tableCode);
        }
        if(StringUtils.isNotBlank(tableId)) {
            tableEntity = tableService.getById(tableId);
        }
        if(null == tableEntity) {
            return CommonResponse.error("数据查询失败，没有匹配的报表信息！");
        }
        QueryParam param = QueryParam.getInstance();
        param.getParams().put("chatexcel_id", new Parameter(QueryParam.EQ, tableEntity.getId()));
        param.getParams().put("userId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        param.getParams().put("parentId", new Parameter(QueryParam.EQ, null));
        List<ChatExcelMsgEntity> list = chatExcelMsgService.queryList(param,false);
        List<ChatExcelMsgVO> result = BeanMapper.mapList(list, ChatExcelMsgVO.class);
        if(ListUtil.isNotEmpty(list)){
            param.getParams().put("parentId", new Parameter(QueryParam.IN, list.stream().map(ChatExcelMsgEntity::getId).collect(Collectors.toList())));
            param.getOrderMap().put("createTime", QueryParam.ASC);
            List<ChatExcelMsgEntity> childrenList = chatExcelMsgService.queryList(param,false);
            if(ListUtil.isNotEmpty(childrenList)){
                for(ChatExcelMsgVO vo : result) {
                    List<ChatExcelMsgVO> children = childrenList.stream().filter(item -> item.getParentId().equals(vo.getId())).map(item -> BeanMapper.map(item, ChatExcelMsgVO.class)).collect(Collectors.toList());
                    vo.setChildren(children);
                }
            }
        }
        return CommonResponse.success(result);
    }

    @RequestMapping(value = "/clearChatExcelLogs", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> clearChatExcelLogs(@RequestBody JSONObject jsonObject) {
        Long userId = InvocationInfoProxy.getUserid();
        String chatExcelId = jsonObject.getString("chatExcelId");
        TableEntity tableEntity = tableService.getByCode(chatExcelId);
        if(null == tableEntity) {
            return CommonResponse.error("数据查询失败，没有匹配的报表信息！");
        }
        chatExcelMsgService.clearCurrentUserMessages(userId, tableEntity.getId()+"");
        return CommonResponse.success("清空成功！");
    }

}
