package com.ejianc.foundation.report.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/report")
public class ReportAPIController implements Serializable {
    private static final long serialVersionUID = -8696919229626873630L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private EnvironmentTools environmentTools;

    @PostMapping(value = "/queryPageData")
    public CommonResponse<Page<JSONObject>> queryPageData(HttpServletRequest req, @RequestParam("tableCode") String tableCode, @RequestBody QueryParam queryParam,
                                                          @RequestParam(value = "selectSql", required = false) String selectSql,
                                                          @RequestParam(value = "groupBySql", required = false) String groupBySql) {
        TableEntity tableEntity = tableService.getByCode(tableCode);
        if (null == tableEntity) {
            return CommonResponse.error("数据查询失败，没有匹配的报表信息！");
        }
        Page<JSONObject> pageData = columnService.queryPageListBySelectSql(tableEntity, queryParam, selectSql, groupBySql);
        return CommonResponse.success(pageData);
    }

    private String configQueryParam(TableEntity tableEntity, QueryParam queryParam, HttpServletRequest req, boolean getCommonQueryParam) {
        //拼接查询排序条件
        if (StringUtils.isNotBlank(tableEntity.getOrderItemJson())) {
            List<JSONObject> orderGroups = JSONArray.parseArray(tableEntity.getOrderItemJson(), JSONObject.class);
            JSONObject order = null;
            for (JSONObject o : orderGroups) {
                if (null != o.get("isActive") && o.get("isActive").toString().equals("true")) {
                    order = o;
                    break;
                }
            }
            if (null == order && CollectionUtils.isNotEmpty(orderGroups)) {
                order = orderGroups.get(0);
            }
            if (null != order && !queryParam.getOrderMap().containsKey(order.get("field").toString())) {
                queryParam.getOrderMap().put(order.get("field").toString(), order.get("sort").toString());
            }
        }
        Parameter parameter = queryParam.getParams().get("_treeSelectId");
        String leftTreeId = null;
        if (parameter != null) {
            leftTreeId = (String) parameter.getValue();
        }
        String url = tableEntity.getParamUrl();
        try {
            if (StringUtils.isNotBlank(url) && getCommonQueryParam) {
                if (StringUtils.isNotBlank(leftTreeId)) {
                    url += url.indexOf("?") == -1 ? "?" : "&";
                    url = url + "leftTreeId=" + leftTreeId;
                }
                if (!url.contains("http")) {
                    if (url.startsWith("/")) {
                        url = url.substring(1);
                    }
                    url = environmentTools.getBaseHost() + url;
                }
                Map<String, String> header = new HashMap<>();
                header.put("authority", req.getHeader("authority"));
                header.put("content-type", "application/json;charset=UTF-8");
                String respStr = HttpTookit.get(url, new HashMap<>(), header);
                CommonResponse<JSONObject> params = JSONObject.parseObject(respStr, CommonResponse.class);
                if (!params.isSuccess()) {
                    logger.error("请求服务-【{}】获取报表参数失败，{}", url, params.getMsg());
                    return "数据查询失败，" + params.getMsg();
                }
                QueryParam q = JSONObject.parseObject(JSONObject.toJSONString(params.getData()), QueryParam.class);
                queryParam.getParams().putAll(q.getParams());
                queryParam.getComplexParams().addAll(q.getComplexParams());
            }
        } catch (Exception e) {
            logger.error("请求服务-【{}】获取报表参数失败，", url, e);
            return "数据查询失败，获取查询参数失败！";
        }
        return null;
    }

}
