/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.CustomColumnEntity;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ICustomColumnService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.foundation.report.vo.CustomColumnVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/col/"})
public class ColumnController
implements Serializable {
    private static final long serialVersionUID = 880340424115528835L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer BATCH_SIZE = 1000;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Value(value="${refer.base-host:null}")
    private String baseHost;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private RedissonLocker redissonLocker;
    @Autowired
    private IDatasetService datasetService;
    private static final String REFRESH_PRJ_COST_LIST_URL = "ejc-prjfinance-web/projectDutyLetter/updateCostList";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ColumnVO columnVo) {
        String msg = this.columnService.saveOrUpdateColumn(columnVo);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        if (null != columnVo.getId()) {
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"syncColumnsBatch"})
    public CommonResponse<String> syncColumnsBatch(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            this.columnService.syncColumnsBatch(pageData.getRecords());
        }
        return CommonResponse.success((String)"\u5b57\u6bb5\u540c\u6b65\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"syncDataSetColumnsBatch"})
    public CommonResponse<String> syncDataSetColumnsBatch(@RequestParam Long tableId, HttpServletRequest request) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(tableId));
        Long tenantId = InvocationInfoProxy.getTenantid();
        List datasetIds = new ArrayList<String>(Arrays.asList(tableEntity.getDatasetIds().split(","))).stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        boolean hasReq = false;
        AtomicInteger count = new AtomicInteger(0);
        ConcurrentHashMap<Long, MdProjectVO> projectCache = new ConcurrentHashMap<Long, MdProjectVO>();
        String baseHost = this.environmentTools.getBaseHost(tenantId);
        ExecutorService threadPool = null;
        String lockKey = tenantId + "_" + tableEntity.getId();
        boolean locked = this.redissonLocker.isLocked(lockKey);
        if (locked) {
            throw new BusinessException("\u6570\u636e\u5237\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u83b7\u53d6\u6570\u636e");
        }
        try {
            this.redissonLocker.lock(lockKey, 1200);
            if (CollectionUtil.isNotEmpty(datasetIds)) {
                threadPool = Executors.newFixedThreadPool(datasetIds.size());
            }
            this.logger.info("----------------\u4e3b\u7ebf\u7a0b\u6c60\u6570\u91cf\uff1a{}", (Object)datasetIds.size());
            ArrayList<Future<JSONObject>> futureList = new ArrayList<Future<JSONObject>>();
            for (Long l : datasetIds) {
                MainDatasetCallable mainDatasetCallable = new MainDatasetCallable(baseHost, count, RequestContextHolder.getRequestAttributes(), l, tableEntity, request.getHeader("authority"), tenantId, projectCache);
                Future<JSONObject> childFuture = threadPool.submit(mainDatasetCallable);
                futureList.add(childFuture);
            }
            for (Future future : futureList) {
                JSONObject jsonObject = (JSONObject)future.get(3000L, TimeUnit.SECONDS);
                if (jsonObject.isEmpty()) continue;
                int i = 1;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    QueryWrapper columnWrapper = new QueryWrapper();
                    columnWrapper.eq((Object)"table_id", (Object)tableId);
                    columnWrapper.eq((Object)"property", (Object)key);
                    ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnService.getOne((Wrapper)columnWrapper));
                    if (columnEntity != null) continue;
                    columnEntity = new ColumnEntity();
                    columnEntity.setId(IdWorker.getId());
                    columnEntity.setTableId(tableId);
                    columnEntity.setType("string");
                    columnEntity.setProperty(key);
                    columnEntity.setColumnName(key);
                    columnEntity.setVisible(0);
                    columnEntity.setSequence(i++);
                    this.columnService.save((Object)columnEntity);
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25\uff0c", (Throwable)e);
            CommonResponse commonResponse = CommonResponse.error((String)"\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25");
            return commonResponse;
        }
        finally {
            this.redissonLocker.unlock(lockKey);
            if (null != threadPool) {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success((String)"\u5b57\u6bb5\u521d\u59cb\u5316\u6210\u529f\uff01");
    }

    @GetMapping(value={"syncColumnsByTableId"})
    public CommonResponse<String> syncColumnsByTableId(@RequestParam Long tableId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"table_id", (Object)tableId);
        List columnList = this.columnService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)columnList)) {
            this.columnService.syncColumnsBatch(columnList);
        }
        return CommonResponse.success((String)"\u5b57\u6bb5\u540c\u6b65\u6210\u529f\uff01");
    }

    @GetMapping(value={"syncColumnsByTableCode"})
    public CommonResponse<String> syncColumnsByTableCode(@RequestParam String tableCode) {
        TableEntity table = this.tableService.getByCode(tableCode);
        if (table == null) {
            return CommonResponse.error((String)"\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"table_id", (Object)table.getId());
        List columnList = this.columnService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)columnList)) {
            this.columnService.syncColumnsBatch(columnList);
        }
        return CommonResponse.success((String)"\u5b57\u6bb5\u540c\u6b65ES\u6210\u529f\uff01");
    }

    @PostMapping(value={"syncSelectColumnsBatch"})
    public CommonResponse<String> syncSelectColumnsBatch(@RequestBody List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u8981\u540c\u6b65\u7684\u5b57\u6bb5\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List pageData = this.columnService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData)) {
            this.columnService.syncColumnsBatch(pageData);
        }
        return CommonResponse.success((String)"\u5b57\u6bb5\u540c\u6b65ES\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        List voList = BeanMapper.mapList((Iterable)pageData.getRecords(), Map.class);
        JSONObject resp = new JSONObject();
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("size", (Object)pageData.getSize());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("pages", (Object)pageData.getPages());
        List records = ResultAsTree.createTreeData((List)voList);
        resp.put("records", (Object)records);
        Integer currentMaxSeq = 0;
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            currentMaxSeq = this.columnService.getCurrentMaxColSeq(Long.valueOf(((Map)voList.get(0)).get("tableId").toString()));
        }
        resp.put("curMaxSeq", (Object)currentMaxSeq);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)resp);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryFormulaList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryFormulaList(@RequestParam Long tableId) {
        List<ColumnEntity> columnList = this.columnService.queryFormulaList(tableId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", columnList);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ColumnVO> queryDetail(@RequestParam Long id) {
        ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnService.selectById(id));
        if (columnEntity != null) {
            ColumnVO columnVo = (ColumnVO)BeanMapper.map((Object)((Object)columnEntity), ColumnVO.class);
            if (columnVo.getParentId() != null) {
                ColumnEntity parentEntity = (ColumnEntity)((Object)this.columnService.selectById(columnVo.getParentId()));
                columnVo.setParentName(parentEntity.getColumnName());
            }
            return CommonResponse.success((Object)columnVo);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"parent_id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List pList = this.columnService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)pList)) {
            for (ColumnEntity col : pList) {
                if (ids.contains(col.getId())) continue;
                return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u5b57\u6bb5\u5305\u542b\u6709\u5b50\u7ea7\u5b57\u6bb5\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u5b57\u6bb5\u3002");
            }
        }
        for (Long pkId : ids) {
            ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnService.selectById(pkId));
            TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(columnEntity.getTableId()));
            String existColSql = "SELECT COUNT(*) FROM information_schema.columns WHERE table_name = 'report_" + tableEntity.getIndexName() + "' AND column_name = '" + columnEntity.getProperty() + "' ";
            Integer existColInt = this.tableService.queryColCount(existColSql);
            if (existColInt <= 0) continue;
            String dropSqlCol = "ALTER TABLE `report_" + tableEntity.getIndexName() + "` DROP COLUMN `" + columnEntity.getProperty() + "` ";
            this.tableService.executeSql(dropSqlCol);
        }
        this.columnService.deleteByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/custom"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> customColumn(@RequestBody CustomColumnVO customColumnVo) {
        QueryWrapper customColumnWrapper = new QueryWrapper();
        customColumnWrapper.eq((Object)"column_id", (Object)customColumnVo.getColumnId());
        customColumnWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        CustomColumnEntity customColumnEntity = (CustomColumnEntity)((Object)this.customColumnService.getOne((Wrapper)customColumnWrapper));
        if (customColumnEntity != null) {
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColumnName())) {
                customColumnEntity.setColumnName(customColumnVo.getColumnName());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getVisible())) {
                customColumnEntity.setVisible(customColumnVo.getVisible());
            }
            customColumnEntity.setSuffixStr(customColumnVo.getSuffixStr());
            customColumnEntity.setEnableSummarize(customColumnVo.getEnableSummarize());
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColFixed())) {
                customColumnEntity.setColFixed(customColumnVo.getColFixed());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColFontBold())) {
                customColumnEntity.setColFontBold(customColumnVo.getColFontBold());
            }
            customColumnEntity.setSequence(customColumnVo.getSequence());
            customColumnEntity.setColBgColor(customColumnVo.getColBgColor());
            customColumnEntity.setColFontColor(customColumnVo.getColFontColor());
            customColumnEntity.setDataTotal(customColumnVo.getDataTotal());
            customColumnEntity.setDataX(customColumnVo.getDataX());
            customColumnEntity.setDataY(customColumnVo.getDataY());
            customColumnEntity.setWidth(customColumnVo.getWidth());
            this.customColumnService.saveOrUpdate((Object)customColumnEntity, false);
        } else {
            CustomColumnEntity saveBean = new CustomColumnEntity();
            saveBean.setColumnId(customColumnVo.getColumnId());
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColumnName())) {
                saveBean.setColumnName(customColumnVo.getColumnName());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getVisible())) {
                saveBean.setVisible(customColumnVo.getVisible());
            }
            saveBean.setTenantId(InvocationInfoProxy.getTenantid());
            saveBean.setSuffixStr(customColumnVo.getSuffixStr());
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColFixed())) {
                saveBean.setColFixed(customColumnVo.getColFixed());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColFontBold())) {
                saveBean.setColFontBold(customColumnVo.getColFontBold());
            }
            saveBean.setSequence(customColumnVo.getSequence());
            saveBean.setColBgColor(customColumnVo.getColBgColor());
            saveBean.setColFontColor(customColumnVo.getColFontColor());
            saveBean.setEnableSummarize(customColumnVo.getEnableSummarize());
            saveBean.setDataTotal(customColumnVo.getDataTotal());
            saveBean.setDataX(customColumnVo.getDataX());
            saveBean.setDataY(customColumnVo.getDataY());
            saveBean.setWidth(customColumnVo.getWidth());
            this.customColumnService.saveOrUpdate((Object)saveBean, false);
        }
        return CommonResponse.success((String)"\u8bbe\u7f6e\u6210\u529f");
    }

    @RequestMapping(value={"/resetCustomColumn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> resetCustomColumn(@RequestParam Long tableId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.customColumnService.deleteByTenantId(tableId, tenantId);
        return CommonResponse.success((String)"\u6062\u590d\u6210\u529f");
    }

    @GetMapping(value={"/getPrjFinanceQueryParam"})
    public CommonResponse<QueryParam> getPrjFinanceQueryParam(HttpServletRequest req) {
        try {
            CommonResponse orgListResp;
            String orgIdField = req.getParameter("orgIdField");
            if (StringUtils.isBlank((CharSequence)orgIdField)) {
                orgIdField = "projectDepartmentId";
            }
            String notRefreshPrjCost = req.getParameter("notRefreshPrjCost");
            String noTenantId = req.getParameter("noTenantId");
            if (!"true".equals(notRefreshPrjCost)) {
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("authority", req.getHeader("authority"));
                new Thread(() -> {
                    try {
                        String reqResult = HttpTookit.post((String)(this.environmentTools.getBaseHost() + REFRESH_PRJ_COST_LIST_URL), (String)"{}", (String)"application/json", (String)"UTF-8", (Integer)10000, (Integer)10000, (Map)header);
                        this.logger.info("*********** \u5237\u65b0\u62a5\u8868\u8d39\u7528\u6e05\u5355\u6570\u636e\u8bf7\u6c42\u7ed3\u679c\uff1a{}  *********** ", (Object)reqResult);
                    }
                    catch (Exception e) {
                        this.logger.error("\u5237\u65b0\u62a5\u8868\u8d39\u7528\u6e05\u5355\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                    }
                }).start();
            }
            if (!(orgListResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId())).isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u53c2\u6570\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            }
            List orgList = (List)orgListResp.getData();
            QueryParam queryParam = new QueryParam();
            if (!"true".equals(noTenantId)) {
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            }
            queryParam.getParams().put(orgIdField, new Parameter("in", orgList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            return CommonResponse.success((Object)queryParam);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @GetMapping(value={"getColumnListByTblId"})
    public CommonResponse<JSONArray> getColumnListByTblId(@RequestParam(value="tblId") Long tblId) {
        JSONArray resp = new JSONArray();
        QueryParam queryParam = new QueryParam();
        ArrayList attrs = new ArrayList();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("tableId", new Parameter("eq", (Object)tblId));
        queryParam.getParams().put("property", new Parameter("ne", null));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        List entityList = pageData.getRecords();
        JSONObject entity = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.stream().forEach(e -> {
                JSONObject o = new JSONObject();
                o.put("id", (Object)e.getId());
                o.put("dataFormat", (Object)e.getFormatter());
                o.put("title", (Object)e.getColumnName());
                o.put("fieldText", (Object)e.getColumnName());
                o.put("code", (Object)e.getProperty());
                o.put("entityId", (Object)e.getTableId());
                o.put("isList", (Object)"1");
                o.put("expand", (Object)true);
                o.put("type", (Object)0);
                attrs.add(o);
            });
        }
        TableEntity table = (TableEntity)((Object)this.tableService.selectById(tblId));
        entity.put("title", (Object)table.getTableName());
        entity.put("fieldText", (Object)table.getTableName());
        entity.put("code", (Object)table.getCode());
        entity.put("entityFullName", (Object)table.getCode());
        entity.put("id", (Object)table.getId());
        entity.put("children", attrs);
        entity.put("type", (Object)0);
        entity.put("isList", (Object)"1");
        entity.put("dataFormat", null);
        entity.put("expand", (Object)true);
        resp.add((Object)entity);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        String referBaseHost = "";
        referBaseHost = StringUtils.isNotBlank((CharSequence)this.baseHost) && !"null".equals(this.baseHost) ? this.baseHost : this.environmentTools.getBaseHost();
        ArrayList<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        ReferShowfieldVO idHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityHeader = new ReferShowfieldVO();
        ReferShowfieldVO displayHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityFullHeader = new ReferShowfieldVO();
        switch (refCode) {
            case "parent_column_referList": {
                refer.setRefCode("knowledgeBase");
                refer.setRefName("\u62a5\u8868\u5b57\u6bb5");
                refer.setRefType("grid");
                refer.setDataurl(referBaseHost + "ejc-report-web/col/queryParentColList");
                refer.setIdField("id");
                refer.setCodeField("property");
                refer.setNameField("columnName");
                refer.setId(Long.valueOf(new Date().getTime()));
                idHeader.setId(Long.valueOf(1L));
                idHeader.setName("\u4e3b\u952e");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder(Integer.valueOf(1));
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                entityHeader.setId(Long.valueOf(2L));
                entityHeader.setName("\u5217\u540d");
                entityHeader.setCode("columnName");
                entityHeader.setHidden(false);
                entityHeader.setShowOrder(Integer.valueOf(1));
                entityHeader.setType("string");
                gridHeaders.add(entityHeader);
                displayHeader.setId(Long.valueOf(3L));
                displayHeader.setName("\u5c5e\u6027");
                displayHeader.setCode("property");
                displayHeader.setHidden(false);
                displayHeader.setShowOrder(Integer.valueOf(1));
                displayHeader.setType("string");
                gridHeaders.add(displayHeader);
                entityFullHeader.setId(Long.valueOf(4L));
                entityFullHeader.setName("\u5b57\u6bb5\u7c7b\u578b");
                entityFullHeader.setCode("type");
                entityFullHeader.setHidden(false);
                entityFullHeader.setShowOrder(Integer.valueOf(1));
                entityFullHeader.setType("string");
                gridHeaders.add(entityFullHeader);
                refer.setGridheaders(gridHeaders);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)refer);
        return CommonResponse.success((Object)refer);
    }

    @RequestMapping(value={"/queryParentColList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ColumnEntity>> queryParentColList(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        JSONObject cond = JSONObject.parseObject((String)condition);
        if (cond.get((Object)"tableId") != null) {
            queryParam.getParams().put("tableId", new Parameter("eq", cond.get((Object)"tableId")));
        }
        if (cond.get((Object)"currentColumnId") != null) {
            queryParam.getParams().put("currentColumnId", new Parameter("ne", cond.get((Object)"currentColumnId")));
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", pageData);
    }

    class ChildDatasetCallable
    implements Callable<List<JSONObject>> {
        private String baseHost;
        private DatasetEntity childDataset;
        private JSONObject mainDataset;
        private RequestAttributes context;
        private Long tenantId;
        private String authority;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public ChildDatasetCallable() {
        }

        public ChildDatasetCallable(String baseHost, DatasetEntity childDataset, JSONObject mainDataset, RequestAttributes context, Long tenantId, String authority, ConcurrentHashMap<Long, MdProjectVO> projectCache) {
            this.baseHost = baseHost;
            this.childDataset = childDataset;
            this.mainDataset = mainDataset;
            this.context = context;
            this.tenantId = tenantId;
            this.authority = authority;
            this.projectCache = projectCache;
        }

        @Override
        public List<JSONObject> call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            MdProjectVO projectVO = this.projectCache.get((long)this.childDataset.getMdProjectId());
            ColumnController.this.logger.info("children-----tenantid--------" + this.tenantId);
            if (null == projectVO) {
                String url = this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", this.childDataset.getMdProjectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                ColumnController.this.logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)this.childDataset.getMdProjectId(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put((long)projectVO.getId(), projectVO);
                } else {
                    ColumnController.this.logger.error("\u6570\u636e\u5b50\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.childDataset.getId(), (Object)response.getMsg());
                }
            }
            if (null != projectVO) {
                String childDatasetUrl = this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject childParamJson = new JSONObject();
                JSONObject childQueryParam = new JSONObject();
                childQueryParam.put("tenantId", (Object)this.tenantId);
                if (StringUtils.isNotBlank((CharSequence)this.childDataset.getChildParam())) {
                    CommonResponse childParamArr;
                    for (CommonResponse childParamStr : childParamArr = this.childDataset.getChildParam().split(",")) {
                        childQueryParam.put((String)childParamStr, (Object)this.mainDataset.getString((String)childParamStr));
                    }
                }
                String sql = "SELECT dsq.* FROM (" + this.childDataset.getSqlContent() + " ) dsq limit 1 ";
                childParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)sql));
                childParamJson.put("datasetType", (Object)"2");
                childParamJson.put("params", (Object)childQueryParam);
                String childResponseStr = ReferHttpClientUtils.postByJson((String)childDatasetUrl, (String)JSON.toJSONString((Object)childParamJson));
                CommonResponse childResponse = (CommonResponse)JSON.parseObject((String)childResponseStr, CommonResponse.class);
                if (childResponse.isSuccess()) {
                    return (List)childResponse.getData();
                }
                ColumnController.this.logger.info("\u8bf7\u6c42{}, \u6267\u884csql-{}, \u53c2\u6570-{}, \u7ed3\u679c-{}", new Object[]{childDatasetUrl, this.childDataset.getSqlContent(), childQueryParam, JSONObject.toJSONString((Object)childResponse)});
            }
            return dataList;
        }
    }

    class MainDatasetCallable
    implements Callable<JSONObject> {
        private String baseHost;
        private AtomicInteger count;
        private RequestAttributes context;
        private TableEntity tableEntity;
        private Long datasetId;
        private String authority;
        private Long tenantId;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public MainDatasetCallable(String baseHost, AtomicInteger count, RequestAttributes context, Long datasetId, TableEntity tableEntity, String authority, Long tenantId, ConcurrentHashMap<Long, MdProjectVO> projectCache) {
            this.baseHost = baseHost;
            this.count = count;
            this.context = context;
            this.tableEntity = tableEntity;
            this.datasetId = datasetId;
            this.authority = authority;
            this.tenantId = tenantId;
            this.projectCache = projectCache;
        }

        @Override
        public JSONObject call() throws Exception {
            JSONObject result;
            block15: {
                result = new JSONObject();
                InvocationInfoProxy.setTenantid((Long)this.tenantId);
                this.context.setAttribute("authority", (Object)this.authority, 0);
                RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
                ArrayList irList = new ArrayList();
                HashMap resp = new HashMap();
                List mainDatasetList = new ArrayList();
                DatasetEntity datasetEntity = (DatasetEntity)((Object)ColumnController.this.datasetService.selectById(this.datasetId));
                MdProjectVO projectVO = this.projectCache.get((long)datasetEntity.getMdProjectId());
                if (null == projectVO) {
                    String url = this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                    HashMap<String, String> param = new HashMap<String, String>();
                    HashMap<String, String> header = new HashMap<String, String>();
                    param.put("id", datasetEntity.getMdProjectId().toString());
                    header.put("authority", this.authority);
                    String projectInfoResp = HttpTookit.get((String)url, param, header);
                    ColumnController.this.logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)datasetEntity.getMdProjectId().toString(), (Object)projectInfoResp);
                    CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                    if (response.isSuccess()) {
                        projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                        this.projectCache.put((long)projectVO.getId(), projectVO);
                    } else {
                        ColumnController.this.logger.error("\u4e3b\u6570\u636e\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.datasetId, (Object)response.getMsg());
                    }
                }
                if (null != projectVO) {
                    String mainDatasetUrl = this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                    JSONObject mainParamJson = new JSONObject();
                    JSONObject mainQueryParam = new JSONObject();
                    mainQueryParam.put("tenantId", (Object)this.tenantId);
                    String sql = "SELECT dsq.* FROM (" + datasetEntity.getSqlContent() + " ) dsq limit 1 ";
                    mainParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)sql));
                    mainParamJson.put("datasetType", (Object)"1");
                    mainParamJson.put("params", (Object)mainQueryParam);
                    String mainResponseStr = ReferHttpClientUtils.postByJson((String)mainDatasetUrl, (String)JSON.toJSONString((Object)mainParamJson));
                    CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
                    if (mainResponse.isSuccess()) {
                        mainDatasetList = (List)mainResponse.getData();
                        List<DatasetEntity> childDatasetList = ColumnController.this.datasetService.queryChildrenByParentId(datasetEntity.getId());
                        if (mainDatasetList != null && mainDatasetList.size() > 0) {
                            try {
                                JSONObject mainDataset = (JSONObject)mainDatasetList.get(0);
                                if (childDatasetList != null && childDatasetList.size() > 0) {
                                    ExecutorService threadPool = null;
                                    if (CollectionUtil.isNotEmpty(childDatasetList)) {
                                        threadPool = Executors.newFixedThreadPool(childDatasetList.size());
                                    }
                                    ColumnController.this.logger.info("----------------\u5b50\u7ebf\u7a0b\u6c60\u6570\u91cf\uff1a{}", (Object)childDatasetList.size());
                                    ArrayList<Future<List<JSONObject>>> futureList = new ArrayList<Future<List<JSONObject>>>();
                                    for (DatasetEntity datasetEntity2 : childDatasetList) {
                                        ChildDatasetCallable childCallable = new ChildDatasetCallable(this.baseHost, datasetEntity2, mainDataset, this.context, this.tenantId, this.authority, this.projectCache);
                                        Future<List<JSONObject>> childFuture = threadPool.submit(childCallable);
                                        futureList.add(childFuture);
                                    }
                                    for (Future future : futureList) {
                                        List childList = (List)future.get(3000L, TimeUnit.SECONDS);
                                        if (childList == null || childList.isEmpty()) continue;
                                        JSONObject childObject = (JSONObject)childList.get(0);
                                        ColumnController.this.logger.info("----------------\u5b50\u7ebf\u7a0b\u67e5\u8be2\u6570\u636e\uff1a{}", (Object)childObject);
                                        if (null == childObject) continue;
                                        for (Map.Entry entry : childObject.entrySet()) {
                                            mainDataset.put((String)entry.getKey(), entry.getValue());
                                        }
                                    }
                                    result = mainDataset;
                                    if (null != threadPool) {
                                        threadPool.shutdown();
                                    }
                                    break block15;
                                }
                                result = mainDataset;
                            }
                            catch (Exception e) {
                                ColumnController.this.logger.error("******************* \u6267\u884cSQL\u67e5\u8be2\u5f02\u5e38\uff1a *******************", (Throwable)e);
                            }
                        }
                    } else {
                        ColumnController.this.logger.error("******************* \u6267\u884cSQL\u67e5\u8be2\u5931\u8d25\uff1a{}  *******************", (Object)mainResponse.getMsg());
                    }
                }
            }
            return result;
        }
    }
}

