/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.mapper.TableMapper;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.report.util.PinYinUtil;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ColumnServiceImpl
extends BaseServiceImpl<ColumnMapper, ColumnEntity>
implements IColumnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ColumnMapper columnMapper;
    @Autowired
    private ITableService tableService;
    @Value(value="${oms.sysUserCode}")
    private String sysUserCode;
    @Autowired
    private TableMapper tableMapper;

    @Override
    public void deleteByIds(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnMapper.selectById(id));
            if (tenantId.equals(columnEntity.getTenantId())) {
                this.columnMapper.deleteById(id);
                continue;
            }
            throw new BusinessException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u6b64\u5217");
        }
    }

    @Override
    public IPage<ColumnEntity> queryPage(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<ColumnEntity> records = this.columnMapper.queryList(condition);
        Long count = this.columnMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public List<GridHeader> queryGridHeadList(Long tableId, Long tenantId) {
        List<GridHeader> gridHeadList = this.columnMapper.queryGridHeadList(tableId, tenantId);
        return gridHeadList;
    }

    @Override
    public IPage<JSONObject> queryPageList(TableEntity tableEntity, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap) {
        return this.queryPageList(tableEntity, queryParam, heightFields, filedTypeMap, true);
    }

    @Override
    public Page<JSONObject> queryPageListBySelectSql(TableEntity tableEntity, QueryParam queryParam, String selectSql, String groupBySql) {
        String orderBySql;
        String tableName = "report_" + tableEntity.getIndexName();
        String whereSQL = " 1=1 ";
        if (!queryParam.getParams().containsKey("tenantId") || ((Parameter)queryParam.getParams().get("tenantId")).getValue() == null) {
            whereSQL = " `creator_space` =  " + InvocationInfoProxy.getTenantid();
        }
        for (Map.Entry entry : queryParam.getParams().entrySet()) {
            String[] dataArr;
            ColumnEntity columnEntity;
            QueryWrapper columnWrapper;
            String paramValue;
            String string = (String)entry.getKey();
            if ("creator_space".equals(string)) continue;
            Parameter param = (Parameter)entry.getValue();
            if ("eq".equals(param.getType())) {
                paramValue = param.getValue() + "";
                if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                paramValue = paramValue.replace("\"", "");
                paramValue = paramValue.replace("'", "");
                paramValue = paramValue.replace("[", "");
                paramValue = paramValue.replace("]", "");
                paramValue = paramValue.replace("\\", "");
                paramValue = paramValue.replace("\n", "");
                paramValue = paramValue.replace("\t", "");
                paramValue = paramValue.replace(";", "\uff1b");
                paramValue = paramValue.replace("^", "");
                paramValue = paramValue.replace("--", "\u2015");
                whereSQL = whereSQL + " AND `" + string + "` = '" + paramValue + "' ";
                continue;
            }
            if ("like".equals(param.getType())) {
                paramValue = param.getValue() + "";
                if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                paramValue = paramValue.replace("\"", "");
                paramValue = paramValue.replace("'", "");
                paramValue = paramValue.replace("[", "");
                paramValue = paramValue.replace("]", "");
                paramValue = paramValue.replace("\\", "");
                paramValue = paramValue.replace("\n", "");
                paramValue = paramValue.replace("\t", "");
                paramValue = paramValue.replace(";", "\uff1b");
                paramValue = paramValue.replace("^", "");
                paramValue = paramValue.replace("--", "\u2015");
                whereSQL = whereSQL + " AND `" + string + "` LIKE '%" + paramValue + "%' ";
                continue;
            }
            if ("in".equals(param.getType())) {
                columnWrapper = new QueryWrapper();
                columnWrapper.eq((Object)"property", (Object)string);
                columnWrapper.eq((Object)"table_id", (Object)tableEntity.getId());
                columnEntity = (ColumnEntity)((Object)this.columnMapper.selectOne((Wrapper)columnWrapper));
                if ("number".equals(columnEntity.getType()) || "decimal".equals(columnEntity.getType())) {
                    String paramValue2 = param.getValue() + "";
                    if (!StringUtils.isNotBlank((CharSequence)paramValue2)) continue;
                    paramValue2 = paramValue2.replace("\"", "");
                    paramValue2 = paramValue2.replace("'", "");
                    paramValue2 = paramValue2.replace("[", "");
                    paramValue2 = paramValue2.replace("]", "");
                    paramValue2 = paramValue2.replace("\\", "");
                    paramValue2 = paramValue2.replace("\n", "");
                    paramValue2 = paramValue2.replace("\t", "");
                    paramValue2 = paramValue2.replace(";", "\uff1b");
                    paramValue2 = paramValue2.replace("^", "");
                    if (!StringUtils.isNotBlank((CharSequence)(paramValue2 = paramValue2.replace("--", "\u2015")))) continue;
                    whereSQL = whereSQL + " AND `" + string + "` IN (" + paramValue2 + ") ";
                    continue;
                }
                dataArr = param.getValue().toString().split(",");
                String paramValue3 = "";
                for (String str : dataArr) {
                    str = str.replace("\"", "");
                    str = str.replace("'", "");
                    str = str.replace("[", "");
                    str = str.replace("]", "");
                    str = str.replace("\\", "");
                    str = str.replace("\n", "");
                    str = str.replace("\t", "");
                    str = str.replace(";", "\uff1b");
                    str = str.replace("^", "");
                    str = str.replace("--", "\u2015");
                    paramValue3 = paramValue3 + "'" + str.trim() + "',";
                }
                if (!StringUtils.isNotBlank((CharSequence)paramValue3)) continue;
                paramValue3 = paramValue3.substring(0, paramValue3.length() - 1);
                whereSQL = whereSQL + " AND `" + string + "` IN (" + paramValue3 + ") ";
                continue;
            }
            if ("between".equals(param.getType())) {
                columnWrapper = new QueryWrapper();
                columnWrapper.eq((Object)"property", (Object)string);
                columnWrapper.eq((Object)"table_id", (Object)tableEntity.getId());
                columnEntity = (ColumnEntity)((Object)this.columnMapper.selectOne((Wrapper)columnWrapper));
                if ("number".equals(columnEntity.getType()) || "decimal".equals(columnEntity.getType())) {
                    dataArr = param.getValue().toString().split(",");
                    whereSQL = whereSQL + " AND ( `" + string + "` BETWEEN " + dataArr[0] + " AND " + dataArr[1] + " )";
                    continue;
                }
                dataArr = param.getValue().toString().split(",");
                String data0 = dataArr[0];
                data0 = data0.replace("\"", "");
                data0 = data0.replace("'", "");
                data0 = data0.replace("[", "");
                data0 = data0.replace("]", "");
                data0 = data0.replace("\\", "");
                data0 = data0.replace("\n", "");
                data0 = data0.replace("\t", "");
                data0 = data0.replace(";", "\uff1b");
                data0 = data0.replace("^", "");
                data0 = data0.replace("--", "\u2015");
                String data1 = dataArr[1];
                data1 = data1.replace("\"", "");
                data1 = data1.replace("'", "");
                data1 = data1.replace("[", "");
                data1 = data1.replace("]", "");
                data1 = data1.replace("\\", "");
                data1 = data1.replace("\n", "");
                data1 = data1.replace("\t", "");
                data1 = data1.replace(";", "\uff1b");
                data1 = data1.replace("^", "");
                data1 = data1.replace("--", "\u2015");
                whereSQL = whereSQL + " AND ( `" + string + "` BETWEEN '" + data0 + "' AND '" + data1 + "' ) ";
                continue;
            }
            if ("gt".equals(param.getType())) {
                if (!NumberUtils.isNumber((String)(param.getValue() + ""))) {
                    paramValue = param.getValue() + "";
                    if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                    paramValue = paramValue.replace("\"", "");
                    paramValue = paramValue.replace("'", "");
                    paramValue = paramValue.replace("[", "");
                    paramValue = paramValue.replace("]", "");
                    paramValue = paramValue.replace("\\", "");
                    paramValue = paramValue.replace("\n", "");
                    paramValue = paramValue.replace("\t", "");
                    paramValue = paramValue.replace(";", "\uff1b");
                    paramValue = paramValue.replace("^", "");
                    paramValue = paramValue.replace("--", "\u2015");
                    whereSQL = whereSQL + " AND `" + string + "` > '" + paramValue + "' ";
                    continue;
                }
                whereSQL = whereSQL + " AND `" + string + "` > " + param.getValue() + " ";
                continue;
            }
            if ("ge".equals(param.getType())) {
                if (!NumberUtils.isNumber((String)(param.getValue() + ""))) {
                    paramValue = param.getValue() + "";
                    if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                    paramValue = paramValue.replace("\"", "");
                    paramValue = paramValue.replace("'", "");
                    paramValue = paramValue.replace("[", "");
                    paramValue = paramValue.replace("]", "");
                    paramValue = paramValue.replace("\\", "");
                    paramValue = paramValue.replace("\n", "");
                    paramValue = paramValue.replace("\t", "");
                    paramValue = paramValue.replace(";", "\uff1b");
                    paramValue = paramValue.replace("^", "");
                    paramValue = paramValue.replace("--", "\u2015");
                    whereSQL = whereSQL + " AND `" + string + "` >= '" + paramValue + "' ";
                    continue;
                }
                whereSQL = whereSQL + " AND `" + string + "` >= " + param.getValue() + " ";
                continue;
            }
            if ("lt".equals(param.getType())) {
                if (!NumberUtils.isNumber((String)(param.getValue() + ""))) {
                    paramValue = param.getValue() + "";
                    if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                    paramValue = paramValue.replace("\"", "");
                    paramValue = paramValue.replace("'", "");
                    paramValue = paramValue.replace("[", "");
                    paramValue = paramValue.replace("]", "");
                    paramValue = paramValue.replace("\\", "");
                    paramValue = paramValue.replace("\n", "");
                    paramValue = paramValue.replace("\t", "");
                    paramValue = paramValue.replace(";", "\uff1b");
                    paramValue = paramValue.replace("^", "");
                    paramValue = paramValue.replace("--", "\u2015");
                    whereSQL = whereSQL + " AND `" + string + "` < '" + paramValue + "' ";
                    continue;
                }
                whereSQL = whereSQL + " AND `" + string + "` < " + param.getValue() + " ";
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            if (!NumberUtils.isNumber((String)(param.getValue() + ""))) {
                paramValue = param.getValue() + "";
                if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                paramValue = paramValue.replace("\"", "");
                paramValue = paramValue.replace("'", "");
                paramValue = paramValue.replace("[", "");
                paramValue = paramValue.replace("]", "");
                paramValue = paramValue.replace("\\", "");
                paramValue = paramValue.replace("\n", "");
                paramValue = paramValue.replace("\t", "");
                paramValue = paramValue.replace(";", "\uff1b");
                paramValue = paramValue.replace("^", "");
                paramValue = paramValue.replace("--", "\u2015");
                whereSQL = whereSQL + " AND `" + string + "` <= '" + paramValue + "' ";
                continue;
            }
            whereSQL = whereSQL + " AND `" + string + "` <= " + param.getValue() + " ";
        }
        String string = orderBySql = StringUtils.isNotBlank((CharSequence)groupBySql) ? "GROUP BY " + groupBySql : "ORDER BY data_sequence ASC";
        if (queryParam.getOrderMap() != null && !queryParam.getOrderMap().isEmpty()) {
            orderBySql = "ORDER BY ";
            for (Map.Entry entry : queryParam.getOrderMap().entrySet()) {
                orderBySql = orderBySql + "`" + (String)entry.getKey() + "` " + (String)entry.getValue() + ",";
            }
            if (orderBySql.endsWith(",")) {
                orderBySql = orderBySql.substring(0, orderBySql.length() - 1);
            }
        }
        String pageSql = "";
        if (queryParam.getPageSize() > 0) {
            pageSql = " LIMIT " + queryParam.getPageSize() * (queryParam.getPageIndex() - 1) + "," + queryParam.getPageSize();
        }
        String string2 = "SELECT " + Optional.ofNullable(selectSql).orElse("*") + " FROM " + tableName + " WHERE " + whereSQL + " " + orderBySql + " " + pageSql;
        String countSql = "SELECT count(" + (StringUtils.isNotBlank((CharSequence)groupBySql) ? "DISTINCT " + groupBySql : "*") + ") FROM " + tableName + " WHERE " + whereSQL;
        this.logger.info("\u67e5\u8be2\u6570\u636eSQL\uff1a{}", (Object)string2);
        List<JSONObject> dataList = this.tableMapper.queryDataBySql(string2);
        Long dataCount = this.tableMapper.queryCountBySql(countSql);
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        pageData.setRecords(dataList);
        pageData.setTotal(dataCount.longValue());
        return pageData;
    }

    @Override
    public List<ColumnEntity> queryTenantColumnList(Map<String, Object> paramMap) {
        List<ColumnEntity> columnList = this.columnMapper.queryTenantColumnList(paramMap);
        return columnList;
    }

    @Override
    public List<ColumnEntity> queryFormulaList(Long tableId) {
        List<ColumnEntity> columnEntities = this.columnMapper.queryFormulaList(tableId, InvocationInfoProxy.getTenantid());
        return columnEntities;
    }

    private String saveOrUpdateColumnBatch(List<ColumnVO> columnVos, boolean resetBaseInfo) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(columnVos.get(0).getTableId()));
        try {
            String createTblSql = "CREATE TABLE IF NOT EXISTS `report_" + tableEntity.getIndexName() + "` (`uuid` BIGINT(20) NOT NULL COMMENT '\u4e3b\u952eID', `creator_space` BIGINT(20) DEFAULT NULL COMMENT '\u79df\u6237\u9694\u79bb\u5b57\u6bb5', `data_sequence` int(11) DEFAULT NULL COMMENT '\u6392\u5e8f\u5b57\u6bb5', PRIMARY KEY (`uuid`) USING BTREE, KEY `idx_" + tableEntity.getIndexName() + "_creator_space`(`creator_space`) USING BTREE ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='" + tableEntity.getTableName() + "' ";
            this.tableService.executeSql(createTblSql);
        }
        catch (Exception e) {
            this.logger.error("\u8868-\u3010{}\u3011\u5b58\u5728\u5f02\u5e38\uff01", (Object)tableEntity.getIndexName(), (Object)e);
        }
        ArrayList<ColumnEntity> saveList = new ArrayList<ColumnEntity>();
        try {
            for (ColumnVO columnVo : columnVos) {
                String checkResult;
                ColumnEntity uniqueBean = null;
                if (columnVo.getId() != null && columnVo.getId() > 0L) {
                    uniqueBean = (ColumnEntity)((Object)this.columnMapper.selectById(columnVo.getId()));
                }
                if (null != uniqueBean) {
                    String checkResult2;
                    boolean config = !Objects.equals(columnVo.getProperty(), uniqueBean.getProperty());
                    boolean alterCol = false;
                    if (!uniqueBean.getType().equals(columnVo.getType())) {
                        alterCol = true;
                        uniqueBean.setType(columnVo.getType());
                    }
                    uniqueBean.setColumnName(columnVo.getColumnName());
                    if (StringUtils.isNotBlank((CharSequence)columnVo.getFormula())) {
                        Boolean checked = CalculatorUtils.simpleMathFormuaCheck(columnVo.getFormula());
                        if (!checked.booleanValue()) {
                            return "\u516c\u5f0f\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58";
                        }
                        if (StringUtils.isEmpty((CharSequence)uniqueBean.getProperty())) {
                            String property = "CALC" + PinYinUtil.getUUID(10);
                            uniqueBean.setProperty(property);
                            columnVo.setProperty(property);
                        }
                    } else {
                        uniqueBean.setProperty(columnVo.getProperty());
                    }
                    uniqueBean.setFormula(columnVo.getFormula());
                    uniqueBean.setParentId(columnVo.getParentId());
                    uniqueBean.setSearchFlag(columnVo.getSearchFlag());
                    uniqueBean.setVisible(columnVo.getVisible());
                    uniqueBean.setColFixed(columnVo.getColFixed());
                    uniqueBean.setColFontBold(columnVo.getColFontBold());
                    uniqueBean.setColBgColor(columnVo.getColBgColor());
                    uniqueBean.setColFontColor(columnVo.getColFontColor());
                    uniqueBean.setSequence(columnVo.getSequence());
                    uniqueBean.setFormatter(columnVo.getFormatter());
                    uniqueBean.setEnableSummarize(columnVo.getEnableSummarize());
                    uniqueBean.setExportFormat(columnVo.getExportFormat());
                    uniqueBean.setAlignType(columnVo.getAlignType());
                    uniqueBean.setSuffixStr(columnVo.getSuffixStr());
                    uniqueBean.setColExtraInfo(columnVo.getColExtraInfo());
                    uniqueBean.setLinkType(columnVo.getLinkType());
                    uniqueBean.setLinkContent(columnVo.getLinkContent());
                    uniqueBean.setDataX(columnVo.getDataX());
                    uniqueBean.setDataY(columnVo.getDataY());
                    uniqueBean.setDataTotal(columnVo.getDataTotal());
                    uniqueBean.setUnitFlag(columnVo.getUnitFlag());
                    uniqueBean.setWidth(columnVo.getWidth());
                    uniqueBean.setNewLineFlag(columnVo.getNewLineFlag());
                    if (StringUtils.isBlank((CharSequence)columnVo.getFormula()) && StringUtils.isNotBlank((CharSequence)(checkResult2 = this.uniqueCheck(uniqueBean)))) {
                        return checkResult2;
                    }
                    if (StringUtils.isNotBlank((CharSequence)uniqueBean.getProperty())) {
                        String columnProperty = "";
                        columnProperty = "string".equals(uniqueBean.getType()) ? "VARCHAR(255)" : ("number".equals(uniqueBean.getType()) ? "BIGINT(20)" : ("decimal".equals(uniqueBean.getType()) ? "DECIMAL(28,8)" : ("time".equals(uniqueBean.getType()) ? "datetime" : "VARCHAR(255)")));
                        if (alterCol) {
                            String existColSql = "SELECT COUNT(*) FROM information_schema.columns WHERE table_name = 'report_" + tableEntity.getIndexName() + "' AND column_name = '" + uniqueBean.getProperty() + "' ";
                            Integer existColInt = this.tableService.queryColCount(existColSql);
                            if (existColInt > 0) {
                                String dropSqlCol = "ALTER TABLE `report_" + tableEntity.getIndexName() + "` DROP COLUMN `" + uniqueBean.getProperty() + "` ";
                                this.tableService.executeSql(dropSqlCol);
                            }
                            String addColSql = "ALTER TABLE `report_" + tableEntity.getIndexName() + "` ADD COLUMN `" + uniqueBean.getProperty() + "` " + columnProperty + " DEFAULT NULL COMMENT '" + uniqueBean.getColumnName() + "' ";
                            this.tableService.executeSql(addColSql);
                        }
                    }
                    saveList.add(uniqueBean);
                    continue;
                }
                ColumnEntity saveBean = (ColumnEntity)((Object)BeanMapper.map((Object)columnVo, ColumnEntity.class));
                if (resetBaseInfo) {
                    this.resetBaseInfo(saveBean);
                }
                if (StringUtils.isNotBlank((CharSequence)columnVo.getFormula())) {
                    Boolean checked = CalculatorUtils.simpleMathFormuaCheck(columnVo.getFormula());
                    if (!checked.booleanValue()) {
                        return "\u516c\u5f0f\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58";
                    }
                    if (StringUtils.isEmpty((CharSequence)columnVo.getProperty())) {
                        String property = "CALC" + PinYinUtil.getUUID(10);
                        saveBean.setProperty(property);
                        columnVo.setProperty(property);
                    }
                } else {
                    saveBean.setProperty(columnVo.getProperty());
                }
                if (columnVo.getSearchFlag() == null) {
                    saveBean.setSearchFlag(0);
                }
                if (columnVo.getUnitFlag() == null) {
                    saveBean.setUnitFlag(0);
                }
                if (StringUtils.isBlank((CharSequence)columnVo.getFormula()) && StringUtils.isNotBlank((CharSequence)(checkResult = this.uniqueCheck(saveBean)))) {
                    return checkResult;
                }
                if (StringUtils.isNotBlank((CharSequence)saveBean.getProperty())) {
                    String columnProperty = "";
                    columnProperty = "string".equals(saveBean.getType()) ? "VARCHAR(255)" : ("number".equals(saveBean.getType()) ? "BIGINT(20)" : ("decimal".equals(saveBean.getType()) ? "DECIMAL(28,8)" : ("time".equals(saveBean.getType()) ? "datetime" : "VARCHAR(255)")));
                    String existColSql = "SELECT COUNT(*) FROM information_schema.columns WHERE table_name = 'report_" + tableEntity.getIndexName() + "' AND column_name = '" + saveBean.getProperty() + "' ";
                    Integer existColInt = this.tableService.queryColCount(existColSql);
                    if (existColInt > 0) {
                        String dropSqlCol = "ALTER TABLE `report_" + tableEntity.getIndexName() + "` DROP COLUMN `" + saveBean.getProperty() + "` ";
                        this.tableService.executeSql(dropSqlCol);
                    }
                    String addColSql = "ALTER TABLE `report_" + tableEntity.getIndexName() + "` ADD COLUMN `" + saveBean.getProperty() + "` " + columnProperty + " DEFAULT NULL COMMENT '" + saveBean.getColumnName() + "' ";
                    this.tableService.executeSql(addColSql);
                }
                saveList.add(saveBean);
            }
            this.saveOrUpdateBatch(saveList);
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e/\u66f4\u65b0\u5b57\u6bb5\u5f02\u5e38,", (Throwable)e);
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b57\u6bb5\u65b0\u589e/\u66f4\u65b0\u5b57\u6bb5\u5f02\u5e38\uff01");
        }
        return null;
    }

    public String uniqueCheck(ColumnEntity checkBean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_id", (Object)checkBean.getTableId());
        queryWrapper.eq((Object)"property", (Object)checkBean.getProperty());
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.ne((Object)"id", (Object)checkBean.getId());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)checkBean.getFormula())) {
            return "\u5c5e\u6027:" + checkBean.getProperty() + "\u5df2\u5b58\u5728";
        }
        List tenantCol = list.stream().filter(col -> col.getTenantId().equals(InvocationInfoProxy.getTenantid())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tenantCol)) {
            return "\u5217\u540d:" + checkBean.getColumnName() + "\u5df2\u5b58\u5728";
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdateColumn(ColumnVO columnVo) {
        ArrayList<Object> cols = new ArrayList<ColumnVO>();
        cols.add(columnVo);
        String msg = this.saveOrUpdateColumnBatch(cols, false);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        if (columnVo.getDataX() != null && columnVo.getDataX().booleanValue()) {
            cols = new ArrayList();
            QueryParam param = new QueryParam();
            param.getParams().put("dataX", new Parameter("eq", (Object)true));
            param.getParams().put("tableId", new Parameter("eq", (Object)columnVo.getTableId()));
            List list = this.queryList(param, false);
            for (ColumnEntity columnEntity : list) {
                if (columnEntity.getProperty().equals(columnVo.getProperty())) continue;
                columnEntity.setDataX(false);
                cols.add((ColumnVO)BeanMapper.map((Object)((Object)columnEntity), ColumnVO.class));
            }
            if (ListUtil.isNotEmpty(cols)) {
                msg = this.saveOrUpdateColumnBatch(cols, false);
            }
        }
        return msg;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String savePubColsData(List<ColumnVO> cols) {
        return this.saveOrUpdateColumnBatch(cols, true);
    }

    @Override
    public void syncColumnsBatch(List<ColumnEntity> columns) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(columns.get(0).getTableId()));
        try {
            String createTblSql = "CREATE TABLE IF NOT EXISTS `report_" + tableEntity.getIndexName() + "` (`uuid` BIGINT(20) NOT NULL COMMENT '\u4e3b\u952eID', `creator_space` BIGINT(20) DEFAULT NULL COMMENT '\u79df\u6237\u9694\u79bb\u5b57\u6bb5', `data_sequence` int(11) DEFAULT NULL COMMENT '\u6392\u5e8f\u5b57\u6bb5', PRIMARY KEY (`uuid`) USING BTREE, KEY `idx_" + tableEntity.getIndexName() + "_creator_space`(`creator_space`) USING BTREE ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='" + tableEntity.getTableName() + "' ";
            this.tableService.executeSql(createTblSql);
        }
        catch (Exception e) {
            this.logger.error("\u8868-\u3010{}\u3011\u5b58\u5728\u5f02\u5e38\uff01", (Object)tableEntity.getIndexName(), (Object)e);
        }
        for (ColumnEntity columnEntity : columns) {
            if (StringUtils.isBlank((CharSequence)columnEntity.getProperty())) continue;
            String columnProperty = "";
            columnProperty = "string".equals(columnEntity.getType()) ? "VARCHAR(255)" : ("number".equals(columnEntity.getType()) ? "BIGINT(20)" : ("decimal".equals(columnEntity.getType()) ? "DECIMAL(28,8)" : ("time".equals(columnEntity.getType()) ? "datetime" : "VARCHAR(255)")));
            String existColSql = "SELECT COUNT(*) FROM information_schema.columns WHERE table_name = 'report_" + tableEntity.getIndexName() + "' AND column_name = '" + columnEntity.getProperty() + "' ";
            Integer existColInt = this.tableService.queryColCount(existColSql);
            if (existColInt > 0) {
                String dropSqlCol = "ALTER TABLE `report_" + tableEntity.getIndexName() + "` DROP COLUMN `" + columnEntity.getProperty() + "` ";
                this.tableService.executeSql(dropSqlCol);
            }
            String addColSql = "ALTER TABLE `report_" + tableEntity.getIndexName() + "` ADD COLUMN `" + columnEntity.getProperty() + "` " + columnProperty + " DEFAULT NULL COMMENT '" + columnEntity.getColumnName() + "' ";
            this.tableService.executeSql(addColSql);
        }
    }

    @Override
    public Integer getCurrentMaxColSeq(Long tableId) {
        Integer resp = 0;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"table_id", (Object)tableId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.select(new String[]{"max(sequence) as maxSequence"});
        Map result = super.getMap((Wrapper)query);
        if (null != result) {
            resp = null != result.get("maxSequence") ? Integer.valueOf(result.get("maxSequence").toString()) : resp;
        }
        return resp;
    }

    @Override
    public IPage<JSONObject> queryPageList(TableEntity tableEntity, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap, boolean isHighLightSearchFields) {
        String tableName = "report_" + tableEntity.getIndexName();
        String whereSQL = " `creator_space` =  " + InvocationInfoProxy.getTenantid();
        for (Map.Entry entry : queryParam.getParams().entrySet()) {
            String[] dataArr;
            ColumnEntity columnEntity;
            QueryWrapper columnWrapper;
            String paramValue;
            String string = (String)entry.getKey();
            if ("creator_space".equals(string)) continue;
            Parameter param = (Parameter)entry.getValue();
            if ("eq".equals(param.getType())) {
                paramValue = param.getValue() + "";
                if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                paramValue = paramValue.replace("\"", "");
                paramValue = paramValue.replace("'", "");
                paramValue = paramValue.replace("[", "");
                paramValue = paramValue.replace("]", "");
                paramValue = paramValue.replace("\\", "");
                paramValue = paramValue.replace("\n", "");
                paramValue = paramValue.replace("\t", "");
                paramValue = paramValue.replace(";", "\uff1b");
                paramValue = paramValue.replace("^", "");
                paramValue = paramValue.replace("--", "\u2015");
                whereSQL = whereSQL + " AND `" + string + "` = '" + paramValue + "' ";
                continue;
            }
            if ("like".equals(param.getType())) {
                paramValue = param.getValue() + "";
                if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                paramValue = paramValue.replace("\"", "");
                paramValue = paramValue.replace("'", "");
                paramValue = paramValue.replace("[", "");
                paramValue = paramValue.replace("]", "");
                paramValue = paramValue.replace("\\", "");
                paramValue = paramValue.replace("\n", "");
                paramValue = paramValue.replace("\t", "");
                paramValue = paramValue.replace(";", "\uff1b");
                paramValue = paramValue.replace("^", "");
                paramValue = paramValue.replace("--", "\u2015");
                whereSQL = whereSQL + " AND `" + string + "` LIKE '%" + paramValue + "%' ";
                continue;
            }
            if ("in".equals(param.getType())) {
                columnWrapper = new QueryWrapper();
                columnWrapper.eq((Object)"property", (Object)string);
                columnWrapper.eq((Object)"table_id", (Object)tableEntity.getId());
                columnEntity = (ColumnEntity)((Object)this.columnMapper.selectOne((Wrapper)columnWrapper));
                if ("number".equals(columnEntity.getType()) || "decimal".equals(columnEntity.getType())) {
                    String paramValue2 = param.getValue() + "";
                    if (!StringUtils.isNotBlank((CharSequence)paramValue2)) continue;
                    paramValue2 = paramValue2.replace("\"", "");
                    paramValue2 = paramValue2.replace("'", "");
                    paramValue2 = paramValue2.replace("[", "");
                    paramValue2 = paramValue2.replace("]", "");
                    paramValue2 = paramValue2.replace("\\", "");
                    paramValue2 = paramValue2.replace("\n", "");
                    paramValue2 = paramValue2.replace("\t", "");
                    paramValue2 = paramValue2.replace(";", "\uff1b");
                    paramValue2 = paramValue2.replace("^", "");
                    if (!StringUtils.isNotBlank((CharSequence)(paramValue2 = paramValue2.replace("--", "\u2015")))) continue;
                    whereSQL = whereSQL + " AND `" + string + "` IN (" + paramValue2 + ") ";
                    continue;
                }
                dataArr = param.getValue().toString().split(",");
                String paramValue3 = "";
                for (String str : dataArr) {
                    str = str.replace("\"", "");
                    str = str.replace("'", "");
                    str = str.replace("[", "");
                    str = str.replace("]", "");
                    str = str.replace("\\", "");
                    str = str.replace("\n", "");
                    str = str.replace("\t", "");
                    str = str.replace(";", "\uff1b");
                    str = str.replace("^", "");
                    str = str.replace("--", "\u2015");
                    paramValue3 = paramValue3 + "'" + str + "',";
                }
                if (!StringUtils.isNotBlank((CharSequence)paramValue3)) continue;
                paramValue3 = paramValue3.substring(0, paramValue3.length() - 1);
                whereSQL = whereSQL + " AND `" + string + "` IN (" + paramValue3 + ") ";
                continue;
            }
            if ("between".equals(param.getType())) {
                columnWrapper = new QueryWrapper();
                columnWrapper.eq((Object)"property", (Object)string);
                columnWrapper.eq((Object)"table_id", (Object)tableEntity.getId());
                columnEntity = (ColumnEntity)((Object)this.columnMapper.selectOne((Wrapper)columnWrapper));
                if ("number".equals(columnEntity.getType()) || "decimal".equals(columnEntity.getType())) {
                    dataArr = param.getValue().toString().split(",");
                    whereSQL = whereSQL + " AND ( `" + string + "` BETWEEN " + dataArr[0] + " AND " + dataArr[1] + " )";
                    continue;
                }
                dataArr = param.getValue().toString().split(",");
                String data0 = dataArr[0];
                data0 = data0.replace("\"", "");
                data0 = data0.replace("'", "");
                data0 = data0.replace("[", "");
                data0 = data0.replace("]", "");
                data0 = data0.replace("\\", "");
                data0 = data0.replace("\n", "");
                data0 = data0.replace("\t", "");
                data0 = data0.replace(";", "\uff1b");
                data0 = data0.replace("^", "");
                data0 = data0.replace("--", "\u2015");
                String data1 = dataArr[1];
                data1 = data1.replace("\"", "");
                data1 = data1.replace("'", "");
                data1 = data1.replace("[", "");
                data1 = data1.replace("]", "");
                data1 = data1.replace("\\", "");
                data1 = data1.replace("\n", "");
                data1 = data1.replace("\t", "");
                data1 = data1.replace(";", "\uff1b");
                data1 = data1.replace("^", "");
                data1 = data1.replace("--", "\u2015");
                whereSQL = whereSQL + " AND ( `" + string + "` BETWEEN '" + data0 + "' AND '" + data1 + "' ) ";
                continue;
            }
            if ("gt".equals(param.getType())) {
                if (!NumberUtils.isNumber((String)(param.getValue() + ""))) {
                    paramValue = param.getValue() + "";
                    if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                    paramValue = paramValue.replace("\"", "");
                    paramValue = paramValue.replace("'", "");
                    paramValue = paramValue.replace("[", "");
                    paramValue = paramValue.replace("]", "");
                    paramValue = paramValue.replace("\\", "");
                    paramValue = paramValue.replace("\n", "");
                    paramValue = paramValue.replace("\t", "");
                    paramValue = paramValue.replace(";", "\uff1b");
                    paramValue = paramValue.replace("^", "");
                    paramValue = paramValue.replace("--", "\u2015");
                    whereSQL = whereSQL + " AND `" + string + "` > '" + paramValue + "' ";
                    continue;
                }
                whereSQL = whereSQL + " AND `" + string + "` > " + param.getValue() + " ";
                continue;
            }
            if ("ge".equals(param.getType())) {
                if (!NumberUtils.isNumber((String)(param.getValue() + ""))) {
                    paramValue = param.getValue() + "";
                    if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                    paramValue = paramValue.replace("\"", "");
                    paramValue = paramValue.replace("'", "");
                    paramValue = paramValue.replace("[", "");
                    paramValue = paramValue.replace("]", "");
                    paramValue = paramValue.replace("\\", "");
                    paramValue = paramValue.replace("\n", "");
                    paramValue = paramValue.replace("\t", "");
                    paramValue = paramValue.replace(";", "\uff1b");
                    paramValue = paramValue.replace("^", "");
                    paramValue = paramValue.replace("--", "\u2015");
                    whereSQL = whereSQL + " AND `" + string + "` >= '" + paramValue + "' ";
                    continue;
                }
                whereSQL = whereSQL + " AND `" + string + "` >= " + param.getValue() + " ";
                continue;
            }
            if ("lt".equals(param.getType())) {
                if (!NumberUtils.isNumber((String)(param.getValue() + ""))) {
                    paramValue = param.getValue() + "";
                    if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                    paramValue = paramValue.replace("\"", "");
                    paramValue = paramValue.replace("'", "");
                    paramValue = paramValue.replace("[", "");
                    paramValue = paramValue.replace("]", "");
                    paramValue = paramValue.replace("\\", "");
                    paramValue = paramValue.replace("\n", "");
                    paramValue = paramValue.replace("\t", "");
                    paramValue = paramValue.replace(";", "\uff1b");
                    paramValue = paramValue.replace("^", "");
                    paramValue = paramValue.replace("--", "\u2015");
                    whereSQL = whereSQL + " AND `" + string + "` < '" + paramValue + "' ";
                    continue;
                }
                whereSQL = whereSQL + " AND `" + string + "` < " + param.getValue() + " ";
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            if (!NumberUtils.isNumber((String)(param.getValue() + ""))) {
                paramValue = param.getValue() + "";
                if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                paramValue = paramValue.replace("\"", "");
                paramValue = paramValue.replace("'", "");
                paramValue = paramValue.replace("[", "");
                paramValue = paramValue.replace("]", "");
                paramValue = paramValue.replace("\\", "");
                paramValue = paramValue.replace("\n", "");
                paramValue = paramValue.replace("\t", "");
                paramValue = paramValue.replace(";", "\uff1b");
                paramValue = paramValue.replace("^", "");
                paramValue = paramValue.replace("--", "\u2015");
                whereSQL = whereSQL + " AND `" + string + "` <= '" + paramValue + "' ";
                continue;
            }
            whereSQL = whereSQL + " AND `" + string + "` <= " + param.getValue() + " ";
        }
        String orderBySql = "ORDER BY data_sequence ASC";
        if (queryParam.getOrderMap() != null && !queryParam.getOrderMap().isEmpty()) {
            orderBySql = "ORDER BY ";
            for (Map.Entry entry : queryParam.getOrderMap().entrySet()) {
                orderBySql = orderBySql + "`" + (String)entry.getKey() + "` " + (String)entry.getValue() + ",";
            }
            if (orderBySql.endsWith(",")) {
                orderBySql = orderBySql.substring(0, orderBySql.length() - 1);
            }
        }
        String pageSql = "";
        if (queryParam.getPageSize() > 0) {
            pageSql = " LIMIT " + queryParam.getPageSize() * (queryParam.getPageIndex() - 1) + "," + queryParam.getPageSize();
        }
        String string = "SELECT * FROM " + tableName + " WHERE " + whereSQL + " " + orderBySql + " " + pageSql;
        String countSql = "SELECT count(*) FROM " + tableName + " WHERE " + whereSQL;
        this.logger.info("\u67e5\u8be2\u6570\u636eSQL\uff1a{}", (Object)string);
        List<JSONObject> dataList = this.tableMapper.queryDataBySql(string);
        Long dataCount = this.tableMapper.queryCountBySql(countSql);
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        pageData.setRecords(dataList);
        pageData.setTotal(dataCount.longValue());
        return pageData;
    }

    @Override
    public String getCurrentTableCreateSql(Long tableId) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(tableId));
        String createTblSql = "CREATE TABLE IF NOT EXISTS `report_" + tableEntity.getIndexName() + "` (`uuid` BIGINT(20) NOT NULL COMMENT '\u4e3b\u952eID', `creator_space` BIGINT(20) DEFAULT NULL COMMENT '\u79df\u6237\u9694\u79bb\u5b57\u6bb5', `data_sequence` int(11) DEFAULT NULL COMMENT '\u6392\u5e8f\u5b57\u6bb5', ";
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"table_id", (Object)tableId);
        List columns = this.columnMapper.selectList((Wrapper)query);
        for (ColumnEntity columnEntity : columns) {
            if (StringUtils.isBlank((CharSequence)columnEntity.getProperty())) continue;
            String columnProperty = "";
            columnProperty = "string".equals(columnEntity.getType()) ? "VARCHAR(255)" : ("number".equals(columnEntity.getType()) ? "BIGINT(20)" : ("decimal".equals(columnEntity.getType()) ? "DECIMAL(28,8)" : ("time".equals(columnEntity.getType()) ? "datetime" : "VARCHAR(255)")));
            createTblSql = createTblSql + " `" + columnEntity.getProperty() + "` " + columnProperty + " DEFAULT NULL COMMENT '" + columnEntity.getColumnName() + "', ";
        }
        createTblSql = createTblSql + " PRIMARY KEY (`uuid`) USING BTREE, KEY `idx_" + tableEntity.getIndexName() + "_creator_space`(`creator_space`) USING BTREE ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='" + tableEntity.getTableName() + "' ";
        return createTblSql;
    }

    @Override
    public String getCurrentTableCreateSqlByAiPromt(Long tableId) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(tableId));
        Long tenantId = InvocationInfoProxy.getTenantid();
        String queryTblSql = "SELECT * FROM `report_" + tableEntity.getIndexName() + "` WHERE creator_space=" + tenantId + " limit 0,1";
        List<JSONObject> jsonObjs = this.tableMapper.queryDataBySql(queryTblSql);
        JSONObject jsonObj = null;
        if (jsonObjs != null && jsonObjs.size() > 0) {
            jsonObj = jsonObjs.get(0);
        }
        String createTblSql = "CREATE TABLE `report_" + tableEntity.getIndexName() + "` ( ";
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"table_id", (Object)tableId);
        List columns = this.columnMapper.selectList((Wrapper)query);
        ColumnEntity columnEntity = null;
        for (int i = 0; i < columns.size(); ++i) {
            columnEntity = (ColumnEntity)((Object)columns.get(i));
            if (StringUtils.isBlank((CharSequence)columnEntity.getProperty())) continue;
            if (jsonObj != null) {
                try {
                    Long jsonValLong;
                    String jsonVal = jsonObj.getString(columnEntity.getProperty());
                    if (jsonVal != null && ((jsonValLong = Long.valueOf(Long.parseLong(jsonVal))) > 99999999999999999L || jsonValLong < 5L)) {
                        continue;
                    }
                }
                catch (Exception jsonVal) {
                    // empty catch block
                }
            }
            String columnDesc = columnEntity.getColumnName();
            if (StringUtils.isNotBlank((CharSequence)columnEntity.getColExtraInfo())) {
                columnDesc = columnDesc + ";" + columnEntity.getColExtraInfo();
            }
            createTblSql = i == columns.size() - 1 ? createTblSql + " `" + columnEntity.getProperty() + "` -- '" + columnDesc + "'" : createTblSql + " `" + columnEntity.getProperty() + "` -- '" + columnDesc + "', ";
        }
        createTblSql = createTblSql + " ) ";
        return createTblSql;
    }

    @Override
    public List<ColumnEntity> queryColumnListByTblId(Long tableId) {
        List<ColumnEntity> columnList = this.columnMapper.queryColumnListByTblId(tableId);
        return columnList;
    }

    private void resetBaseInfo(BaseEntity entity) {
        entity.setCreateUserCode(this.sysUserCode);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(this.sysUserCode);
        entity.setVersion(Integer.valueOf(0));
    }

    public static void main(String[] args) {
        System.out.println(true);
    }
}

