package com.ejianc.foundation.chat.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import okhttp3.*;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;


public class BaiduQianfanUtils {

    private static final Logger logger = LoggerFactory.getLogger(BaiduQianfanUtils.class);
    //新建对话
    public static final String conversation = "https://qianfan.baidubce.com/v2/app/conversation";
    public static final String uploadFile = "https://qianfan.baidubce.com/v2/app/conversation/file/upload";
    public static final String conversationRun = "https://qianfan.baidubce.com/v2/app/conversation/runs";

    public static final String knowledgeBaseImport = "https://qianfan.baidubce.com/v2/knowledgeBase?Action=ImportDocuments";
    public static final String filesImport = "https://qianfan.baidubce.com/v2/files";
//    public static final String APP_ID = "e5fcc66c-a174-4efe-9b21-bda373cc8816";
//    public static final String SECRET_KEY = "Bearer bce-v3/ALTAK-2M4n5pMZ8iRjJiaD7Ww5N/86fae65df7bef687132a4a0606bfe98e0b1e0747";
    public static final String APP_ID = "f7a3d4c0-120b-4957-96e6-b8ac4731f71d";
    public static final String SECRET_KEY = "Bearer bce-v3/ALTAK-pmCGkekT1FtLrMSauUi73/e695deb150fe27ad0a6a41010b4eb42bc8260458";
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder()
            .connectTimeout(10, TimeUnit.MINUTES)
            .readTimeout(10, TimeUnit.MINUTES)
            .writeTimeout(10, TimeUnit.MINUTES)
            .build();
    private static final MediaType mediaType = MediaType.parse("application/json");

    /**
     * 调用千帆大模型appbuilder
     * */
    public  String postChatMsg(String content,String conversationId) {
        try {
            content = "根据知识库回答问题："+content+"？" ;
//                    + "要求：给出指定json格式的内容输出。注意：1、回答问题时仅根据知识库文档中出现的内容回答，不要随意重组2、不要其他额外分析性文字; 3、返回json格式内容要求是：[{\"projectName\"：\"项目名称\",\"money\"：\"合同额（万元）\"}]";
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", APP_ID);
            msgBody.put("query", content);
            msgBody.put("stream", false);
            msgBody.put("conversation_id", conversationId);
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("type", "function");
//                JSONObject function = new JSONObject();
//                function.put("name", "LongDocUnderstand");
//                jsonObject.put("function", function);
//            msgBody.put("tool_choice", jsonObject);
//            msgBody.put("file_ids", Arrays.asList(fileId));

            RequestBody body = RequestBody.create(mediaType, msgBody.toJSONString());
            Request request = new Request.Builder()
                    .url(conversationRun)
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json;charset=utf-8")
                    .addHeader("X-Appbuilder-Authorization", SECRET_KEY)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject(response.body().string());
            return resBody.getString("answer");
        } catch (Exception e) {
            logger.error("error：{}", e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 调用千帆大模型appbuilder
     * */
    public  String postChatTextMsg(String content,String conversationId,String textRecords) {
        try {
            content = "我将提供下列json格式的数据："+textRecords+"。根据的提供的数据回答问题："+content+"？" +
                    "要求：给出指定json格式的内容输出。注意：1、回答问题时仅根据提供的json数据中出现的内容回答内容，不要随意重组2、不要其他额外分析性文字; 3、返回json格式内容要求是：[{\"projectName\"：\"项目名称\",\"money\"：\"合同额（万元）\"}]";
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", APP_ID);
            msgBody.put("query", content);
            msgBody.put("stream", false);
            msgBody.put("conversation_id", conversationId);
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("type", "function");
//                JSONObject function = new JSONObject();
//                function.put("name", "LongDocUnderstand");
//                jsonObject.put("function", function);
//            msgBody.put("tool_choice", jsonObject);
//            msgBody.put("file_ids", Arrays.asList(fileId));

            RequestBody body = RequestBody.create(mediaType, msgBody.toJSONString());
            Request request = new Request.Builder()
                    .url(conversationRun)
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json;charset=utf-8")
                    .addHeader("X-Appbuilder-Authorization", SECRET_KEY)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject(response.body().string());
            return resBody.getString("answer");
        } catch (Exception e) {
            logger.error("error：{}", e.getMessage());
            e.printStackTrace();
        }
        return null;
    }


    public String uploadLocalFile( String conversationId,String fileName) {
        File file = null;
        try {
            file = new File(fileName);

//            String str = "姓名：张三，年龄：30，性别：男；" +
//                    "姓名：李四，年龄：20，性别：女；";
//            FileOutputStream baos = new FileOutputStream(file);
//            baos.write(str.getBytes());
//            baos.flush();

            RequestBody body = new MultipartBody.Builder().setType(MultipartBody.FORM)
                    .addFormDataPart("app_id", APP_ID)
                    .addFormDataPart("file", fileName,
                            RequestBody.create(MediaType.parse("application/octet-stream"),
                                    file))
                    .addFormDataPart("conversation_id", conversationId)
                    .build();
            Request request = new Request.Builder()
                    .url("https://qianfan.baidubce.com/v2/app/conversation/file/upload")
                    .method("POST", body)
                    .addHeader("Content-Type", "multipart/form-data")
                    .addHeader("X-Appbuilder-Authorization", SECRET_KEY)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject(response.body().string());
            return qFanContent.getString("id");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("error：{}", e.getMessage());
        }finally {
            if(file.exists()){
                boolean delete = file.delete();
                logger.info("---------------------删除文件："+fileName+"结果："+delete);
            }
        }
        return null;
    }

    /**
     * 调用千帆大模型appbuilder，获取会话id
     * */
    public String getNewConversationId() {
        try {
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", APP_ID);
            RequestBody body = RequestBody.create(mediaType, msgBody.toJSONString());
            Request request = new Request.Builder()
                    .url(conversation)
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json")
                    .addHeader("X-Appbuilder-Authorization", SECRET_KEY)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject(response.body().string());
            return resBody.getString("conversation_id");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     *
     *上传文件到知识库
     * @param
     */
    public static String filesImport(String fileName){

        File file = null;
        try {
            file = new File(fileName);

            String str = "姓名：张三，年龄：30，性别：男；" +
                    "姓名：李四，年龄：20，性别：女；";
            FileOutputStream baos = new FileOutputStream(file);
            baos.write(str.getBytes());
            baos.flush();

            RequestBody body = new MultipartBody.Builder().setType(MultipartBody.FORM)
                    .addFormDataPart("purpose", "assistants")
                    .addFormDataPart("file", fileName,
                            RequestBody.create(MediaType.parse("application/octet-stream"),
                                    file))
                    .build();
            Request request = new Request.Builder()
                    .url(filesImport)
                    .method("POST", body)
                    .addHeader("Content-Type", "multipart/form-data")
                    .addHeader("Authorization", SECRET_KEY)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject(response.body().string());
            baos.close();
            return qFanContent.getString("id");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("error：{}", e.getMessage());
        }finally {

            if(file.exists()){
                boolean delete = file.delete();
                logger.info("---------------------删除文件："+fileName+"结果："+delete);
            }
        }
        return null;
    }
    public static String knowledgeBaseImport(String fileId){

        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", "upload");
            jsonObject.put("filesId", Arrays.asList(fileId));

            JSONObject msgBody = new JSONObject();
            msgBody.put("id", "ca4bce3e-030b-4142-b232-348dd7bbecf3");
            msgBody.put("source", jsonObject.toString());

            MediaType mediaType = MediaType.parse("multipart/form-data");
            RequestBody body = new MultipartBody.Builder().setType(MultipartBody.FORM)
                    .addFormDataPart("payload",msgBody.toString())
                    .build();
            Request request = new Request.Builder()
                    .url("https://qianfan.baidubce.com/v2/knowledgeBase?Action=UploadDocuments")
                    .method("POST", body)
                    .addHeader("Content-Type", "multipart/form-data")
                    .addHeader("Authorization", "Bearer bce-v3/ALTAK-pmCGkekT1FtLrMSauUi73/e695deb150fe27ad0a6a41010b4eb42bc8260458")
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject(response.body().string());
            return resBody.getString("requestId");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("error：{}", e.getMessage());
        }
        return null;
    }


    public static void main(String[] args) throws Exception{
//        String s = getNewConversationId();
//        String s = uploadLocalFile("ba5dff50-8ad8-4d10-a297-b301178ad953", "didi.xlsx");
        String s = filesImport("didi.xlsx");
//        String s = knowledgeBaseImport("file-ssqghiaw");
        System.out.println(s);
//        {
//          "id":"ca4bce3e-030b-4142-b232-348dd7bbecf3",
//          "source":{
//            "type":"upload",
//            "filesId":["file-pipzfvbx"]
//          }
//        }


        //{
        //    "request_id": "4217f439-c7b4-4489-96ee-5647c8068a79",
        //    "id": "file-isg8hqe2",
        //    "conversation_id": "ba5dff50-8ad8-4d10-a297-b301178ad953"
        //}
    }
}
