package com.ejianc.foundation.chat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.ai.api.IAgentApi;
import com.ejianc.foundation.ai.api.param.ChatParam;
import com.ejianc.foundation.chat.bean.ChatExcelMsgEntity;
import com.ejianc.foundation.chat.controller.param.ChatExcelParam;
import com.ejianc.foundation.chat.helper.SSEEmitterHelper;
import com.ejianc.foundation.chat.mapper.ChatExcelMsgMapper;
import com.ejianc.foundation.chat.service.IChatExcelMsgService;
import com.ejianc.foundation.chat.utils.BaiduQianfanUtils;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.EasyExcelUtil;
import com.ejianc.framework.auth.shiro.AuthConstants;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CookieUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;

@Service("chatExcelMsgService")
public class ChatExcelMsgServiceImpl extends BaseServiceImpl<ChatExcelMsgMapper, ChatExcelMsgEntity> implements IChatExcelMsgService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SSEEmitterHelper sseEmitterHelper;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IAgentApi aiAgent;
    @Autowired
    private ChatExcelMsgMapper chatExcelMsgMapper;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private ColumnMapper columnMapper;

    @Value("${chat.agent.code:Yql_ChatReport}")
    private String chatExcelAgentCode; //默认AgentCode

    private void setInvocation(String authority) {
        // 如果header中包含，则以header为主，否则，以cookie为主
        if (org.apache.commons.lang3.StringUtils.isNotBlank(authority)) {
            Set<Cookie> cookieSet = new HashSet<Cookie>();
            String[] ac = authority.split(";");
            for (String s : ac) {
                String[] cookieArr = s.split("=");
                String key = org.apache.commons.lang3.StringUtils.trim(cookieArr[0]);
                String value = org.apache.commons.lang3.StringUtils.trim(cookieArr[1]);
                Cookie cookie = new Cookie(key, value);
                cookieSet.add(cookie);
            }
            Cookie[] cookies = cookieSet.toArray(new Cookie[] {});

            InvocationInfoProxy.setToken(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_TOKEN));
            InvocationInfoProxy.setUserid(Long.parseLong(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_USERID)));
            InvocationInfoProxy.setUsercode(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_USERCODE));
            InvocationInfoProxy.setTenantid(Long.parseLong(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_TENANTID)));
        }
    }

    private String getQueryParamSql(Long tenantId, String authority, TableEntity tableEntity) {
        String whereSQL = " `creator_space` =  "+ tenantId;
        String url  = tableEntity.getParamUrl();
        try {
            if(StringUtils.isNotBlank(url)) {
                if(!url.contains("http")) {
                    if(url.startsWith("/")){
                        url = url.substring(1);
                    }
                    url = environmentTools.getBaseHost() + url;
                }
                Map<String, String> header = new HashMap<>();
                header.put("authority", authority);
                header.put("content-type", "application/json;charset=UTF-8");
                String respStr = HttpTookit.get(url, new HashMap<>(), header);
                CommonResponse<JSONObject> params = JSONObject.parseObject(respStr, CommonResponse.class);
                if(!params.isSuccess()) {
                    logger.error("请求服务-【{}】获取报表参数失败，{}", url, params.getMsg());
                }
                QueryParam queryParam = JSONObject.parseObject(JSONObject.toJSONString(params.getData()), QueryParam.class);

                for(Map.Entry<String, Parameter> entry : queryParam.getParams().entrySet()) {
                    String key = entry.getKey();
                    Parameter param = entry.getValue();
                    if(QueryParam.EQ.equals(param.getType())) {
                        String paramValue = param.getValue()+"";
                        if(org.apache.commons.lang3.StringUtils.isNotBlank(paramValue)) {
                            paramValue = paramValue.replace("\"", "");
                            paramValue = paramValue.replace("'", "");
                            paramValue = paramValue.replace("[", "");
                            paramValue = paramValue.replace("]", "");
                            paramValue = paramValue.replace("\\", "");
                            paramValue = paramValue.replace("\n", "");
                            paramValue = paramValue.replace("\t", "");
                            paramValue = paramValue.replace(";", "；");
                            paramValue = paramValue.replace("^", "");
                            paramValue = paramValue.replace("--", "―");
                            whereSQL = whereSQL + " AND `" + key + "` = '" + paramValue + "' ";
                        }
                    }else if(QueryParam.LIKE.equals(param.getType())) {
                        String paramValue = param.getValue()+"";
                        if(org.apache.commons.lang3.StringUtils.isNotBlank(paramValue)) {
                            paramValue = paramValue.replace("\"", "");
                            paramValue = paramValue.replace("'", "");
                            paramValue = paramValue.replace("[", "");
                            paramValue = paramValue.replace("]", "");
                            paramValue = paramValue.replace("\\", "");
                            paramValue = paramValue.replace("\n", "");
                            paramValue = paramValue.replace("\t", "");
                            paramValue = paramValue.replace(";", "；");
                            paramValue = paramValue.replace("^", "");
                            paramValue = paramValue.replace("--", "―");
                            whereSQL  = whereSQL + " AND `" + key + "` LIKE '%" + paramValue + "%' ";
                        }
                    }else if(QueryParam.IN.equals(param.getType())) {
                        QueryWrapper<ColumnEntity> columnWrapper = new QueryWrapper<>();
                        columnWrapper.eq("property", key);
                        columnWrapper.eq("table_id", tableEntity.getId());
                        ColumnEntity columnEntity = columnMapper.selectOne(columnWrapper);
                        if("number".equals(columnEntity.getType()) || "decimal".equals(columnEntity.getType())) {
                            String paramValue = param.getValue() + "";
                            if(org.apache.commons.lang3.StringUtils.isNotBlank(paramValue)) {
                                paramValue = paramValue.replace("\"", "");
                                paramValue = paramValue.replace("'", "");
                                paramValue = paramValue.replace("[", "");
                                paramValue = paramValue.replace("]", "");
                                paramValue = paramValue.replace("\\", "");
                                paramValue = paramValue.replace("\n", "");
                                paramValue = paramValue.replace("\t", "");
                                paramValue = paramValue.replace(";", "；");
                                paramValue = paramValue.replace("^", "");
                                paramValue = paramValue.replace("--", "―");
                                if(StringUtils.isNotBlank(paramValue)) {
                                    whereSQL = whereSQL + " AND `" + key + "` IN (" + paramValue + ") ";
                                }
                            }
                        }else{
                            String[] dataArr = param.getValue().toString().split(",");
                            String paramValue = "";
                            for(String str : dataArr) {
                                str = str.replace("\"", "");
                                str = str.replace("'", "");
                                str = str.replace("[", "");
                                str = str.replace("]", "");
                                str = str.replace("\\", "");
                                str = str.replace("\n", "");
                                str = str.replace("\t", "");
                                str = str.replace(";", "；");
                                str = str.replace("^", "");
                                str = str.replace("--", "―");
                                paramValue = paramValue + "'" + str + "',";
                            }
                            if(org.apache.commons.lang3.StringUtils.isNotBlank(paramValue)) {
                                paramValue = paramValue.substring(0, paramValue.length()-1);
                                whereSQL  = whereSQL + " AND `" + key + "` IN (" + paramValue + ") ";
                            }
                        }
                    }else if(QueryParam.BETWEEN.equals(param.getType())) {
                        QueryWrapper<ColumnEntity> columnWrapper = new QueryWrapper<>();
                        columnWrapper.eq("property", key);
                        columnWrapper.eq("table_id", tableEntity.getId());
                        ColumnEntity columnEntity = columnMapper.selectOne(columnWrapper);
                        if("number".equals(columnEntity.getType()) || "decimal".equals(columnEntity.getType())) {
                            String[] dataArr = param.getValue().toString().split(",");
                            whereSQL = whereSQL + " AND ( `" + key + "` BETWEEN " + dataArr[0] + " AND " + dataArr[1] +" )";
                        }else{
                            String[] dataArr = param.getValue().toString().split(",");
                            String data0 = dataArr[0];
                            data0 = data0.replace("\"", "");
                            data0 = data0.replace("'", "");
                            data0 = data0.replace("[", "");
                            data0 = data0.replace("]", "");
                            data0 = data0.replace("\\", "");
                            data0 = data0.replace("\n", "");
                            data0 = data0.replace("\t", "");
                            data0 = data0.replace(";", "；");
                            data0 = data0.replace("^", "");
                            data0 = data0.replace("--", "―");
                            String data1 = dataArr[1];
                            data1 = data1.replace("\"", "");
                            data1 = data1.replace("'", "");
                            data1 = data1.replace("[", "");
                            data1 = data1.replace("]", "");
                            data1 = data1.replace("\\", "");
                            data1 = data1.replace("\n", "");
                            data1 = data1.replace("\t", "");
                            data1 = data1.replace(";", "；");
                            data1 = data1.replace("^", "");
                            data1 = data1.replace("--", "―");
                            whereSQL = whereSQL + " AND ( `" + key + "` BETWEEN '" + data0 + "' AND '" + data1 +"' ) ";
                        }
                    }else if(QueryParam.GT.equals(param.getType())) {
                        if(!org.apache.commons.lang.math.NumberUtils.isNumber(param.getValue()+"")) {
                            String paramValue = param.getValue()+"";
                            if(org.apache.commons.lang3.StringUtils.isNotBlank(paramValue)) {
                                paramValue = paramValue.replace("\"", "");
                                paramValue = paramValue.replace("'", "");
                                paramValue = paramValue.replace("[", "");
                                paramValue = paramValue.replace("]", "");
                                paramValue = paramValue.replace("\\", "");
                                paramValue = paramValue.replace("\n", "");
                                paramValue = paramValue.replace("\t", "");
                                paramValue = paramValue.replace(";", "；");
                                paramValue = paramValue.replace("^", "");
                                paramValue = paramValue.replace("--", "―");
                                whereSQL  = whereSQL + " AND `" + key + "` > '" + paramValue + "' ";
                            }
                        }else{
                            whereSQL  = whereSQL + " AND `" + key + "` > " + param.getValue() + " ";
                        }
                    }else if(QueryParam.GE.equals(param.getType())) {
                        if(!org.apache.commons.lang.math.NumberUtils.isNumber(param.getValue()+"")) {
                            String paramValue = param.getValue()+"";
                            if(org.apache.commons.lang3.StringUtils.isNotBlank(paramValue)) {
                                paramValue = paramValue.replace("\"", "");
                                paramValue = paramValue.replace("'", "");
                                paramValue = paramValue.replace("[", "");
                                paramValue = paramValue.replace("]", "");
                                paramValue = paramValue.replace("\\", "");
                                paramValue = paramValue.replace("\n", "");
                                paramValue = paramValue.replace("\t", "");
                                paramValue = paramValue.replace(";", "；");
                                paramValue = paramValue.replace("^", "");
                                paramValue = paramValue.replace("--", "―");
                                whereSQL  = whereSQL + " AND `" + key + "` >= '" + paramValue + "' ";
                            }
                        }else{
                            whereSQL  = whereSQL + " AND `" + key + "` >= " + param.getValue() + " ";
                        }
                    }else if(QueryParam.LT.equals(param.getType())) {
                        if(!org.apache.commons.lang.math.NumberUtils.isNumber(param.getValue()+"")) {
                            String paramValue = param.getValue()+"";
                            if(org.apache.commons.lang3.StringUtils.isNotBlank(paramValue)) {
                                paramValue = paramValue.replace("\"", "");
                                paramValue = paramValue.replace("'", "");
                                paramValue = paramValue.replace("[", "");
                                paramValue = paramValue.replace("]", "");
                                paramValue = paramValue.replace("\\", "");
                                paramValue = paramValue.replace("\n", "");
                                paramValue = paramValue.replace("\t", "");
                                paramValue = paramValue.replace(";", "；");
                                paramValue = paramValue.replace("^", "");
                                paramValue = paramValue.replace("--", "―");
                                whereSQL  = whereSQL + " AND `" + key + "` < '" + paramValue + "' ";
                            }
                        }else{
                            whereSQL  = whereSQL + " AND `" + key + "` < " + param.getValue() + " ";
                        }
                    }else if(QueryParam.LE.equals(param.getType())) {
                        if(!org.apache.commons.lang.math.NumberUtils.isNumber(param.getValue()+"")) {
                            String paramValue = param.getValue()+"";
                            if(org.apache.commons.lang3.StringUtils.isNotBlank(paramValue)) {
                                paramValue = paramValue.replace("\"", "");
                                paramValue = paramValue.replace("'", "");
                                paramValue = paramValue.replace("[", "");
                                paramValue = paramValue.replace("]", "");
                                paramValue = paramValue.replace("\\", "");
                                paramValue = paramValue.replace("\n", "");
                                paramValue = paramValue.replace("\t", "");
                                paramValue = paramValue.replace(";", "；");
                                paramValue = paramValue.replace("^", "");
                                paramValue = paramValue.replace("--", "―");

                                whereSQL  = whereSQL + " AND `" + key + "` <= '" + paramValue + "' ";
                            }
                        }else{
                            whereSQL  = whereSQL + " AND `" + key + "` <= " + param.getValue() + " ";
                        }
                    }
                }
            }
        } catch (Exception e) {
            logger.error("请求服务-【{}】获取报表参数失败，", url, e);
        }
        return whereSQL;
    }

    @Override
    public SseEmitter sendChatExcel(ChatExcelParam chatExcelParam, HttpServletRequest request) {
        SseEmitter sseEmitter = new SseEmitter(6000000L);
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        JSONObject res = new JSONObject();
        TableEntity tableEntity = tableService.getByCode(chatExcelParam.getChatExcelId());
        //保存提问信息
        Long chatExcelMsgId = null;
        ChatExcelMsgEntity chatExcelQuestionMsgEntity = null;
        if(chatExcelParam.getChatExcelSessionId() == null) {
            chatExcelMsgId = IdWorker.getId();
            chatExcelQuestionMsgEntity = new ChatExcelMsgEntity();
            chatExcelQuestionMsgEntity.setId(chatExcelMsgId);
            if(tableEntity != null){
                chatExcelQuestionMsgEntity.setChatExcelId(tableEntity.getId());
            }
            chatExcelQuestionMsgEntity.setUserId(userId);
            chatExcelQuestionMsgEntity.setContent(chatExcelParam.getContent());
            this.saveOrUpdate(chatExcelQuestionMsgEntity,false);
        }else{ //重新回复
            chatExcelQuestionMsgEntity = this.selectById(chatExcelParam.getChatExcelSessionId());
            chatExcelMsgId = chatExcelQuestionMsgEntity.getId();
        }

        String resStr = "";

        if(tableEntity == null) {
            resStr = "找不到对应的报表！";
            Long pkId = IdWorker.getId();
            saveChatExcelAnswer(pkId,chatExcelMsgId,null, userId, tenantId, resStr);
            res.put("botMsg",resStr);
            res.put("chatExcelId",chatExcelParam.getChatExcelId());
            res.put("chatExcelSessionId",chatExcelMsgId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        String authority = request.getHeader("authority");
        RequestAttributes context = RequestContextHolder.getRequestAttributes();
        context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
        //查询表头
        List<GridHeader> gridHeaders = columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        //先开启线程调用大模型： 自然语言转SQL
        FutureTask<Map<String, String>> futureTask = new FutureTask<>(new Callable<Map<String, String>>() {
            @Override
            public Map<String, String> call() throws Exception {
                InvocationInfoProxy.setUserid(userId);
                InvocationInfoProxy.setTenantid(tenantId);
                RequestContextHolder.setRequestAttributes(context);
                setInvocation(authority);

                Map<String, String> respMap = new HashMap<>();
                try {
                    String promptQuestion = "### 角色设定 \n" +
                            "你是一名资深数据库管理专家，拥有丰富的SQL知识功底，你的任务将自然语言转换成符合Mysql数据库语法的SQL查询语句。\n" +
                            "### 注意事项 \n" +
                            "1、返回内容仅仅是SQL语句即可,不需要分析性语句，以便我直接执行SQL；\n" +
                            "2、SQL末尾的分号去掉，不需要SQL末尾的分号；\n" +
                            "3、如果SQL条件判断语句中涉及到名称字段，要使用LIKE关键词查询；如果SQL条件判断语句中涉及到名称字段，那么查询结果也要包含名称类型字段，且放在第一位；\n" +
                            "4、查出的字段不要用 as 别名包装，确保字段在表中存在，不要臆造字段；\n" +
                            "5、特别注意，请确保在构建SQL查询时，不要使用AS语句来给结果列命名，不需要任何别名。\n" +
                            "6、字段名称使用`引起来，如：`name`,`code`等等。\n" +
                            "7、生成的SQL语句的关键字都需要小写字母； \n" +
                            "### 基于以下创建表语句进行回答：\n" +
                            columnService.getCurrentTableCreateSqlByAiPromt(tableEntity.getId()) + "\n" +
                            "### 提问内容:\n" +
                            chatExcelParam.getContent();
                    ChatParam chatParam = new ChatParam();
                    chatParam.setAgentCode(chatExcelAgentCode);
                    chatParam.setPromptContent(promptQuestion);

                    CommonResponse<String> response = aiAgent.chatWithAgentByApi(chatParam);
                    logger.info("请求参数：{}\r\n 响应数据：{}",JSONObject.toJSONString(chatParam),JSONObject.toJSONString(response));
                    if(response.isSuccess()) {
                        String sqlContent = response.getData();
                        respMap.put("code", "success");
                        respMap.put("sqlContent", sqlContent);
                        return respMap;
                    }else{
                        respMap.put("code", "failed");
                        respMap.put("errorMsg", response.getMsg());
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
                respMap.put("code", "failed");
                respMap.put("errorMsg", "AI大模型调用失败");
                return respMap;
            }
        });
        new Thread(futureTask).start();

        Long pkId = IdWorker.getId();
        final  Long fChatExcelMsgId = chatExcelMsgId;
        IChatExcelMsgService chatExcelMsgService = this;
        new Thread(new Runnable() {
            @Override
            public void run() {
                Random random = new Random();
                int randomNum = random.nextInt(3);
                if(1 == randomNum) {
                    res.put("botMsg","<div class=\"t-t-c\" ><div class=\"intr\">您好，我明白您的需求。接下来的计划是根据您提供的“"+tableEntity.getTableName()+"”表格，提取出相关数据，并展示出来；</div>");
                }else if(2 == randomNum){
                    res.put("botMsg","<div class=\"t-t-c\" ><div class=\"intr\">好的，接下来我会根据您提供的“"+tableEntity.getTableName()+"”表格，提取出相关数据，并展示出来；</div>");
                }else{
                    res.put("botMsg","<div class=\"t-t-c\" ><div class=\"intr\">好的，我已了解您的需求。接下来我会根据您提供的“"+tableEntity.getTableName()+"”表格，提取出相关数据，并展示出来；</div>");
                }
                res.put("chatExcelId",tableEntity.getId());
                res.put("chatExcelSessionId",fChatExcelMsgId);
                res.put("currentAnswerId",pkId);
                String resStr = res.getString("botMsg");
                sseEmitterHelper.sendComplete(sseEmitter, res);

                sleepThread();
                res.put("botMsg","<div class=\"think-step first\"><i class=\"anticon anticon-check-circle\"></i>提取报表：“"+tableEntity.getTableName()+"”中相关数据。</div>");
                resStr += res.getString("botMsg");
                sseEmitterHelper.sendComplete(sseEmitter, res);
                try {
                    Map<String, String> sqlMap = futureTask.get();
                    if("success".equals(sqlMap.get("code"))) {
                        res.put("botMsg","<div class=\"think-step second\"><i class=\"anticon anticon-check-circle\"></i>数据提取完成，分析相关数据。</div>");
                        resStr += res.getString("botMsg");
                        sseEmitterHelper.sendComplete(sseEmitter, res);

                        String sqlContent = sqlMap.get("sqlContent");
                        if(StringUtils.isNotBlank(sqlContent)) {
                            sqlContent = sqlContent.replace("```sql", "");
                            sqlContent = sqlContent.replace("```", "");
                            sqlContent = sqlContent.replaceAll("[\\r\\n]+", " ");
                            sqlContent = sqlContent.replace("%工程", "%");
                            sqlContent = sqlContent.replace("%项目", "%");
                            sqlContent = sqlContent.replace("工程%", "%");
                            sqlContent = sqlContent.replace("项目%", "%");
                            sqlContent = sqlContent.replace(";", "");
                            logger.info("new---sqlContent:{}",sqlContent);
                        }

                        String queryParamSql = getQueryParamSql(tenantId, authority, tableEntity);
                        String lowerSqlContent = sqlContent.toLowerCase();

                        // 查找关键子句的位置
                        int lastWhereIndex = lowerSqlContent.lastIndexOf("where");
                        int groupByIndex = lowerSqlContent.indexOf("group by");
                        int havingIndex = lowerSqlContent.indexOf("having");
                        int orderByIndex = lowerSqlContent.indexOf("order by");

                        // 确定WHERE条件应该插入的位置
                        if (lastWhereIndex != -1) {
                            // 如果已存在WHERE子句
                            int insertPosition = sqlContent.length(); // 默认在末尾插入

                            // 确定WHERE子句的结束位置（考虑GROUP BY, HAVING, ORDER BY等后续子句）
                            if (groupByIndex != -1) {
                                insertPosition = Math.min(insertPosition, groupByIndex);
                            }
                            if (havingIndex != -1) {
                                insertPosition = Math.min(insertPosition, havingIndex);
                            }
                            if (orderByIndex != -1) {
                                insertPosition = Math.min(insertPosition, orderByIndex);
                            }

                            // 在现有WHERE子句中添加条件
                            String beforeWhere = sqlContent.substring(0, lastWhereIndex + 5); // 包含"where"
                            String whereClause = sqlContent.substring(lastWhereIndex + 5, insertPosition).trim();
                            String afterClause = sqlContent.substring(insertPosition);

                            if (!whereClause.isEmpty()) {
                                sqlContent = beforeWhere + " (" + whereClause + ") AND " + queryParamSql + afterClause;
                            } else {
                                sqlContent = beforeWhere + " " + queryParamSql + afterClause;
                            }
                        } else {
                            // 如果不存在WHERE子句，需要在适当位置插入
                            int insertPosition = sqlContent.length();

                            // 确定INSERT位置（在GROUP BY, HAVING, ORDER BY之前）
                            if (groupByIndex != -1) {
                                insertPosition = Math.min(insertPosition, groupByIndex);
                            }
                            if (havingIndex != -1) {
                                insertPosition = Math.min(insertPosition, havingIndex);
                            }
                            if (orderByIndex != -1) {
                                insertPosition = Math.min(insertPosition, orderByIndex);
                            }

                            String beforeInsert = sqlContent.substring(0, insertPosition);
                            String afterInsert = sqlContent.substring(insertPosition);

                            sqlContent = beforeInsert + " WHERE " + queryParamSql + afterInsert;
                        }

                        logger.info("new---sqlContent1 最终执行sql:{}",sqlContent);
                        List<LinkedHashMap<String, Object>> resultList = chatExcelMsgMapper.queryDatas(sqlContent);
                        List<LinkedHashMap<String, Object>> resultDatas = new ArrayList<>();
                        if(ListUtil.isNotEmpty(resultList)) {
                            logger.info("resultList:{}",JSON.toJSONString(resultList));
                            /** 获取原始所有字段 */
                            for (LinkedHashMap<String, Object> jsonObject : resultList) {
                                /** 翻译每条数据 */
                                LinkedHashMap<String, Object> newJsonObject = new LinkedHashMap<>();
                                jsonObject.keySet().forEach(key -> {
                                    /** 一条数据中字段翻译 */
                                    boolean isTranslated = false;
                                    for (GridHeader column : gridHeaders) {
                                        if(key.equals(column.getCode())){
                                            isTranslated = true;
                                            newJsonObject.put(key, jsonObject.get(key));
                                        }
                                    }
                                    if(!isTranslated){
                                        Object value = jsonObject.get(key);
                                        if(key.toUpperCase().startsWith("COUNT")){
                                            key = "数量";
                                        }
                                        if(key.toUpperCase().startsWith("SUM")){
                                            key = "合计";
                                        }
                                        if(key.toUpperCase().startsWith("AVG")){
                                            key = "平均值";
                                        }
                                        if(key.toUpperCase().startsWith("MAX")){
                                            key = "最大值";
                                        }
                                        if(key.toUpperCase().startsWith("MIN")){
                                            key = "最小值";
                                        }
                                        // 格式化value值，处理空值情况并保留两位小数
                                        if (value == null) {
                                            value = "";
                                        } else if (value instanceof Number) {
                                            // 对于数字类型，格式化为保留两位小数
                                            double doubleValue = ((Number) value).doubleValue();
                                            value = String.format("%,.2f", doubleValue);
                                        } else {
                                            // 其他类型直接转换为字符串
                                            value = value.toString();
                                        }
                                        newJsonObject.put(key, value);
                                    }
                                });
                                resultDatas.add(newJsonObject);
                            }

                            Long msgId = IdWorker.getId();
                            String dataType = "";
                            String dataContent = JSON.toJSONString(resultDatas);
                            logger.info("dataContent:{}",dataContent);
                            res.put("dataContent",dataContent);
                            if(resultDatas.size() == 1) {
                                LinkedHashMap<String, Object> jsonObject = resultDatas.get(0);
                                if(jsonObject.size() <= 2) {
                                    dataType="single";
                                    sleepThread();
                                    res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>数据将以卡片形式进行展示。</div></div>");
                                    resStr += res.getString("botMsg");
                                    sseEmitterHelper.sendComplete(sseEmitter, res);
                                }else{
                                    boolean passFlag = true;
                                    // 如果通过验证，构建 dataset 并返回给前端
                                    Map<String, Object> dataset = new HashMap<>();
                                    // 获取所有字段名并验证字段类型
                                    Set<String> allKeys = new LinkedHashSet<>();
                                    for (LinkedHashMap<String, Object> row : resultDatas) {
                                        allKeys.addAll(row.keySet());
                                    }
                                    List<String> keys = new ArrayList<>(allKeys);
                                    // 验证第一个字段是否为字符串类型
                                    boolean validStructure = resultDatas.stream().allMatch(row -> {
                                        Object firstValue = row.get(keys.get(0));
                                        return firstValue != null && firstValue instanceof String;
                                    });
                                    if (validStructure) {
                                        // 验证其余字段是否为数字类型
                                        for (int i = 1; i < keys.size(); i++) {
                                            final int idx = i;
                                            boolean numericValid = resultDatas.stream().allMatch(row -> {
                                                Object value = row.get(keys.get(idx));
                                                if (value instanceof Number) {
                                                    return true; // 原始数字类型直接通过
                                                } else if (value instanceof String) {
                                                    return NumberUtils.isCreatable((String) value); // 字符串尝试转换为数字
                                                }
                                                return false;
                                            });
                                            if (!numericValid) {
                                                passFlag = false;
                                                break;
                                            }
                                        }
                                        if (passFlag){
                                            dataset.put("dimensions", keys);
                                            List<Map<String, Object>> source = new ArrayList<>();
                                            for (LinkedHashMap<String, Object> row : resultDatas) {
                                                Map<String, Object> rowData = new LinkedHashMap<>();
                                                for (String key : keys) {
                                                    rowData.put(key, row.get(key));
                                                }
                                                source.add(rowData);
                                            }
                                            dataset.put("source", source);
                                        }
                                    }else{
                                        passFlag = false;
                                    }
                                    if (passFlag){
                                        dataType="bar";
                                        sleepThread();
                                        res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>使用柱状图进行展示。</div></div>");
                                        resStr += res.getString("botMsg");
                                        dataContent = JSON.toJSONString(dataset);
                                        res.put("dataContent",dataContent);
                                        res.put("id",msgId);
                                        sseEmitterHelper.sendComplete(sseEmitter, res);
                                    }else{
                                        dataType="table";
                                        sleepThread();
                                        res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>使用表格进行展示。</div></div>");
                                        resStr += res.getString("botMsg");
                                        sseEmitterHelper.sendComplete(sseEmitter, res);
                                    }
                                }
                            }else{
                                boolean passFlag = true;
                                // 如果通过验证，构建 dataset 并返回给前端
                                Map<String, Object> dataset = new HashMap<>();
                                if(resultDatas.size() < 9) {//柱状图 2-8个柱子数
                                    LinkedHashMap<String, Object> firstRow = resultDatas.get(0);
                                    if(firstRow.size() <= 4) {//柱状图每个柱子2-4个指标维度
                                        // 获取所有字段名并验证字段类型
                                        Set<String> allKeys = new LinkedHashSet<>();
                                        for (LinkedHashMap<String, Object> row : resultDatas) {
                                            allKeys.addAll(row.keySet());
                                        }
                                        List<String> keys = new ArrayList<>(allKeys);
                                        // 验证第一个字段是否为字符串类型
                                        boolean validStructure = resultDatas.stream().allMatch(row -> {
                                            Object firstValue = row.get(keys.get(0));
                                            return firstValue != null && firstValue instanceof String;
                                        });
                                        if (validStructure) {
                                            // 验证其余字段是否为数字类型
                                            for (int i = 1; i < keys.size(); i++) {
                                                final int idx = i;
                                                boolean numericValid = resultDatas.stream().allMatch(row -> {
                                                    Object value = row.get(keys.get(idx));
                                                    if (value instanceof Number) {
                                                        return true; // 原始数字类型直接通过
                                                    } else if (value instanceof String) {
                                                        return NumberUtils.isCreatable((String) value); // 字符串尝试转换为数字
                                                    }
                                                    return false;
                                                });
                                                if (!numericValid) {
                                                    passFlag = false;
                                                    break;
                                                }
                                            }
                                            if (passFlag){
                                                dataset.put("dimensions", keys);
                                                List<Map<String, Object>> source = new ArrayList<>();
                                                for (LinkedHashMap<String, Object> row : resultDatas) {
                                                    Map<String, Object> rowData = new LinkedHashMap<>();
                                                    for (String key : keys) {
                                                        rowData.put(key, row.get(key));
                                                    }
                                                    source.add(rowData);
                                                }
                                                dataset.put("source", source);
                                            }
                                        }else{
                                            passFlag = false;
                                        }
                                    }else{
                                        passFlag = false;
                                    }
                                }else{
                                    passFlag = false;
                                }
                                if (passFlag){
                                    dataType="bar";
                                    sleepThread();
                                    res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>使用柱状图进行展示。</div></div>");
                                    resStr += res.getString("botMsg");
                                    dataContent = JSON.toJSONString(dataset);
                                    res.put("dataContent",dataContent);
                                    res.put("id",msgId);
                                    sseEmitterHelper.sendComplete(sseEmitter, res);
                                }else {
                                    dataType="table";
                                    sleepThread();
                                    res.put("dataContent","to-query");
                                    res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>使用表格进行展示。</div></div>");
                                    resStr += res.getString("botMsg");
                                    sseEmitterHelper.sendComplete(sseEmitter, res);
                                }
                            }

                            sleepThread();

                            res.put("botMsg","");
                            res.put("dataType",dataType);
                            res.put("id",msgId);

                            ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                            chatExcelAnswerMsgEntity.setId(msgId);
                            chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                            chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                            chatExcelAnswerMsgEntity.setUserId(userId);
                            chatExcelAnswerMsgEntity.setContent(resStr);
                            chatExcelAnswerMsgEntity.setDataType(dataType);
                            chatExcelAnswerMsgEntity.setDataContent(dataContent);
                            chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);

                            sseEmitterHelper.sendComplete(sseEmitter, res);
                            sseEmitter.complete();
                        }else {
                            res.put("botMsg","</div><div class=\"process-result\"> 根据报表，没有找到您提问的数据，请再明确您的问题。</div>");
                            resStr += res.getString("botMsg");
                            ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                            chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                            chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                            chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                            chatExcelAnswerMsgEntity.setUserId(userId);
                            chatExcelAnswerMsgEntity.setContent(resStr);
                            chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);
                            sseEmitterHelper.sendComplete(sseEmitter, res);
                            sseEmitter.complete();
                        }
                    }else{
                        res.put("botMsg","</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>数据展示失败，可能表格文档中没有您提问的数据，请再明确您的问题。</div>");
                        resStr += res.getString("botMsg");

                        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                        chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                        chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                        chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                        chatExcelAnswerMsgEntity.setUserId(userId);
                        chatExcelAnswerMsgEntity.setContent(resStr);
                        chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);

                        sseEmitterHelper.sendComplete(sseEmitter, res);
                        sseEmitter.complete();
                    }
                } catch (Exception e) {
                    res.put("botMsg","</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>数据展示失败，可能表格文档中没有您提问的数据，请再明确您的问题。</div>");
                    resStr += res.getString("botMsg");

                    ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                    chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                    chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                    chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                    chatExcelAnswerMsgEntity.setUserId(userId);
                    chatExcelAnswerMsgEntity.setContent(resStr);
                    chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);

                    sseEmitterHelper.sendComplete(sseEmitter, res);
                    sseEmitter.complete();
                }
            }
        }).start();

        return sseEmitter;
    }

    @Override
    public SseEmitter sendChatText(ChatExcelParam chatExcelParam, HttpServletRequest request){
        SseEmitter sseEmitter = new SseEmitter(6000000L);
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        JSONObject res = new JSONObject();
        TableEntity tableEntity = tableService.getByCode(chatExcelParam.getChatExcelId());
        //保存提问信息
        Long chatExcelMsgId = null;
        ChatExcelMsgEntity chatExcelQuestionMsgEntity = null;
        if(chatExcelParam.getChatExcelSessionId() == null) {
            chatExcelMsgId = IdWorker.getId();
            chatExcelQuestionMsgEntity = new ChatExcelMsgEntity();
            chatExcelQuestionMsgEntity.setId(chatExcelMsgId);
            if(tableEntity != null){
                chatExcelQuestionMsgEntity.setChatExcelId(tableEntity.getId());
            }
            chatExcelQuestionMsgEntity.setUserId(userId);
            chatExcelQuestionMsgEntity.setContent(chatExcelParam.getContent());
            this.saveOrUpdate(chatExcelQuestionMsgEntity,false);
        }else{ //重新回复
            chatExcelQuestionMsgEntity = this.selectById(chatExcelParam.getChatExcelSessionId());
            chatExcelMsgId = chatExcelQuestionMsgEntity.getId();
        }
        String resStr = "";
        if(tableEntity == null) {
            resStr = "找不到对应的报表！";
            Long pkId = IdWorker.getId();
            saveChatExcelAnswer(pkId,chatExcelMsgId,null, userId, tenantId, resStr);
            res.put("botMsg",resStr);
            res.put("chatExcelId",chatExcelParam.getChatExcelId());
            res.put("chatExcelSessionId",chatExcelMsgId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }

        Long pkId = IdWorker.getId();
        final  Long fChatExcelMsgId = chatExcelMsgId;
        IChatExcelMsgService chatExcelMsgService = this;

            new Thread(new Runnable() {
                @Override
                public void run() {
                    String resStr = "";
                    try {
                        res.put("chatExcelId",tableEntity.getId());
                        res.put("chatExcelSessionId",fChatExcelMsgId);
                        res.put("currentAnswerId",pkId);
                        res.put("botMsg","<div class=\"t-t-c\" ><div class=\"intr\">您好，我明白您的需求。接下来的计划是根据您提供的“"+tableEntity.getTableName()+"”表格，提取出相关数据，并展示出来；</div>");
                         resStr += res.getString("botMsg");
                        sseEmitterHelper.sendComplete(sseEmitter, res);
                        sleepThread();
                        //String fileName = getExcelFile(tableEntity.getCode());
                        res.put("botMsg","<div class=\"think-step first\"><i class=\"anticon anticon-check-circle\"></i>成功提取报表：“"+tableEntity.getTableName()+"”中相关数据，开始发送到AI。</div>");
                        resStr += res.getString("botMsg");
                        sseEmitterHelper.sendComplete(sseEmitter, res);

                        BaiduQianfanUtils baiduQianfanUtils = new BaiduQianfanUtils();
                        //使用excel方式
                        String newConversationId = baiduQianfanUtils.getNewConversationId();
//                        String fileId = baiduQianfanUtils.uploadLocalFile(newConversationId,fileName);
                        res.put("botMsg","<div class=\"think-step second\"><i class=\"anticon anticon-check-circle\"></i>AI接收数据完成，开始分析相关数据。</div>");
                        resStr += res.getString("botMsg");
                        sseEmitterHelper.sendComplete(sseEmitter, res);

                        String answer = baiduQianfanUtils.postChatMsg(chatExcelParam.getContent(), newConversationId);
                        Long msgId = IdWorker.getId();
                        if (answer.contains("```json")) {
                            answer = answer.split("```json")[1];
                            answer = answer.split("```")[0];
                            answer = answer.replaceAll("\n", "");
                            answer = answer.replaceAll("projectName", "项目名称");
                            answer = answer.replaceAll("money", "合同额");
                            if(answer.startsWith("{")){
                                answer = "["+answer+"]";
                            }
            //                JSONArray data = JSONObject.parseArray(answer);
            //                if (data != null && !data.isEmpty()) {
            //                    for (Object o : data){
            //                        JSONObject jsonObject = JSONObject.parseObject(o.toString());
            //                    }
            //                }
                            if(answer.length()>4) {
                                res.put("botMsg", "<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>分析完成，数据将以表格形式进行展示。</div></div>");
                                resStr += res.getString("botMsg");
                                res.put("dataContent", answer);
                                res.put("id", msgId);
                                sseEmitterHelper.sendComplete(sseEmitter, res);
                            }else{
                                res.put("botMsg","</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>数据展示失败，可能表格文档中没有您提问的数据，请再明确您的问题。</div>");
                                resStr += res.getString("botMsg");
                                res.put("id",msgId);
                                sseEmitterHelper.sendComplete(sseEmitter, res);
                            }
                        } else {
                            res.put("botMsg","</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>数据展示失败，可能表格文档中没有您提问的数据，请再明确您的问题。</div>");
                            resStr += res.getString("botMsg");
                            res.put("id",msgId);
                            sseEmitterHelper.sendComplete(sseEmitter, res);
                        }

                        sleepThread();
                        res.put("botMsg","");
                        res.put("dataType","table");
                        res.put("id",msgId);

                        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                        chatExcelAnswerMsgEntity.setId(msgId);
                        chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                        chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                        chatExcelAnswerMsgEntity.setUserId(userId);
                        chatExcelAnswerMsgEntity.setContent(resStr);
                        chatExcelAnswerMsgEntity.setDataType("table");
                        chatExcelAnswerMsgEntity.setDataContent(answer);
                        chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);

                        sseEmitterHelper.sendComplete(sseEmitter, res);
                        sseEmitter.complete();

                    } catch (Exception e) {
                        logger.error("数据展示失败",e.getMessage());
                        res.put("botMsg","</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>数据展示失败，可能表格文档中没有您提问的数据，请再明确您的问题。</div>");
                        resStr += res.getString("botMsg");

                        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                        chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                        chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                        chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                        chatExcelAnswerMsgEntity.setUserId(userId);
                        chatExcelAnswerMsgEntity.setContent(resStr);
                        chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);

                        sseEmitterHelper.sendComplete(sseEmitter, res);
                        sseEmitter.complete();
                    }
                }
            }).start();



        return sseEmitter;
    }
    @Override
    public void clearCurrentUserMessages(Long userId, String chatExcelId) {
        chatExcelMsgMapper.clearCurrentUserMessages(userId, chatExcelId);
    }

    private void sleepThread() {
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveChatExcelAnswer(Long pkId, Long chatExcelMsgId, Long chatExcelId, Long userId, Long tenantId, String resStr) {
        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
        chatExcelAnswerMsgEntity.setId(pkId);
        chatExcelAnswerMsgEntity.setParentId(chatExcelMsgId);
        chatExcelAnswerMsgEntity.setChatExcelId(chatExcelId);
        chatExcelAnswerMsgEntity.setUserId(userId);
        chatExcelAnswerMsgEntity.setTenantId(tenantId);
        chatExcelAnswerMsgEntity.setContent(resStr);
        this.saveOrUpdate(chatExcelAnswerMsgEntity,false);
    }


    @Override
    public String getExcelFile(String tableCode) throws IOException {
        String fileName = "";
        QueryParam queryParam = new QueryParam();
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map<String, GridHeader> exportHeaderMap = new HashMap<>();
        TableEntity tableEntity = null;
        if(org.apache.commons.lang3.StringUtils.isNotBlank(tableCode)) {
            tableEntity = tableService.getByCode(tableCode);
        } else {
            throw new BusinessException("报表导出失败，导出参数[tableCode]不能都为空！");
        }
        //查询表头
        List<GridHeader> gridHeaders = columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        List<String> titleList = new ArrayList<String>();
        List<String> properties = new ArrayList<String>();
        List<String> heightFields = new ArrayList<>();
        List<String> fieldFormat = new ArrayList<>();
        List<String> fieldSuffix = new ArrayList<>();
        Map<String, String> filedTypeMap = new HashMap<>();
        Map<String, String> headerMap = new HashMap<>();

        if(!exportHeaderMap.isEmpty()) {
            gridHeaders = gridHeaders.stream().filter(h -> exportHeaderMap.containsKey(h.getCode()))
                    .sorted(Comparator.comparingInt(h -> exportHeaderMap.get(h.getCode()).getShowOrder())).collect(Collectors.toList());
        }

        for(int i=0;i<gridHeaders.size();i++) {
            GridHeader gridHeader = gridHeaders.get(i);
            if(gridHeader.getVisible() && org.apache.commons.lang3.StringUtils.isNotEmpty(gridHeader.getCode())) {
                if(!exportHeaderMap.isEmpty()) {
                    titleList.add(exportHeaderMap.get(gridHeader.getCode()).getName());
                } else {
                    titleList.add(gridHeader.getName());
                }
//                titleList.add("id");
                properties.add(gridHeader.getCode());
                fieldFormat.add(gridHeader.getExportFormat());
                fieldSuffix.add(gridHeader.getSuffixStr());
                if(org.apache.commons.lang3.StringUtils.isNotBlank(gridHeader.getCode())) {
                    heightFields.add(gridHeader.getCode());
                }
            }
            filedTypeMap.put(gridHeader.getCode(), gridHeader.getType());
            headerMap.put(gridHeader.getCode()+"AlignType", gridHeader.getAlignType());
        }
        EasyExcelUtil excelExport = new EasyExcelUtil();
        queryParam.setPageIndex(1);
        queryParam.getParams().put("creator_space", new Parameter(QueryParam.EQ, 999999));
        queryParam.setPageSize(-1);

        IPage<JSONObject> pageData = columnService.queryPageList(tableEntity, queryParam, heightFields, filedTypeMap, false);
        List<JSONObject> records = pageData.getRecords();
        records = processFormat(records,gridHeaders);
        excelExport.setData(records);
        excelExport.setHeaderMap(headerMap);
        if(ListUtil.isNotEmpty(properties)) {
            excelExport.setHeardKey(properties);
            excelExport.setFontSize(12);
            excelExport.setFieldFormat(fieldFormat);
            excelExport.setFieldSuffix(fieldSuffix);
            excelExport.setSheetName(tableEntity.getTableName());
            excelExport.setTitle(tableEntity.getTableName());
            String[] array = titleList.toArray(new String[titleList.size()]);

            excelExport.setHeardList(array);
             fileName = excelExport.fileWrite();
        }
        return fileName;
    }

    public String getRecords(String tableCode){
        QueryParam queryParam = new QueryParam();
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map<String, GridHeader> exportHeaderMap = new HashMap<>();
        TableEntity tableEntity = null;
        if(org.apache.commons.lang3.StringUtils.isNotBlank(tableCode)) {
            tableEntity = tableService.getByCode(tableCode);
        } else {
            throw new BusinessException("报表导出失败，导出参数[tableCode]不能都为空！");
        }
        //查询表头
        List<GridHeader> gridHeaders = columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        List<String> titleList = new ArrayList<String>();
        List<String> properties = new ArrayList<String>();
        List<String> heightFields = new ArrayList<>();
        List<String> fieldFormat = new ArrayList<>();
        List<String> fieldSuffix = new ArrayList<>();
        Map<String, String> filedTypeMap = new HashMap<>();
        Map<String, String> headerMap = new HashMap<>();

        if(!exportHeaderMap.isEmpty()) {
            gridHeaders = gridHeaders.stream().filter(h -> exportHeaderMap.containsKey(h.getCode()))
                    .sorted(Comparator.comparingInt(h -> exportHeaderMap.get(h.getCode()).getShowOrder())).collect(Collectors.toList());
        }

        for(int i=0;i<gridHeaders.size();i++) {
            GridHeader gridHeader = gridHeaders.get(i);
            if(gridHeader.getVisible() && org.apache.commons.lang3.StringUtils.isNotEmpty(gridHeader.getCode())) {
                if(!exportHeaderMap.isEmpty()) {
                    titleList.add(exportHeaderMap.get(gridHeader.getCode()).getName());
                } else {
                    titleList.add(gridHeader.getName());
                }
//                titleList.add("id");
                properties.add(gridHeader.getCode());
                fieldFormat.add(gridHeader.getExportFormat());
                fieldSuffix.add(gridHeader.getSuffixStr());
                if(org.apache.commons.lang3.StringUtils.isNotBlank(gridHeader.getCode())) {
                    heightFields.add(gridHeader.getCode());
                }
            }
            filedTypeMap.put(gridHeader.getCode(), gridHeader.getType());
            headerMap.put(gridHeader.getCode()+"AlignType", gridHeader.getAlignType());
        }
        queryParam.setPageIndex(1);
        queryParam.getParams().put("creator_space", new Parameter(QueryParam.EQ, 999999));
        queryParam.setPageSize(10);

        IPage<JSONObject> pageData = columnService.queryPageList(tableEntity, queryParam, heightFields, filedTypeMap, false);
        List<JSONObject> records = pageData.getRecords();
        records = processFormat(records,gridHeaders);
        return records.toString();
    }
    private List<JSONObject> processFormat(List<JSONObject> records,List<GridHeader> gridHeaders){
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        if(ListUtil.isEmpty(records)){
            return records;
        }
        for (GridHeader header : gridHeaders) {
            if(org.apache.commons.lang3.StringUtils.isNotEmpty(header.getFormatter()) && header.getFormatter().contains("formatFun") && org.apache.commons.lang3.StringUtils.isNotEmpty(header.getCode())){
                try {
                    engine.eval(header.getFormatter());
                    if(engine instanceof Invocable) {
                        Invocable invoke = (Invocable)engine;
                        for (JSONObject rowData : records) {
                            Object r = invoke.invokeFunction("formatFun", rowData.get(header.getCode()), null, rowData); //调用了js的formatFun方法
                            rowData.put(header.getCode(), r);
                        }
                    }
                }catch (Exception e){
                    logger.error("js格式化异常",e);
                }
            }
        }
        return records;
    }

}
