/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.chat.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduQianfanUtils {
    private static final Logger logger = LoggerFactory.getLogger(BaiduQianfanUtils.class);
    public static final String conversation = "https://qianfan.baidubce.com/v2/app/conversation";
    public static final String uploadFile = "https://qianfan.baidubce.com/v2/app/conversation/file/upload";
    public static final String conversationRun = "https://qianfan.baidubce.com/v2/app/conversation/runs";
    public static final String knowledgeBaseImport = "https://qianfan.baidubce.com/v2/knowledgeBase?Action=ImportDocuments";
    public static final String filesImport = "https://qianfan.baidubce.com/v2/files";
    public static final String APP_ID = "f7a3d4c0-120b-4957-96e6-b8ac4731f71d";
    public static final String SECRET_KEY = "Bearer bce-v3/ALTAK-pmCGkekT1FtLrMSauUi73/e695deb150fe27ad0a6a41010b4eb42bc8260458";
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).build();
    private static final MediaType mediaType = MediaType.parse((String)"application/json");

    public String postChatMsg(String content, String conversationId) {
        try {
            content = "\u6839\u636e\u77e5\u8bc6\u5e93\u56de\u7b54\u95ee\u9898\uff1a" + content + "\uff1f";
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", (Object)APP_ID);
            msgBody.put("query", (Object)content);
            msgBody.put("stream", (Object)false);
            msgBody.put("conversation_id", (Object)conversationId);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)msgBody.toJSONString());
            Request request = new Request.Builder().url(conversationRun).method("POST", body).addHeader("Content-Type", "application/json;charset=utf-8").addHeader("X-Appbuilder-Authorization", SECRET_KEY).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject((String)response.body().string());
            return resBody.getString("answer");
        }
        catch (Exception e) {
            logger.error("error\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public String postChatTextMsg(String content, String conversationId, String textRecords) {
        try {
            content = "\u6211\u5c06\u63d0\u4f9b\u4e0b\u5217json\u683c\u5f0f\u7684\u6570\u636e\uff1a" + textRecords + "\u3002\u6839\u636e\u7684\u63d0\u4f9b\u7684\u6570\u636e\u56de\u7b54\u95ee\u9898\uff1a" + content + "\uff1f\u8981\u6c42\uff1a\u7ed9\u51fa\u6307\u5b9ajson\u683c\u5f0f\u7684\u5185\u5bb9\u8f93\u51fa\u3002\u6ce8\u610f\uff1a1\u3001\u56de\u7b54\u95ee\u9898\u65f6\u4ec5\u6839\u636e\u63d0\u4f9b\u7684json\u6570\u636e\u4e2d\u51fa\u73b0\u7684\u5185\u5bb9\u56de\u7b54\u5185\u5bb9\uff0c\u4e0d\u8981\u968f\u610f\u91cd\u7ec42\u3001\u4e0d\u8981\u5176\u4ed6\u989d\u5916\u5206\u6790\u6027\u6587\u5b57; 3\u3001\u8fd4\u56dejson\u683c\u5f0f\u5185\u5bb9\u8981\u6c42\u662f\uff1a[{\"projectName\"\uff1a\"\u9879\u76ee\u540d\u79f0\",\"money\"\uff1a\"\u5408\u540c\u989d\uff08\u4e07\u5143\uff09\"}]";
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", (Object)APP_ID);
            msgBody.put("query", (Object)content);
            msgBody.put("stream", (Object)false);
            msgBody.put("conversation_id", (Object)conversationId);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)msgBody.toJSONString());
            Request request = new Request.Builder().url(conversationRun).method("POST", body).addHeader("Content-Type", "application/json;charset=utf-8").addHeader("X-Appbuilder-Authorization", SECRET_KEY).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject((String)response.body().string());
            return resBody.getString("answer");
        }
        catch (Exception e) {
            logger.error("error\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadLocalFile(String conversationId, String fileName) {
        File file = null;
        try {
            file = new File(fileName);
            MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("app_id", APP_ID).addFormDataPart("file", fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).addFormDataPart("conversation_id", conversationId).build();
            Request request = new Request.Builder().url(uploadFile).method("POST", (RequestBody)body).addHeader("Content-Type", "multipart/form-data").addHeader("X-Appbuilder-Authorization", SECRET_KEY).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject((String)response.body().string());
            String string = qFanContent.getString("id");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error\uff1a{}", (Object)e.getMessage());
        }
        finally {
            if (file.exists()) {
                boolean delete = file.delete();
                logger.info("---------------------\u5220\u9664\u6587\u4ef6\uff1a" + fileName + "\u7ed3\u679c\uff1a" + delete);
            }
        }
        return null;
    }

    public String getNewConversationId() {
        try {
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", (Object)APP_ID);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)msgBody.toJSONString());
            Request request = new Request.Builder().url(conversation).method("POST", body).addHeader("Content-Type", "application/json").addHeader("X-Appbuilder-Authorization", SECRET_KEY).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject((String)response.body().string());
            return resBody.getString("conversation_id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String filesImport(String fileName) {
        File file = null;
        try {
            file = new File(fileName);
            String str = "\u59d3\u540d\uff1a\u5f20\u4e09\uff0c\u5e74\u9f84\uff1a30\uff0c\u6027\u522b\uff1a\u7537\uff1b\u59d3\u540d\uff1a\u674e\u56db\uff0c\u5e74\u9f84\uff1a20\uff0c\u6027\u522b\uff1a\u5973\uff1b";
            FileOutputStream baos = new FileOutputStream(file);
            baos.write(str.getBytes());
            baos.flush();
            MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("purpose", "assistants").addFormDataPart("file", fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).build();
            Request request = new Request.Builder().url(filesImport).method("POST", (RequestBody)body).addHeader("Content-Type", "multipart/form-data").addHeader("Authorization", SECRET_KEY).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject((String)response.body().string());
            baos.close();
            String string = qFanContent.getString("id");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error\uff1a{}", (Object)e.getMessage());
        }
        finally {
            if (file.exists()) {
                boolean delete = file.delete();
                logger.info("---------------------\u5220\u9664\u6587\u4ef6\uff1a" + fileName + "\u7ed3\u679c\uff1a" + delete);
            }
        }
        return null;
    }

    public static String knowledgeBaseImport(String fileId) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)"upload");
            jsonObject.put("filesId", Arrays.asList(fileId));
            JSONObject msgBody = new JSONObject();
            msgBody.put("id", (Object)"ca4bce3e-030b-4142-b232-348dd7bbecf3");
            msgBody.put("source", (Object)jsonObject.toString());
            MediaType mediaType = MediaType.parse((String)"multipart/form-data");
            MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload", msgBody.toString()).build();
            Request request = new Request.Builder().url("https://qianfan.baidubce.com/v2/knowledgeBase?Action=UploadDocuments").method("POST", (RequestBody)body).addHeader("Content-Type", "multipart/form-data").addHeader("Authorization", SECRET_KEY).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject((String)response.body().string());
            return resBody.getString("requestId");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String s = BaiduQianfanUtils.filesImport("didi.xlsx");
        System.out.println(s);
    }
}

