/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.report.util.Custemhandler;
import com.ejianc.framework.core.exception.BusinessException;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyExcelUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String title;
    private String[] heardList;
    private Map<String, String> headerMap = new HashMap<String, String>();
    private List<String> heardKey;
    private List<JSONObject> data;
    private int fontSize = 14;
    private int rowHeight = 30;
    private int columWidth = 200;
    private String sheetName = "sheet1";
    private List<String> fieldFormat;
    private List<String> fieldSuffix;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");

    public List<String> getFieldSuffix() {
        return this.fieldSuffix;
    }

    public void setFieldSuffix(List<String> fieldSuffix) {
        this.fieldSuffix = fieldSuffix;
    }

    public List<String> getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(List<String> fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getHeardList() {
        return this.heardList;
    }

    public void setHeardList(String[] heardList) {
        this.heardList = heardList;
    }

    public List<String> getHeardKey() {
        return this.heardKey;
    }

    public void setHeardKey(List<String> heardKey) {
        this.heardKey = heardKey;
    }

    public List<JSONObject> getData() {
        return this.data;
    }

    public void setData(List<JSONObject> data) {
        this.data = data;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public int getColumWidth() {
        return this.columWidth;
    }

    public void setColumWidth(int columWidth) {
        this.columWidth = columWidth;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public void exportExport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = System.currentTimeMillis() + ".xlsx";
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-Disposition", "attachment;Filename=" + fileName);
        response.flushBuffer();
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream).head(this.head(this.sheetName))).autoCloseStream(Boolean.valueOf(false)).sheet(this.sheetName).registerWriteHandler((WriteHandler)new Custemhandler())).registerWriteHandler((WriteHandler)EasyExcelUtil.getStyleStrategy())).doWrite(this.dataList());
        }
        catch (Exception e) {
            this.logger.info("\u5bfc\u51fa\u6570\u636e\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new BusinessException("\u5bfc\u51faExcel\u51fa\u73b0\u5f02\u5e38");
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    private List<List<String>> head(String sheetName) {
        ArrayList list = ListUtils.newArrayList();
        for (int i = 0; i < this.heardList.length; ++i) {
            ArrayList head = ListUtils.newArrayList();
            head.add(sheetName);
            head.add(this.heardList[i]);
            list.add(head);
        }
        return list;
    }

    private List<List<Object>> dataList() {
        ArrayList list = ListUtils.newArrayList();
        for (int i = 0; i < this.data.size(); ++i) {
            ArrayList dat = ListUtils.newArrayList();
            JSONObject json = this.data.get(i);
            for (int j = 0; j < this.heardKey.size(); ++j) {
                Object valueObject = json.get((Object)this.heardKey.get(j));
                String value = null;
                if (valueObject == null) {
                    valueObject = "";
                }
                value = valueObject instanceof String ? (String)json.get((Object)this.heardKey.get(j)) : (valueObject instanceof Integer ? String.valueOf(((Integer)valueObject).floatValue()) : (valueObject instanceof Number ? new BigDecimal(valueObject.toString()).toPlainString() : valueObject.toString()));
                value = this.formatField(value, this.fieldFormat.get(j), this.fieldSuffix.get(j));
                if (StringUtils.isNotBlank((CharSequence)this.fieldFormat.get(j))) {
                    dat.add(Strings.isNullOrEmpty((String)value) ? "" : value);
                    continue;
                }
                if (valueObject instanceof Number) {
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        if (valueObject instanceof Integer) {
                            dat.add((Integer)valueObject);
                            continue;
                        }
                        String valueStr = value.replaceAll(",", "");
                        if (StringUtils.isEmpty((CharSequence)value)) {
                            valueStr = "0.00";
                        }
                        dat.add(new Double(valueStr));
                        continue;
                    }
                    dat.add(json.get((Object)this.heardKey.get(j)));
                    continue;
                }
                dat.add(Strings.isNullOrEmpty((String)value) ? "" : value);
            }
            list.add(dat);
        }
        return list;
    }

    private String formatField(String value, String format, String suffix) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)format)) {
            return value;
        }
        try {
            switch (format) {
                case "twoDecimalNumbers": {
                    result = new BigDecimal(value).setScale(2, 4).toString();
                    break;
                }
                case "integer": {
                    result = new BigDecimal(value).setScale(0, 4).toString();
                    break;
                }
                case "mnyFormat": {
                    result = this.decimalFormat.format(new BigDecimal(value).setScale(6, 4));
                    break;
                }
                case "yyyy-MM-dd": {
                    result = this.dateFormat.format(this.dateFormat.parse(value));
                    break;
                }
                case "yyyy-MM-dd HH:mm:ss": {
                    result = this.dateTimeFormat.format(this.dateTimeFormat.parse(value));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u4f9d\u636e\u6a21\u5f0f[{}],\u683c\u5f0f\u5316\u683c\u5f0f\u5316[{}]\u5f02\u5e38\uff1a", new Object[]{format, value, e});
            return value;
        }
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            return result + suffix;
        }
        return result;
    }

    public static HorizontalCellStyleStrategy getStyleStrategy() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        headWriteFont.setFontName("\u5b8b\u4f53");
        headWriteCellStyle.setWriteFont(headWriteFont);
        headWriteCellStyle.setWrapped(Boolean.valueOf(false));
        headWriteCellStyle.setBorderTop(BorderStyle.THIN);
        headWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        headWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        headWriteCellStyle.setBorderRight(BorderStyle.THIN);
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        contentWriteFont.setFontName("Calibri");
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public String fileWrite() {
        String fileName = System.currentTimeMillis() + ".xlsx";
        File file = new File(fileName);
        try {
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file).head(this.head(this.sheetName))).autoCloseStream(Boolean.valueOf(true)).sheet(this.sheetName).registerWriteHandler((WriteHandler)new Custemhandler())).registerWriteHandler((WriteHandler)EasyExcelUtil.getStyleStrategy())).doWrite(this.dataList());
            String string = fileName;
            return string;
        }
        catch (Exception e) {
            this.logger.info("\u5bfc\u51fa\u6570\u636e\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new BusinessException("\u5bfc\u51faExcel\u51fa\u73b0\u5f02\u5e38");
        }
    }
}

