package com.ejianc.business.payer.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 缴纳员工明细表子实体
 * 
 * @author generator
 * 
 */
public class PayerDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long sourceId; // 来源数据Id
    private String name; // 姓名
    private String job; // 角色
    private String phone; // 手机号
    private BigDecimal salary; // 工资金额（元）
    private BigDecimal payerMny; // 缴纳金额（万元）
    private BigDecimal payerScale; // 缴纳占比
    private String detailMemo; // 备注
    private Long payerId; // 缴纳员工明细主键-pid
    private BigDecimal actualPayerMny; // 实际缴纳金额（万元）
    private BigDecimal remainderPayerMny; // 未缴纳金额（万元）
    private Integer periodizationFlag; // 是否已分期（0：否 1：是）
    private String periodizationFlagName; // 是否已分期（0：否 1：是）
    private Integer periodizationNum; //分期数
    private BigDecimal periodizationMny; //分期金额（万元）


    private BigDecimal actualPayerScale; //实际已缴纳比例
    private BigDecimal actualPayerRatio; //实际缴纳占比（实际已缴纳金额 / 主表实际缴纳金额汇总）
    private BigDecimal eachPeriodizationMny; //每期缴纳金额
    private String payerCode; //缴纳员工明细编码
    private String payerName; //缴纳员工明细名称
    private Long payerOrgId; //缴纳员工明细组织Id （项目id或组织id）
    private String payerOrgName; //缴纳员工明细组织名称（项目名称或组织名称）
    private String payerOrgCode; //缴纳员工明细组织编码（项目编码或组织编码）
    private Long payerProjectId; //缴纳员工明细项目Id
    private String payerProjectName; //缴纳员工明细项目名称
    private String payerProjectCode; //缴纳员工明细项目编码
    private String payerRiskDepositType; // 风险保证金类型(directDept-直管部、projectDept-项目部)
    private Long userId; //员工id（同sourceId）
    private Long payerEmployeeId; //缴纳员工明细经办人id
    private String payerEmployeeName; //缴纳员工明细经办人名称
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date payerBelongYear; // 缴纳员工明细所属年度


    private BigDecimal payerMnyWan; // 缴纳金额（万元）（转换成万元）
    private BigDecimal actualPayerMnyWan; // 实际缴纳金额（万元）（转换成万元）
    private BigDecimal remainderPayerMnyWan; // 未缴纳金额（万元）（转换成万元）

    private Long payerProjectParentOrgId; //缴纳员工明细项目父组织Id
    private String payerProjectParentOrgName; //缴纳员工明细项目父组织名称
    private String payerProjectParentOrgCode; //缴纳员工明细项目父组织编码

    private String presenceFlag; //是否在场

    public String getPresenceFlag() {
        return presenceFlag;
    }

    public void setPresenceFlag(String presenceFlag) {
        this.presenceFlag = presenceFlag;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getPayerMny() {
        return payerMny;
    }

    public void setPayerMny(BigDecimal payerMny) {
        this.payerMny = payerMny;
    }
    public BigDecimal getPayerScale() {
        return payerScale;
    }

    public void setPayerScale(BigDecimal payerScale) {
        this.payerScale = payerScale;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    public Long getPayerId() {
        return payerId;
    }

    public void setPayerId(Long payerId) {
        this.payerId = payerId;
    }

    public BigDecimal getActualPayerMny() {
        return actualPayerMny;
    }

    public void setActualPayerMny(BigDecimal actualPayerMny) {
        this.actualPayerMny = actualPayerMny;
    }

    public BigDecimal getRemainderPayerMny() {
        return remainderPayerMny;
    }

    public void setRemainderPayerMny(BigDecimal remainderPayerMny) {
        this.remainderPayerMny = remainderPayerMny;
    }

    public Integer getPeriodizationFlag() {
        return periodizationFlag;
    }

    public void setPeriodizationFlag(Integer periodizationFlag) {
        this.periodizationFlag = periodizationFlag;
    }

    public Integer getPeriodizationNum() {
        return periodizationNum;
    }

    public void setPeriodizationNum(Integer periodizationNum) {
        this.periodizationNum = periodizationNum;
    }

    public BigDecimal getPeriodizationMny() {
        return periodizationMny;
    }

    public void setPeriodizationMny(BigDecimal periodizationMny) {
        this.periodizationMny = periodizationMny;
    }

    public BigDecimal getActualPayerScale() {
        return actualPayerScale;
    }

    public void setActualPayerScale(BigDecimal actualPayerScale) {
        this.actualPayerScale = actualPayerScale;
    }

    public BigDecimal getActualPayerRatio() {
        return actualPayerRatio;
    }

    public void setActualPayerRatio(BigDecimal actualPayerRatio) {
        this.actualPayerRatio = actualPayerRatio;
    }

    public BigDecimal getEachPeriodizationMny() {
        return eachPeriodizationMny;
    }

    public void setEachPeriodizationMny(BigDecimal eachPeriodizationMny) {
        this.eachPeriodizationMny = eachPeriodizationMny;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public Long getPayerOrgId() {
        return payerOrgId;
    }

    public void setPayerOrgId(Long payerOrgId) {
        this.payerOrgId = payerOrgId;
    }

    public String getPayerOrgName() {
        return payerOrgName;
    }

    public void setPayerOrgName(String payerOrgName) {
        this.payerOrgName = payerOrgName;
    }

    public String getPayerOrgCode() {
        return payerOrgCode;
    }

    public void setPayerOrgCode(String payerOrgCode) {
        this.payerOrgCode = payerOrgCode;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getPayerEmployeeId() {
        return payerEmployeeId;
    }

    public void setPayerEmployeeId(Long payerEmployeeId) {
        this.payerEmployeeId = payerEmployeeId;
    }

    public String getPayerEmployeeName() {
        return payerEmployeeName;
    }

    public void setPayerEmployeeName(String payerEmployeeName) {
        this.payerEmployeeName = payerEmployeeName;
    }

    public Date getPayerBelongYear() {
        return payerBelongYear;
    }

    public void setPayerBelongYear(Date payerBelongYear) {
        this.payerBelongYear = payerBelongYear;
    }

    public String getPeriodizationFlagName() {
        return periodizationFlagName;
    }

    public void setPeriodizationFlagName(String periodizationFlagName) {
        this.periodizationFlagName = periodizationFlagName;
    }

    public BigDecimal getPayerMnyWan() {
        return payerMnyWan;
    }

    public void setPayerMnyWan(BigDecimal payerMnyWan) {
        this.payerMnyWan = payerMnyWan;
    }

    public BigDecimal getActualPayerMnyWan() {
        return actualPayerMnyWan;
    }

    public void setActualPayerMnyWan(BigDecimal actualPayerMnyWan) {
        this.actualPayerMnyWan = actualPayerMnyWan;
    }

    public BigDecimal getRemainderPayerMnyWan() {
        return remainderPayerMnyWan;
    }

    public void setRemainderPayerMnyWan(BigDecimal remainderPayerMnyWan) {
        this.remainderPayerMnyWan = remainderPayerMnyWan;
    }

    public Long getPayerProjectId() {
        return payerProjectId;
    }

    public void setPayerProjectId(Long payerProjectId) {
        this.payerProjectId = payerProjectId;
    }

    public String getPayerProjectName() {
        return payerProjectName;
    }

    public void setPayerProjectName(String payerProjectName) {
        this.payerProjectName = payerProjectName;
    }

    public String getPayerProjectCode() {
        return payerProjectCode;
    }

    public void setPayerProjectCode(String payerProjectCode) {
        this.payerProjectCode = payerProjectCode;
    }

    public String getPayerRiskDepositType() {
        return payerRiskDepositType;
    }

    public void setPayerRiskDepositType(String payerRiskDepositType) {
        this.payerRiskDepositType = payerRiskDepositType;
    }

    public Long getPayerProjectParentOrgId() {
        return payerProjectParentOrgId;
    }

    public void setPayerProjectParentOrgId(Long payerProjectParentOrgId) {
        this.payerProjectParentOrgId = payerProjectParentOrgId;
    }

    public String getPayerProjectParentOrgName() {
        return payerProjectParentOrgName;
    }

    public void setPayerProjectParentOrgName(String payerProjectParentOrgName) {
        this.payerProjectParentOrgName = payerProjectParentOrgName;
    }

    public String getPayerProjectParentOrgCode() {
        return payerProjectParentOrgCode;
    }

    public void setPayerProjectParentOrgCode(String payerProjectParentOrgCode) {
        this.payerProjectParentOrgCode = payerProjectParentOrgCode;
    }
}
