/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.standard.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.service.IStandardDetailService;
import com.ejianc.business.standard.service.IStandardRecordService;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.business.standard.vo.StandardRecordVO;
import com.ejianc.business.standard.vo.StandardVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"standard"})
public class StandardController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String DIRECT_BILL_CODE = "DIRECT_DEPT_STANDARD";
    private static final String PROJECT_BILL_CODE = "PROJECT_DEPT_STANDARD";
    private static final String CONTRACT_TYPE = "contraction";
    @Autowired
    private IStandardService service;
    @Autowired
    private IStandardRecordService recordService;
    @Autowired
    private IStandardDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StandardVO> saveOrUpdate(@RequestBody StandardVO standardVO) {
        StandardEntity entity = (StandardEntity)((Object)BeanMapper.map((Object)standardVO, StandardEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)("directDept".equals(standardVO.getRiskDepositType()) ? DIRECT_BILL_CODE : PROJECT_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)standardVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u6807\u51c6\u8868\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u6807\u51c6\u8868\u5355\u636e\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setBeforeChangeRiskDepositMny(standardVO.getRiskDepositMny());
            entity.setChangeVersion(0);
            entity.setBaseMny(standardVO.getRiskDepositMny());
        }
        this.service.saveOrUpdate((Object)entity, false);
        StandardVO vo = (StandardVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), StandardVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StandardVO> queryDetail(Long id) {
        StandardEntity entity = (StandardEntity)((Object)this.service.selectById(id));
        StandardVO vo = (StandardVO)BeanMapper.map((Object)((Object)entity), StandardVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainStandardId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("update_time", "desc");
        List recordList = this.recordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList((Iterable)recordList, StandardRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StandardVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (StandardVO standardVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), StandardVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        Map<String, Object> sumMnyMap = this.service.countSumMny(param);
        page.put("sumMnyMap", sumMnyMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Standard-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStandardData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StandardVO>> refStandardData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StandardVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryStandardByYear"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> queryStandardByYear(@RequestBody StandardVO standardVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("belong_year", new Parameter("eq", (Object)standardVO.getBelongYear()));
        queryParam.getParams().put("org_id", new Parameter("eq", (Object)standardVO.getOrgId()));
        List standardList = this.service.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)standardList)) {
            return CommonResponse.error((String)"\u5f53\u524d\u7ec4\u7ec7\u5728\u8be5\u6240\u5c5e\u5e74\u4efd\u4e0b\u5df2\u5b58\u5728\u6807\u51c6\u8868\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5e74\u4efd\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u5e74\u4efd\u53ef\u7528\uff01");
    }
}

