/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.standard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="standard")
public class StandardBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IStandardService standardService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        StandardEntity e = (StandardEntity)((Object)this.standardService.selectById(billId));
        e.setEffectDate(new Date());
        this.standardService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u98ce\u9669\u91d1\u7f34\u7eb3\u6807\u51c6\u8868\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        StandardEntity e = (StandardEntity)((Object)this.standardService.selectById(billId));
        if (e != null) {
            if (e.getChangeStatus() == ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode()) {
                return CommonResponse.error((String)"\u53d8\u66f4\u4e2d\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
            if (e.getChangeStatus() == ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode()) {
                return CommonResponse.error((String)"\u5df2\u53d8\u66f4\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
        }
        this.logger.info("\u98ce\u9669\u91d1\u7f34\u7eb3\u6807\u51c6\u8868\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u98ce\u9669\u91d1\u7f34\u7eb3\u6807\u51c6\u8868\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u98ce\u9669\u91d1\u7f34\u7eb3\u6807\u51c6\u8868\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u98ce\u9669\u91d1\u7f34\u7eb3\u6807\u51c6\u8868\u5355\u636e\u5f03\u5ba1/\u64a4\u56de\u6210\u529f\uff01");
    }
}

