package com.ejianc.business.pay.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author baipengyan
 * @date 2022/6/27
 * @description 风险金缴纳类型枚举
 */
public enum PayTypeEnum {
	/**
	 * 缴纳
	 */
	PAY(0, "缴纳"),
	/**
	 * 调入
	 */
	CALL_IN(1, "调入");

	private final Integer code;
	private final String name;

	PayTypeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	private static Map<Integer, PayTypeEnum> enumMap = new HashMap<>();

	static {
		enumMap = EnumSet.allOf(PayTypeEnum.class).stream().collect(Collectors.toMap(PayTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
	}

	public static PayTypeEnum getEnumByCode(Integer code) {
		return enumMap.get(code);
	}
}
