package com.ejianc.business.pay.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pay.bean.PayEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 风险金缴纳表
 *
 * @author baipengyan
 */
public interface IPayService extends IBaseService<PayEntity> {

	/**
	 * 获取历史版本缴纳金额
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 历史版本缴纳金额
	 */
	BigDecimal fetchLastPayTaxMny(Long userId, Long orgId);

	/**
	 * 保存前校验：一个员工+员工明细只可以有一个未生效的单据
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 */
	void checkBeforeSave(Long userId, Long orgId);

	/**
	 * 获取当前人员缴纳明细的最大缴纳日期
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 最大缴纳日期
	 */
	Date fetchMaxPayDate(Long userId, Long orgId);
}
