package com.ejianc.business.pay.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.enums.ConfirmStatusEnum;
import com.ejianc.business.pay.mapper.PayMapper;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 风险金缴纳表
 *
 * @author baipengyan
 */
@Service("payService")
public class PayServiceImpl extends BaseServiceImpl<PayMapper, PayEntity> implements IPayService {

	/**
	 * 获取历史版本缴纳金额
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 历史版本缴纳金额
	 */
	@Override
	public BigDecimal fetchLastPayTaxMny(Long userId, Long orgId) {
		QueryWrapper<PayEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.select("ifnull(sum(pay_tax_mny),0) as lastPayTaxMny")
				.eq("user_id", userId)
				.eq("org_id", orgId);
		return (BigDecimal) super.getMap(queryWrapper).get("lastPayTaxMny");
	}


	/**
	 * 保存前校验：一个员工+员工明细只可以有一个未生效的单据
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 */
	@Override
	public void checkBeforeSave(Long userId, Long orgId) {
		QueryWrapper<PayEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.select("count(1) as count")
				.eq("user_id", userId)
				.eq("org_id", orgId)
				.ne("confirm_status", ConfirmStatusEnum.CONFIRM.getCode());
		if (1 == (Long) super.getMap(queryWrapper).get("count")) {
			throw new BusinessException("一个员工的员工明细只可以有一个未生效的单据");
		}
	}


	/**
	 * 获取当前人员缴纳明细的最大缴纳日期
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 最大缴纳日期
	 */
	@Override
	public Date fetchMaxPayDate(Long userId, Long orgId) {
		QueryWrapper<PayEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.select("max(pay_date) as payDate")
				.eq("user_id", userId)
				.eq("org_id", orgId)
				.eq("confirm_status", ConfirmStatusEnum.CONFIRM.getCode());
		if (super.getMap(queryWrapper) == null) {
			return null;
		}
		return (Date) super.getMap(queryWrapper).get("payDate");
	}
}
