package com.ejianc.business.repay.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author baipengyan
 * @date 2022/6/27
 * @description 风险金退还类型枚举
 */
public enum RepayTypeEnum {
	/**
	 * 缴纳
	 */
	REPAY(0, "退还"),
	/**
	 * 调动
	 */
	CALL_IN(1, "调动");

	private final Integer code;
	private final String name;

	RepayTypeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	private static Map<Integer, RepayTypeEnum> enumMap = new HashMap<>();

	static {
		enumMap = EnumSet.allOf(RepayTypeEnum.class).stream().collect(Collectors.toMap(RepayTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
	}

	public static RepayTypeEnum getEnumByCode(Integer code) {
		return enumMap.get(code);
	}
}
