package com.ejianc.business.standard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.standard.bean.StandardChangeEntity;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.bean.StandardRecordEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.service.IStandardChangeService;
import com.ejianc.business.standard.service.IStandardRecordService;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@Service("standardChange") 
public class StandardChangeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
    private IStandardChangeService changeService;

	@Autowired
	private IStandardService standardService;

	@Autowired
	private IStandardRecordService recordService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBpmBack(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return changeService.effectiveSaveWriteStandard(billId, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBpmBack(billId, state, billTypeCode);
	}

	private CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		//提交通过、且未签章则可弃审
		StandardChangeEntity changeEntity = changeService.selectById(billId);
		changeEntity.setEffectDate(null);
		changeService.saveOrUpdate(changeEntity);

		//把记录表的数据复制到标准表上
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("main_standard_id", new Parameter(QueryParam.EQ, changeEntity.getMainStandardId()));
		queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, billId));
		List<StandardRecordEntity> recordEntityList = recordService.queryList(queryParam);
		logger.info("查询到标准表的记录表集合{}", JSONObject.toJSONString(recordEntityList));
		if (CollectionUtils.isNotEmpty(recordEntityList) && null != recordEntityList.get(0)){
			logger.info("查询到标准表的记录表{}", JSONObject.toJSONString(recordEntityList.get(0)));
			StandardRecordEntity recordEntity = recordEntityList.get(0);
			StandardEntity standardEntity = BeanMapper.map(recordEntity, StandardEntity.class);
			logger.info("撤回更新前标准表数据,standardEntity---------->: {}", JSONObject.toJSONString(standardEntity));

			standardEntity.setId(changeEntity.getMainStandardId());
			standardEntity.setChangingRiskDepositMny(null);

			//把记录表子表的id赋值为原标准表子表id
			if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
				recordEntity.getDetailList().forEach(vo -> {
					vo.setId(vo.getSrcTableId());
				});
			}
			standardEntity.setDetailList(BeanMapper.mapList(recordEntity.getDetailList(), StandardDetailEntity.class));
			standardService.saveOrUpdate(standardEntity, false);
			//删除记录表
			recordService.removeById(recordEntity.getId(), false);

			logger.info("撤回更新标准表数据成功,standardEntity---------->: {}", JSONObject.toJSONString(standardEntity));
		}





		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}

}
