/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.standard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.standard.bean.StandardChangeDetailEntity;
import com.ejianc.business.standard.bean.StandardChangeEntity;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.bean.StandardRecordEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.mapper.StandardChangeMapper;
import com.ejianc.business.standard.service.IStandardChangeService;
import com.ejianc.business.standard.service.IStandardRecordService;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.business.standard.vo.StandardChangeDetailVO;
import com.ejianc.business.standard.vo.StandardChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="standardChangeService")
public class StandardChangeServiceImpl
extends BaseServiceImpl<StandardChangeMapper, StandardChangeEntity>
implements IStandardChangeService {
    @Autowired
    private IStandardService standardService;
    @Autowired
    private IStandardRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String STANDARD_FILE_SOURCE_TYPE = "standardFile";
    private final String STANDARD_ATTACH_SOURCE_TYPE = "standardBill";
    private final String DIRECT_Bill_CODE = "EJCBT202206000037";
    private final String DIRECT_RECORD_Bill_CODE = "EJCBT202206000039";
    private final String PROSUB_Bill_CODE = "EJCBT202206000040";
    private final String PROSUB_RECORD_Bill_CODE = "EJCBT202206000042";

    @Override
    public StandardChangeVO addConvertById(Long standardId) {
        StandardEntity standardEntity = (StandardEntity)((Object)this.standardService.selectById(standardId));
        StandardChangeVO changeVO = (StandardChangeVO)BeanMapper.map((Object)((Object)standardEntity), StandardChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setMainStandardId(standardId);
        changeVO.setMainStandardCode(standardEntity.getBillCode());
        changeVO.setChangeVersion(Integer.valueOf(standardEntity.getChangeVersion() == null ? 1 : standardEntity.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setEffectDate(null);
        changeVO.setBeforeChangeRiskDepositMny(standardEntity.getRiskDepositMny());
        changeVO.setChangeRiskDepositMny(BigDecimal.ZERO);
        changeVO.setChangeScale(BigDecimal.ZERO);
        for (StandardChangeDetailVO changeDetailVO : changeVO.getDetailList()) {
            changeDetailVO.setStandardId(standardId);
            changeDetailVO.setSrcTblId(changeDetailVO.getId());
            changeDetailVO.setId(Long.valueOf(IdWorker.getId()));
        }
        return changeVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StandardChangeVO insertOrUpdate(StandardChangeVO saveOrUpdateVO) {
        StandardChangeEntity entity = (StandardChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, StandardChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            StandardEntity standardEntity = (StandardEntity)((Object)this.standardService.selectById(entity.getMainStandardId()));
            if (entity.getChangeVersion() < 11) {
                if (entity.getChangeVersion() == 1) {
                    entity.setBillCode(standardEntity.getBillCode());
                } else {
                    entity.setBillCode(entity.getBillCode() + "10" + (entity.getChangeVersion() - 1));
                }
            } else {
                entity.setBillCode(entity.getBillCode() + "1" + (entity.getChangeVersion() - 1));
            }
        }
        super.saveOrUpdate((Object)entity, false);
        this.writeBackStandard(entity);
        return (StandardChangeVO)BeanMapper.map((Object)super.selectById((Serializable)entity.getId()), StandardChangeVO.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStandardChange(Long id) {
        StandardChangeEntity changeEntity = (StandardChangeEntity)((Object)super.selectById((Serializable)id));
        StandardEntity standardEntity = (StandardEntity)((Object)this.standardService.selectById(changeEntity.getMainStandardId()));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainStandardId", new Parameter("eq", (Object)changeEntity.getMainStandardId()));
        List changeEntityList = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)changeEntityList) && changeEntityList.size() > 1) {
            standardEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        } else {
            standardEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        standardEntity.setChangeId(null);
        standardEntity.setChangeCode(null);
        standardEntity.setChangeVersion(standardEntity.getChangeStatus() - 1);
        standardEntity.setChangeDate(null);
        standardEntity.setChangeEmployeeId(null);
        standardEntity.setChangeEmployeeName(null);
        this.standardService.saveOrUpdate((Object)standardEntity, false);
        super.removeById((Serializable)id, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> effectiveSaveWriteStandard(Long changeBillId, String billTypeCode) {
        List<StandardDetailEntity> standardDetailList;
        CommonResponse resp = null;
        StandardChangeEntity changeEntity = (StandardChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\uff01\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        StandardEntity standardEntity = (StandardEntity)((Object)this.standardService.selectById(changeEntity.getMainStandardId()));
        standardEntity.setChangeEffectDate(new Date());
        StandardRecordEntity recordEntity = (StandardRecordEntity)((Object)BeanMapper.map((Object)((Object)standardEntity), StandardRecordEntity.class));
        recordEntity.setChangingRiskDepositMny(changeEntity.getRiskDepositMny());
        recordEntity.setId(null);
        recordEntity.setMainStandardId(standardEntity.getId());
        recordEntity.setBillCode(changeEntity.getBillCode());
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u6807\u51c6\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)standardEntity)));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u6807\u51c6\u8868\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(standardEntity.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u6807\u51c6\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)recordEntity)));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u6807\u51c6\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u6807\u51c6\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u53d8\u66f4\u524d\u91d1\u989d: {}", (Object)JSONObject.toJSONString((Object)recordEntity.getBeforeChangeRiskDepositMny()));
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u6807\u51c6\u8868\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u6807\u51c6\u8868\u6570\u636e\u6210\u529f\uff01");
        String srcBillCode = "EJCBT202206000040";
        String targetBillCode = "EJCBT202206000042";
        if (standardEntity.getRiskDepositType().equals("directDept")) {
            srcBillCode = "EJCBT202206000037";
            targetBillCode = "EJCBT202206000039";
        }
        if ((resp = this.copyFile(standardEntity.getId().toString(), srcBillCode, recordEntity.getId().toString(), targetBillCode, "standardBill", "standardFile")) != null) {
            this.logger.error("\u540c\u6b65\u539f\u6807\u51c6\u8868\u9644\u4ef6\u5230\u8bb0\u5f55\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u6807\u51c6\u8868,standardEntity---------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)standardEntity)));
        standardEntity.setBeforeChangeRiskDepositMny(changeEntity.getBeforeChangeRiskDepositMny());
        standardEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        standardEntity.setContractMny(changeEntity.getContractMny());
        standardEntity.setLastYearContractMny(changeEntity.getLastYearContractMny());
        standardEntity.setLastYearOutputMny(changeEntity.getLastYearOutputMny());
        standardEntity.setOutputMny(changeEntity.getOutputMny());
        standardEntity.setRiskDepositMny(changeEntity.getRiskDepositMny());
        standardEntity.setRiskDepositPayableMny(changeEntity.getRiskDepositPayableMny());
        standardEntity.setRiskDepositPayableScale(changeEntity.getRiskDepositPayableScale());
        standardEntity.setWorkerCongressContractMny(changeEntity.getWorkerCongressContractMny());
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\uff1abillTypeCode------>", (Object)billTypeCode);
        resp = this.copyFile(changeBillId.toString(), billTypeCode, standardEntity.getId().toString(), srcBillCode, "standardChangeFile", "standardBill");
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u53d8\u66f4\u9644\u4ef6\u5230\u539f\u6807\u51c6\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        changeEntity.setEffectDate(new Date());
        super.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u751f\u6548\u65f6\u95f4,changeEntity---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u5230\u539f\u6807\u51c6\u8868\u5f00\u59cb----------->" + standardEntity.getChangeStatus());
        List<StandardChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
        HashMap changeSrcIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailEntity -> changeSrcIdMap.put(changeDetailEntity.getSrcTblId() == null ? IdWorker.getId() : changeDetailEntity.getSrcTblId(), changeDetailEntity));
        }
        if (CollectionUtils.isNotEmpty(standardDetailList = standardEntity.getDetailList())) {
            for (StandardDetailEntity standardDetail : standardDetailList) {
                if (changeSrcIdMap.containsKey(standardDetail.getId())) {
                    standardDetail.setDetailMemo(((StandardChangeDetailEntity)((Object)changeSrcIdMap.get(standardDetail.getId()))).getDetailMemo());
                    changeSrcIdMap.remove(standardDetail.getId());
                    continue;
                }
                standardDetail.setRowState("del");
            }
            if (null != changeSrcIdMap) {
                for (Long key : changeSrcIdMap.keySet()) {
                    StandardChangeDetailEntity changeDetailEntity2 = (StandardChangeDetailEntity)((Object)changeSrcIdMap.get(key));
                    changeDetailEntity2.setId(null);
                    changeDetailEntity2.setRowState("add");
                    standardDetailList.add((StandardDetailEntity)((Object)BeanMapper.map((Object)((Object)changeDetailEntity2), StandardDetailEntity.class)));
                }
            }
        }
        standardEntity.setDetailList(standardDetailList);
        this.standardService.saveOrUpdate((Object)standardEntity, false);
        this.logger.info("\u66f4\u65b0\u6807\u51c6\u8868\u6570\u636e\u6210\u529f,standardEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)standardEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u4e3b\u6807\u51c6\u8868\u6210\u529f\uff01");
    }

    private void writeBackStandard(StandardChangeEntity changeEntity) {
        StandardEntity standardEntity = (StandardEntity)((Object)this.standardService.selectById(changeEntity.getMainStandardId()));
        if (null == standardEntity.getChangeId() || !standardEntity.getChangeId().equals(changeEntity.getId())) {
            standardEntity.setChangeId(changeEntity.getId());
            standardEntity.setChangeCode(changeEntity.getBillCode());
            standardEntity.setChangeVersion(changeEntity.getChangeVersion());
            standardEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
            standardEntity.setChangeDate(new Date());
        }
        standardEntity.setChangeEmployeeId(changeEntity.getChangeEmployeeId());
        standardEntity.setChangeEmployeeName(changeEntity.getChangeEmployeeName());
        this.standardService.saveOrUpdate((Object)standardEntity, false);
    }

    private StandardChangeVO queryDetail(Long changeId) {
        return (StandardChangeVO)BeanMapper.map((Object)super.selectById((Serializable)changeId), StandardChangeVO.class);
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, String targetBillType) {
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, targetBillType);
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u6807\u51c6\u8868\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, targetBillType, targetBillId, targetBillTypeCode, targetBillType, copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        return null;
    }
}

