package com.ejianc.business.standard.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.bean.StandardRecordEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.service.IStandardDetailService;
import com.ejianc.business.standard.service.IStandardRecordService;
import com.ejianc.business.standard.utils.ReferTool;
import com.ejianc.business.standard.vo.StandardDetailVO;
import com.ejianc.business.standard.vo.StandardRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.business.standard.vo.StandardVO;

/**
 * 风险金缴纳标准表主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("standard")
public class StandardController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private IStandardService service;

    @Autowired
    private IStandardRecordService recordService;

    @Autowired
    private IStandardDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StandardVO> saveOrUpdate(@RequestBody StandardVO standardVO) {
        StandardVO vo = service.insertOrUpdate(standardVO);

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StandardVO> queryDetail(Long id) {
    	StandardEntity entity = service.selectById(id);
    	StandardVO vo = BeanMapper.map(entity, StandardVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainStandardId", new Parameter(QueryParam.EQ, vo.getId()));
        queryParam.getOrderMap().put("update_time", QueryParam.DESC);
        List<StandardRecordEntity> recordList = recordService.queryList(queryParam);
    	vo.setRecordList(BeanMapper.mapList(recordList, StandardRecordVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StandardVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (StandardVO vo : vos) {
            }
        }
        service.removeByIds(vos.stream().map(StandardVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前组织id相当于是项目的parentOrgId，则根据项目部Id来进行查询
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        if (orgResp.getData().size() > 0){
            param.getParams().put("orgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        }

        IPage<StandardEntity> pageData = service.queryPage(param,false);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), StandardVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());

        //页面统计，累计申请金额，累计批复金额，累计实付金额
        Map<String, Object> sumMnyMap = service.countSumMny(param);
        page.put("sumMnyMap", sumMnyMap);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = queryList(param);
        List<StandardVO> standardVOList = new ArrayList<>();
        if (null != commonResponse.getData()) {
            standardVOList = (List<StandardVO>) commonResponse.getData().get("records");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");

            if (null != standardVOList && standardVOList.size() > 0) {
                for (StandardVO standardVO : standardVOList) {
                    standardVO.setBelongYearName(sdf.format(standardVO.getBelongYear()));
                    //变更状态
                    standardVO.setChangeStatusName(ChangeStatusEnum.getEnumByCode(standardVO.getChangeStatus()).getDescription());
                    //流程状态
                    standardVO.setBillStateName(BillStateEnum.getEnumByStateCode(standardVO.getBillState()).getDescription());
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", standardVOList);
        if (null != param.getParams().get("riskDepositType")) {
            //导出无合同付款申请列表
            if (param.getParams().get("riskDepositType").getValue().equals("projectDept")) {
                ExcelExport.getInstance().export("projectDeptStandard-export.xlsx", beans, response);
            } else {
                ExcelExport.getInstance().export("directDeptStandard-export.xlsx", beans, response);
            }
        }
    }
    /**
     * @Description 参照 风险金缴纳标准表
     * @Return void
     * @return
     */
    @RequestMapping(value = "/refStandardData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StandardVO>> refStandardData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                          String condition,
                                                          String searchObject,
                                                          String searchText,
                                                          String relyCondition) {

        Map<String, Parameter> parameterMap = ReferTool.parseCondition(relyCondition);
        Map<String, String> orgMap = new HashMap<>();
        parameterMap.keySet().forEach(key -> orgMap.put(key, String.valueOf(parameterMap.get(key).getValue())));
        String orgId = orgMap.get("id");

        if(StringUtils.isBlank(orgId)) {
            return CommonResponse.error("查询失败，缺少参数组织id-id！");
        }

        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(Long.valueOf(orgId));
        if (!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        if (orgResp.getData().size() > 0){
            param.getParams().put("orgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        }
        param.getParams().put("riskDepositType", new Parameter(QueryParam.EQ, "directDept"));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));

        IPage<StandardEntity> page = service.queryPage(param,false);
        IPage<StandardVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StandardVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }



    /**
     * @Description 参照 风险金缴纳  项目 标准表
     * @Return void
     * @return
     */
    @RequestMapping(value = "/refProjectStandardData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StandardVO>> refProjectStandardData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText,
                                                             String relyCondition) {

        Map<String, Parameter> parameterMap = ReferTool.parseCondition(relyCondition);
        Map<String, String> orgMap = new HashMap<>();
        parameterMap.keySet().forEach(key -> orgMap.put(key, String.valueOf(parameterMap.get(key).getValue())));
        String orgId = orgMap.get("id");

        if(StringUtils.isBlank(orgId)) {
            return CommonResponse.error("查询失败，缺少参数组织id-id！");
        }

        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(Long.valueOf(orgId));
        if (!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        if (orgResp.getData().size() > 0){
            param.getParams().put("orgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        }

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        param.getParams().put("riskDepositType", new Parameter(QueryParam.EQ, "projectDept"));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));

        IPage<StandardEntity> page = service.queryPage(param,false);
        IPage<StandardVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StandardVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * @Description 判断是否能使用当前年份
     * @param
     */
    @RequestMapping(value = "/queryStandardByYear", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> queryStandardByYear(@RequestBody StandardVO standardVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("belong_year", new Parameter(QueryParam.EQ, standardVO.getBelongYear()));
        queryParam.getParams().put("org_id", new Parameter(QueryParam.EQ, standardVO.getOrgId()));
        List<StandardEntity> standardList = service.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(standardList)){
            return CommonResponse.error("当前组织在该所属年份下已存在标准表单据，请选择其他年份！");
        }
        return CommonResponse.success("该年份可用！");
    }



    /**
     * @Description 判断项目是否被 项目部 风险金缴纳标准表使用 如被使用，则不可删除
     * @param
     */
    @RequestMapping(value = "/queryProjectDeleteFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> queryProjectDeleteFlag(@RequestBody Map<String, String> param) {
        String projectIds = param.get("projectIds");
        if (StringUtils.isNotBlank(projectIds)){
            return service.queryProjectDeleteFlag(projectIds);
        }
        return CommonResponse.error("请传入正确的项目id参数！");
    }

}
