/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pay.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.enums.ConfirmStatusEnum;
import com.ejianc.business.pay.enums.InstallmentFlagEnum;
import com.ejianc.business.pay.enums.PayTypeEnum;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.business.pay.vo.PayVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"pay"})
public class PayController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RULE_CODE = "RISK_PAY";
    private static final String BILL_CODE = "EJCBT202206000055";
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final IPayService service;
    private final SessionManager sessionManager;

    public PayController(IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, IPayService service, SessionManager sessionManager) {
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
        this.sessionManager = sessionManager;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<PayVO> saveOrUpdate(@RequestBody PayVO saveOrUpdateVO) {
        PayEntity entity = (PayEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u98ce\u9669\u91d1\u7f34\u7eb3");
        entity.setBillType(BILL_CODE);
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        entity.setType(PayTypeEnum.PAY.getCode());
        entity.setTypeName(PayTypeEnum.PAY.getName());
        entity.setInstallmentFlagName(InstallmentFlagEnum.getEnumByCode(entity.getInstallmentFlag()).getName());
        entity.setConfirmStatus(ConfirmStatusEnum.UNCONFIRM.getCode());
        entity.setConfirmStatusName(ConfirmStatusEnum.UNCONFIRM.getName());
        this.service.saveOrUpdate((Object)entity, false);
        PayVO vo = (PayVO)BeanMapper.map((Object)((Object)entity), PayVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<PayVO> queryDetail(Long id) {
        PayEntity entity = (PayEntity)((Object)this.service.selectById(id));
        PayVO vo = (PayVO)BeanMapper.map((Object)((Object)entity), PayVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<PayVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            for (PayVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<PayVO>> queryList(@RequestBody QueryParam param) {
        UserContext userContextCache;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        if (param.getParams().containsKey("confirmStatus")) {
            userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
            }
            param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        } else {
            userContextCache = this.sessionManager.getUserContext();
            param.getParams().put("userId", new Parameter("eq", (Object)userContextCache.getUserId()));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        UserContext userContextCache;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        if (param.getParams().containsKey("confirmStatus")) {
            userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
            }
            param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        } else {
            userContextCache = this.sessionManager.getUserContext();
            param.getParams().put("userId", new Parameter("eq", (Object)userContextCache.getUserId()));
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage page = this.service.queryPage(param, false);
        ArrayList pays = new ArrayList();
        page.getRecords().forEach(e -> {
            PayVO payVO = (PayVO)BeanMapper.map((Object)e, PayVO.class);
            payVO.setConfirmStatusName(ConfirmStatusEnum.getEnumByCode(payVO.getConfirmStatus()).getName());
            payVO.setTypeName(PayTypeEnum.getEnumByCode(payVO.getType()).getName());
            payVO.setInstallmentFlagName(InstallmentFlagEnum.getEnumByCode(payVO.getInstallmentFlag()).getName());
            payVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)payVO.getBillState()).getDescription());
            pays.add(payVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", pays);
        if (param.getParams().containsKey("confirmStatus")) {
            Integer confirmStatus = (Integer)((Parameter)param.getParams().get("confirmStatus")).getValue();
            if (Objects.equals(confirmStatus, ConfirmStatusEnum.CONFIRMING.getCode())) {
                ExcelExport.getInstance().export("pay-unconfirm-export.xlsx", beans, response);
            }
            if (Objects.equals(confirmStatus, ConfirmStatusEnum.CONFIRM.getCode())) {
                ExcelExport.getInstance().export("pay-confirm-export.xlsx", beans, response);
            }
        } else {
            ExcelExport.getInstance().export("pay-export.xlsx", beans, response);
        }
    }

    @GetMapping(value={"/fetchMaxPayDate"})
    public CommonResponse<Date> fetchMaxPayDate(@RequestParam(value="sourceBillId") Long sourceBillId) {
        return CommonResponse.success((String)"\u83b7\u53d6\u5f53\u524d\u4eba\u5458\u7f34\u7eb3\u660e\u7ec6\u7684\u6700\u5927\u7f34\u7eb3\u65e5\u671f\u6210\u529f\uff01", (Object)this.service.fetchMaxPayDate(sourceBillId));
    }

    @PostMapping(value={"/batchConfirm"})
    public CommonResponse<String> batchConfirm(@RequestBody List<PayVO> pays) {
        this.service.batchConfirm(pays);
        return CommonResponse.success((String)"\u786e\u8ba4\u6210\u529f\uff01");
    }
}

