/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.payer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.payer.bean.PayerChangeEntity;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.bean.PayerRecordEntity;
import com.ejianc.business.payer.service.IPayerChangeService;
import com.ejianc.business.payer.service.IPayerRecordService;
import com.ejianc.business.payer.service.IPayerService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payerChange")
public class PayerChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayerChangeService changeService;
    @Autowired
    private IPayerRecordService recordService;
    @Autowired
    private IPayerService payerService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return this.changeService.effectiveSaveWriteStandard(billId, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        PayerChangeEntity changeEntity = (PayerChangeEntity)((Object)this.changeService.selectById(billId));
        changeEntity.setEffectDate(null);
        this.changeService.saveOrUpdate((Object)changeEntity);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_payer_id", new Parameter("eq", (Object)changeEntity.getMainPayerId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)billId));
        List recordEntityList = this.recordService.queryList(queryParam);
        this.logger.info("\u67e5\u8be2\u5230\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u7684\u8bb0\u5f55\u8868\u96c6\u5408{}", (Object)JSONObject.toJSONString((Object)recordEntityList));
        if (CollectionUtils.isNotEmpty((Collection)recordEntityList) && null != recordEntityList.get(0)) {
            this.logger.info("\u67e5\u8be2\u5230\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u7684\u8bb0\u5f55\u8868{}", (Object)JSONObject.toJSONString(recordEntityList.get(0)));
            PayerRecordEntity recordEntity = (PayerRecordEntity)((Object)recordEntityList.get(0));
            PayerEntity payerEntity = (PayerEntity)((Object)BeanMapper.map((Object)((Object)recordEntity), PayerEntity.class));
            this.logger.info("\u64a4\u56de\u66f4\u65b0\u524d\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u6570\u636e,standardEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)payerEntity)));
            payerEntity.setId(changeEntity.getMainPayerId());
            payerEntity.setChangingPayerMny(null);
            if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
                recordEntity.getDetailList().forEach(vo -> vo.setId(vo.getSrcTableId()));
            }
            payerEntity.setDetailList(BeanMapper.mapList(recordEntity.getDetailList(), PayerDetailEntity.class));
            payerEntity.setVersion(payerEntity.getVersion() + 1);
            this.logger.info("\u4fdd\u5b58\u7f34\u7eb3\u4eba\u5458\u660e\u7ec6\u8868\u6570\u636e\uff01");
            this.payerService.saveOrUpdate((Object)payerEntity, false);
            this.recordService.removeById(recordEntity.getId(), false);
            this.logger.info("\u64a4\u56de\u66f4\u65b0\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u6570\u636e\u6210\u529f,standardEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)payerEntity)));
        }
        return CommonResponse.success((String)"\u6267\u884c\u53d8\u66f4\u5355\u64a4\u56de\u56de\u8c03\u903b\u8f91\u6210\u529f\uff01");
    }
}

