/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.payer.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.service.IPayerRecordService;
import com.ejianc.business.payer.service.IPayerService;
import com.ejianc.business.payer.vo.PayerDetailVO;
import com.ejianc.business.payer.vo.PayerRecordVO;
import com.ejianc.business.payer.vo.PayerVO;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payer"})
public class PayerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayerService service;
    @Autowired
    private IPayerRecordService recordService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayerVO> saveOrUpdate(@RequestBody PayerVO payerVO) {
        PayerVO vo = this.service.insertOrUpdate(payerVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayerVO> queryDetail(Long id) {
        PayerEntity entity = (PayerEntity)((Object)this.service.selectById(id));
        PayerVO vo = (PayerVO)BeanMapper.map((Object)((Object)entity), PayerVO.class);
        vo = this.service.transformWan(vo);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainPayerId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("update_time", "desc");
        List recordList = this.recordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList((Iterable)recordList, PayerRecordVO.class));
        if (CollectionUtils.isNotEmpty((Collection)vo.getRecordList())) {
            for (PayerRecordVO recordDetail : vo.getRecordList()) {
                if (null != recordDetail.getBeforeChangePayerMny()) {
                    recordDetail.setBeforeChangePayerMnyWan(recordDetail.getBeforeChangePayerMny().divide(new BigDecimal(10000)));
                } else {
                    recordDetail.setBeforeChangePayerMnyWan(BigDecimal.ZERO);
                }
                if (null != recordDetail.getChangingPayerMny()) {
                    recordDetail.setChangingPayerMnyWan(recordDetail.getChangingPayerMny().divide(new BigDecimal(10000)));
                    continue;
                }
                recordDetail.setChangingPayerMnyWan(BigDecimal.ZERO);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayerVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayerVO payerVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (((List)orgResp.getData()).size() > 0) {
            param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        }
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        List returnRecords = BeanMapper.mapList((Iterable)pageData.getRecords(), PayerVO.class);
        if (CollectionUtils.isNotEmpty((Collection)returnRecords)) {
            for (PayerVO record : returnRecords) {
                if (null != record.getTotalPayerMny()) {
                    record.setTotalPayerMnyWan(record.getTotalPayerMny().divide(new BigDecimal(10000)));
                    continue;
                }
                record.setTotalPayerMnyWan(BigDecimal.ZERO);
            }
        }
        page.put("records", (Object)returnRecords);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        Map<String, Object> sumMnyMap = this.service.countSumMny(param);
        page.put("sumMnyMap", sumMnyMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List payerVOList = new ArrayList();
        if (null != commonResponse.getData()) {
            payerVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (null != payerVOList && payerVOList.size() > 0) {
                for (PayerVO payerVO : payerVOList) {
                    payerVO.setChangeStatusName(ChangeStatusEnum.getEnumByCode(payerVO.getChangeStatus()).getDescription());
                    payerVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)payerVO.getBillState()).getDescription());
                }
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", payerVOList);
        if (null != param.getParams().get("riskDepositType")) {
            if (((Parameter)param.getParams().get("riskDepositType")).getValue().equals("projectDept")) {
                ExcelExport.getInstance().export("projectDeptPayer-export.xlsx", beans, response);
            } else {
                ExcelExport.getInstance().export("directDeptPayer-export.xlsx", beans, response);
            }
        }
    }

    @RequestMapping(value={"/refpayerData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PayerVO>> refpayerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryStandardFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Integer> queryStandardFlag(@RequestBody Map<String, String> param) {
        String standardId = param.get("standardId");
        if (StringUtils.isNotBlank((CharSequence)standardId)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("standardId", new Parameter("eq", (Object)standardId));
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)this.service.queryList(queryParam).size());
        }
        return CommonResponse.error((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u9879\u76eeid\u53c2\u6570\uff01");
    }

    @RequestMapping(value={"/payerDetailExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void payerDetailExcelExport(@RequestBody Map paramMap, HttpServletResponse response) {
        String payerId = String.valueOf(paramMap.get("payerId"));
        PayerEntity payerEntity = (PayerEntity)((Object)this.service.selectById((Serializable)((Object)payerId)));
        List detailList = new ArrayList();
        if (null != payerEntity && CollectionUtils.isNotEmpty(payerEntity.getDetailList())) {
            detailList = BeanMapper.mapList(payerEntity.getDetailList(), PayerDetailVO.class);
        }
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(detailVO -> {
                if (null != detailVO.getPeriodizationFlag()) {
                    if (0 == detailVO.getPeriodizationFlag()) {
                        detailVO.setPeriodizationFlagName("\u5426");
                    } else {
                        detailVO.setPeriodizationFlagName("\u662f");
                    }
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("payerDetail-export.xlsx", beans, response);
    }
}

