/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.repay.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.enums.ConfirmStatusEnum;
import com.ejianc.business.pay.enums.InstallmentFlagEnum;
import com.ejianc.business.pay.enums.PayTypeEnum;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.service.IPayerDetailService;
import com.ejianc.business.repay.bean.RepayEntity;
import com.ejianc.business.repay.enums.RepayTypeEnum;
import com.ejianc.business.repay.mapper.RepayMapper;
import com.ejianc.business.repay.service.IRepayService;
import com.ejianc.business.repay.vo.RepayVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repayService")
public class RepayServiceImpl
extends BaseServiceImpl<RepayMapper, RepayEntity>
implements IRepayService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PAY_BILL_CODE = "EJCBT202206000055";
    private static final String TEN_THOUSAND = "10000";
    private final SessionManager sessionManager;
    private final IPayerDetailService payerDetailService;
    private final IPayService payService;

    public RepayServiceImpl(SessionManager sessionManager, IPayerDetailService payerDetailService, IPayService payService) {
        this.sessionManager = sessionManager;
        this.payerDetailService = payerDetailService;
        this.payService = payService;
    }

    @Override
    public boolean isLatestBill(Long billId, Long sourceBillId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"source_bill_id", (Object)sourceBillId)).orderByDesc((Object)"repay_date");
        List list = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return ((RepayEntity)((Object)list.get(0))).getId().equals(billId);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchConfirm(List<RepayVO> repays) {
        List callInList;
        List repayEntities = BeanMapper.mapList(repays, RepayEntity.class);
        UserContext userContext = this.sessionManager.getUserContext();
        ArrayList<RepayEntity> repayEntityList = new ArrayList<RepayEntity>();
        List repayList = repayEntities.stream().filter(repay -> RepayTypeEnum.REPAY.getCode().equals(repay.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(repayList)) {
            Map repayMap = repayList.stream().collect(Collectors.toMap(RepayEntity::getSourceBillId, Function.identity()));
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Map.Entry entry : repayMap.entrySet()) {
                RepayEntity repay2 = (RepayEntity)((Object)entry.getValue());
                repay2.setConfirmStatus(ConfirmStatusEnum.CONFIRM.getCode());
                repay2.setConfirmStatusName(ConfirmStatusEnum.CONFIRM.getName());
                repay2.setConfirmDate(new Date());
                repay2.setConfirmUserId(userContext.getUserId());
                repay2.setConfirmUserCode(userContext.getUserCode());
                repay2.setConfirmUserName(userContext.getUserName());
                repayEntityList.add(repay2);
                ids.add(repay2.getSourceBillId());
            }
            Collection payerDetails = this.payerDetailService.listByIds(ids);
            for (PayerDetailEntity pd : payerDetails) {
                RepayEntity repay3 = (RepayEntity)((Object)repayMap.get(pd.getId()));
                BigDecimal actualPayerMny = pd.getActualPayerMny().subtract(repay3.getRepayTaxMny()).setScale(2, RoundingMode.HALF_UP);
                pd.setActualPayerMny(actualPayerMny);
                pd.setActualPayerScale(actualPayerMny.divide(pd.getPayerMny(), 2, RoundingMode.HALF_UP));
                pd.setRemainderPayerMny(pd.getPayerMny().subtract(actualPayerMny).setScale(2, RoundingMode.HALF_UP));
            }
            this.payerDetailService.saveOrUpdateBatch(payerDetails, 10);
        }
        if (CollectionUtils.isNotEmpty(callInList = repayEntities.stream().filter(repay -> RepayTypeEnum.CALL_IN.getCode().equals(repay.getType())).collect(Collectors.toList()))) {
            ArrayList<PayEntity> pays = new ArrayList<PayEntity>();
            ArrayList<PayerDetailEntity> pds = new ArrayList<PayerDetailEntity>();
            Map map = callInList.stream().collect(Collectors.toMap(RepayEntity::getSourceBillId, Function.identity()));
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Map.Entry entry : map.entrySet()) {
                RepayEntity repay4 = (RepayEntity)((Object)entry.getValue());
                repay4.setConfirmStatus(ConfirmStatusEnum.CONFIRM.getCode());
                repay4.setConfirmStatusName(ConfirmStatusEnum.CONFIRM.getName());
                repay4.setConfirmDate(new Date());
                repay4.setConfirmUserId(userContext.getUserId());
                repay4.setConfirmUserCode(userContext.getUserCode());
                repay4.setConfirmUserName(userContext.getUserName());
                repayEntityList.add(repay4);
                ids.add(repay4.getSourceBillId());
                QueryWrapper pdWrapper = new QueryWrapper();
                pdWrapper.eq((Object)"id", (Object)repay4.getTransferSourceBillId());
                PayerDetailEntity npd = (PayerDetailEntity)((Object)this.payerDetailService.getOne((Wrapper)pdWrapper));
                if (npd == null) {
                    this.logger.error("\u5458\u5de5\u660e\u7ec6\u4e0d\u5b58\u5728\uff0cuserId={},payerOrgId={}", (Object)repay4.getUserId(), (Object)repay4.getTransferOrgId());
                    throw new BusinessException("\u5458\u5de5\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
                BigDecimal actualPayerMny1 = npd.getActualPayerMny();
                BigDecimal actualPayerMny = actualPayerMny1.add(repay4.getRepayTaxMny()).setScale(2, RoundingMode.HALF_UP);
                npd.setActualPayerMny(actualPayerMny);
                npd.setActualPayerScale(actualPayerMny.divide(npd.getPayerMny(), 2, RoundingMode.HALF_UP));
                npd.setRemainderPayerMny(npd.getPayerMny().subtract(actualPayerMny).setScale(2, RoundingMode.HALF_UP));
                PayEntity pay = new PayEntity();
                pay.setOrgId(repay4.getTransferOrgId());
                pay.setOrgCode(repay4.getTransferOrgCode());
                pay.setOrgName(repay4.getTransferOrgName());
                pay.setProjectId(repay4.getTransferProjectId());
                pay.setProjectCode(repay4.getTransferProjectCode());
                pay.setProjectName(repay4.getTransferProjectName());
                pay.setProjectOrgId(repay4.getTransferProjectOrgId());
                pay.setProjectOrgCode(repay4.getTransferProjectOrgCode());
                pay.setProjectOrgName(repay4.getTransferProjectOrgName());
                pay.setEmployeeId(repay4.getEmployeeId());
                pay.setEmployeeName(repay4.getEmployeeName());
                pay.setDepartmentId(repay4.getDepartmentId());
                pay.setDepartmentCode(repay4.getDepartmentCode());
                pay.setDepartmentName(repay4.getDepartmentName());
                pay.setCommitDate(new Date());
                pay.setCommitUserName(userContext.getUserName());
                pay.setCommitUserCode(userContext.getUserCode());
                pay.setEffectiveDate(new Date());
                pay.setBillCode(PAY_BILL_CODE);
                pay.setBillName("\u98ce\u9669\u91d1\u7f34\u7eb3");
                pay.setBillType("\u98ce\u9669\u62b5\u62bc\u91d1");
                pay.setPayerDetailId(repay4.getPayerDetailId());
                pay.setPayerDetailCode(repay4.getPayerDetailCode());
                pay.setPayerDetailName(repay4.getPayerDetailName());
                pay.setUserId(repay4.getUserId());
                pay.setUserCode(repay4.getUserCode());
                pay.setUserName(repay4.getUserName());
                pay.setSourceUserId(npd.getUserId());
                pay.setSourceUserCode(npd.getPhone());
                pay.setSourceUserName(npd.getName());
                pay.setSourceBillId(npd.getId());
                pay.setSourceBillCode(npd.getPayerCode());
                pay.setSourceBillName(npd.getPayerName());
                pay.setSourceBillType(null);
                pay.setSourceOrgId(npd.getPayerOrgId());
                pay.setSourceOrgCode(npd.getPayerOrgCode());
                pay.setSourceOrgName(npd.getPayerOrgName());
                pay.setSourcePeriodizationFlag(npd.getPeriodizationFlag());
                pay.setSourcePayerMny(npd.getPayerMny());
                pay.setSourceActualPayerMny(npd.getActualPayerMny());
                pay.setSourcePayScale(npd.getActualPayerScale());
                pay.setSourceRemainderPayerMny(npd.getRemainderPayerMny());
                pay.setSourcePeriodizationMny(npd.getPeriodizationMny());
                pay.setSourcePeriodizationNum(npd.getPeriodizationNum());
                pay.setType(PayTypeEnum.CALL_IN.getCode());
                pay.setTypeName(PayTypeEnum.CALL_IN.getName());
                pay.setPayerMny(npd.getPayerMny());
                pay.setPayTaxMny(repay4.getRepayTaxMny());
                pay.setLastPayTaxMny(actualPayerMny1);
                pay.setTotalTaxMny(npd.getActualPayerMny());
                pay.setPayScale(npd.getActualPayerScale());
                pay.setRemainPayTaxMny(npd.getRemainderPayerMny());
                String code = npd.getPeriodizationFlag() != null ? String.valueOf(npd.getPeriodizationFlag()) : "0";
                pay.setInstallmentFlag(code);
                pay.setInstallmentFlagName(InstallmentFlagEnum.getEnumByCode(code).getName());
                pay.setPayDate(new Date());
                pay.setMemo(repay4.getMemo());
                pay.setConfirmDate(new Date());
                pay.setConfirmUserId(userContext.getUserId());
                pay.setConfirmUserName(userContext.getUserName());
                pay.setConfirmUserCode(userContext.getUserCode());
                pay.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());
                pay.setBillStateName(BillStateEnum.PASSED_STATE.getDescription());
                pay.setConfirmStatus(ConfirmStatusEnum.CONFIRM.getCode());
                pay.setConfirmStatusName(ConfirmStatusEnum.CONFIRM.getName());
                pay.setType(PayTypeEnum.CALL_IN.getCode());
                pay.setTypeName(PayTypeEnum.CALL_IN.getName());
                pays.add(pay);
                pds.add(npd);
            }
            this.payerDetailService.saveOrUpdateBatch(pds, 10);
            this.payService.saveOrUpdateBatch(pays, 10);
            Collection payerDetails = this.payerDetailService.listByIds(ids);
            for (PayerDetailEntity pd : payerDetails) {
                RepayEntity repay5 = (RepayEntity)((Object)map.get(pd.getId()));
                BigDecimal actualPayerMny = pd.getActualPayerMny().subtract(repay5.getRepayTaxMny()).setScale(2, RoundingMode.HALF_UP);
                pd.setActualPayerMny(actualPayerMny);
                pd.setActualPayerScale(actualPayerMny.divide(pd.getPayerMny(), 2, RoundingMode.HALF_UP));
                pd.setRemainderPayerMny(pd.getPayerMny().subtract(actualPayerMny).setScale(2, RoundingMode.HALF_UP));
            }
            this.payerDetailService.saveOrUpdateBatch(payerDetails, 10);
        }
        super.saveOrUpdateBatch(repayEntityList, 10);
    }

    @Override
    public CommonResponse<String> checkBeforeSave(Long sourceBillId, String info) {
        QueryWrapper payWrapper = new QueryWrapper();
        ((QueryWrapper)payWrapper.select(new String[]{"ifnull(count(*),0) as count"}).eq((Object)"source_bill_id", (Object)sourceBillId)).notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Long pay = (Long)this.payService.getMap((Wrapper)payWrapper).get("count");
        if (pay != 0L) {
            return CommonResponse.error((String)("\u8be5\u5458\u5de5\u6709\u672a\u751f\u6548\u7684\u7f34\u7eb3\u5355\u636e\uff0c\u4e0d\u652f\u6301" + info));
        }
        QueryWrapper repayWrapper = new QueryWrapper();
        ((QueryWrapper)repayWrapper.select(new String[]{"ifnull(count(*),0) as count"}).eq((Object)"source_bill_id", (Object)sourceBillId)).notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Long repay = (Long)super.getMap((Wrapper)repayWrapper).get("count");
        if (repay != 0L) {
            return CommonResponse.error((String)("\u8be5\u5458\u5de5\u6709\u672a\u751f\u6548\u7684\u9000\u8fd8\u5355\u636e\uff0c\u4e0d\u652f\u6301" + info));
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f");
    }
}

