/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.standard.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.service.IStandardDetailService;
import com.ejianc.business.standard.service.IStandardRecordService;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.business.standard.utils.ReferTool;
import com.ejianc.business.standard.vo.StandardRecordVO;
import com.ejianc.business.standard.vo.StandardVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"standard"})
public class StandardController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IStandardService service;
    @Autowired
    private IStandardRecordService recordService;
    @Autowired
    private IStandardDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StandardVO> saveOrUpdate(@RequestBody StandardVO standardVO) {
        StandardVO vo = this.service.insertOrUpdate(standardVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StandardVO> queryDetail(Long id) {
        StandardEntity entity = (StandardEntity)((Object)this.service.selectById(id));
        StandardVO vo = (StandardVO)BeanMapper.map((Object)((Object)entity), StandardVO.class);
        vo = this.service.transformWan(vo);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainStandardId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("update_time", "desc");
        List recordList = this.recordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList((Iterable)recordList, StandardRecordVO.class));
        if (CollectionUtils.isNotEmpty((Collection)vo.getRecordList())) {
            for (StandardRecordVO recordDetail : vo.getRecordList()) {
                if (null != recordDetail.getBeforeChangeRiskDepositMny()) {
                    recordDetail.setBeforeChangeRiskDepositMnyWan(recordDetail.getBeforeChangeRiskDepositMny().divide(new BigDecimal(10000)));
                } else {
                    recordDetail.setBeforeChangeRiskDepositMnyWan(BigDecimal.ZERO);
                }
                if (null != recordDetail.getChangingRiskDepositMny()) {
                    recordDetail.setChangingRiskDepositMnyWan(recordDetail.getChangingRiskDepositMny().divide(new BigDecimal(10000)));
                    continue;
                }
                recordDetail.setChangingRiskDepositMnyWan(BigDecimal.ZERO);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailByProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StandardVO> queryDetailByProject(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        List recordList = this.service.queryList(queryParam);
        StandardVO vo = (StandardVO)BeanMapper.map(recordList.get(0), StandardVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StandardVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (StandardVO standardVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (((List)orgResp.getData()).size() > 0) {
            param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        }
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        List returnRecords = BeanMapper.mapList((Iterable)pageData.getRecords(), StandardVO.class);
        if (CollectionUtils.isNotEmpty((Collection)returnRecords)) {
            for (StandardVO record : returnRecords) {
                if (null != record.getRiskDepositMny()) {
                    record.setRiskDepositMnyWan(record.getRiskDepositMny().divide(new BigDecimal(10000)));
                    continue;
                }
                record.setRiskDepositMnyWan(BigDecimal.ZERO);
            }
        }
        page.put("records", (Object)returnRecords);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        Map<String, Object> sumMnyMap = this.service.countSumMny(param);
        page.put("sumMnyMap", sumMnyMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List standardVOList = new ArrayList();
        if (null != commonResponse.getData()) {
            standardVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            if (null != standardVOList && standardVOList.size() > 0) {
                for (StandardVO standardVO : standardVOList) {
                    standardVO.setBelongYearName(sdf.format(standardVO.getBelongYear()));
                    standardVO.setChangeStatusName(ChangeStatusEnum.getEnumByCode(standardVO.getChangeStatus()).getDescription());
                    standardVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)standardVO.getBillState()).getDescription());
                }
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", standardVOList);
        if (null != param.getParams().get("riskDepositType")) {
            if (((Parameter)param.getParams().get("riskDepositType")).getValue().equals("projectDept")) {
                ExcelExport.getInstance().export("projectDeptStandard-export.xlsx", beans, response);
            } else {
                ExcelExport.getInstance().export("directDeptStandard-export.xlsx", beans, response);
            }
        }
    }

    @RequestMapping(value={"/refStandardData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StandardVO>> refStandardData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText, String relyCondition) {
        Map<String, Parameter> parameterMap = ReferTool.parseCondition(relyCondition);
        HashMap orgMap = new HashMap();
        parameterMap.keySet().forEach(key -> orgMap.put(key, String.valueOf(((Parameter)parameterMap.get(key)).getValue())));
        String orgId = (String)orgMap.get("id");
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u7ec4\u7ec7id-id\uff01");
        }
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(Long.valueOf(orgId));
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (((List)orgResp.getData()).size() > 0) {
            param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        }
        param.getParams().put("riskDepositType", new Parameter("eq", (Object)"directDept"));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        List returnRecords = BeanMapper.mapList((Iterable)page.getRecords(), StandardVO.class);
        if (CollectionUtils.isNotEmpty((Collection)returnRecords)) {
            for (StandardVO record : returnRecords) {
                if (null != record.getRiskDepositMny()) {
                    record.setRiskDepositMnyWan(record.getRiskDepositMny().divide(new BigDecimal(10000)));
                    continue;
                }
                record.setRiskDepositMnyWan(BigDecimal.ZERO);
            }
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(returnRecords);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refProjectStandardData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StandardVO>> refProjectStandardData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText, String relyCondition) {
        Map<String, Parameter> parameterMap = ReferTool.parseCondition(relyCondition);
        HashMap orgMap = new HashMap();
        parameterMap.keySet().forEach(key -> orgMap.put(key, String.valueOf(((Parameter)parameterMap.get(key)).getValue())));
        String orgId = (String)orgMap.get("id");
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u7ec4\u7ec7id-id\uff01");
        }
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(Long.valueOf(orgId));
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (((List)orgResp.getData()).size() > 0) {
            param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("riskDepositType", new Parameter("eq", (Object)"projectDept"));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List returnRecords = BeanMapper.mapList((Iterable)page.getRecords(), StandardVO.class);
        if (CollectionUtils.isNotEmpty((Collection)returnRecords)) {
            for (StandardVO record : returnRecords) {
                if (null != record.getRiskDepositMny()) {
                    record.setRiskDepositMnyWan(record.getRiskDepositMny().divide(new BigDecimal(10000)));
                    continue;
                }
                record.setRiskDepositMnyWan(BigDecimal.ZERO);
            }
        }
        pageData.setRecords(returnRecords);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryStandardByYear"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> queryStandardByYear(@RequestBody StandardVO standardVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("belong_year", new Parameter("eq", (Object)standardVO.getBelongYear()));
        queryParam.getParams().put("org_id", new Parameter("eq", (Object)standardVO.getOrgId()));
        List standardList = this.service.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)standardList)) {
            return CommonResponse.error((String)"\u5f53\u524d\u7ec4\u7ec7\u5728\u8be5\u6240\u5c5e\u5e74\u4efd\u4e0b\u5df2\u5b58\u5728\u6807\u51c6\u8868\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5e74\u4efd\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u5e74\u4efd\u53ef\u7528\uff01");
    }

    @RequestMapping(value={"/queryProjectDeleteFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> queryProjectDeleteFlag(@RequestBody Map<String, String> param) {
        String projectIds = param.get("projectIds");
        if (StringUtils.isNotBlank((CharSequence)projectIds)) {
            return this.service.queryProjectDeleteFlag(projectIds);
        }
        return CommonResponse.error((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u9879\u76eeid\u53c2\u6570\uff01");
    }
}

