package com.ejianc.business.payer.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 缴纳员工明细记录表子实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_riskmortgage_payer_record_detail")
public class PayerRecordDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="source_id")
    private Long sourceId; // 来源数据Id
    @TableField(value="name")
    private String name; // 姓名
    @TableField(value="job")
    private String job; // 角色
    @TableField(value="phone")
    private String phone; // 手机号
    @TableField(value="salary")
    private BigDecimal salary; // 工资金额（元）
    @TableField(value="payer_mny")
    private BigDecimal payerMny; // 缴纳金额（万元）
    @TableField(value="payer_scale")
    private BigDecimal payerScale; // 缴纳占比
    @TableField(value="detail_memo")
    private String detailMemo; // 备注
    @TableField(value="payer_id")
    private Long payerId; // 缴纳员工明细主键
    @TableField(value="record_id")
    private Long recordId; // 记录表ID-pid
    @TableField(value="src_table_id")
    private Long srcTableId; // 来源主合同子表id
    @TableField(value="actual_payer_mny")
    private BigDecimal actualPayerMny; // 实际缴纳金额（万元）
    @TableField(value="remainder_payer_mny")
    private BigDecimal remainderPayerMny; // 未缴纳金额（万元）
    @TableField(value="periodization_flag")
    private Integer periodizationFlag; // 是否已分期
    @TableField(value="periodization_num")
    private Integer periodizationNum; //分期数
    @TableField(value="periodization_mny")
    private BigDecimal periodizationMny; //分期金额（万元）
    @TableField(value="actual_payer_scale")
    private BigDecimal actualPayerScale; //实际已缴纳比例
    @TableField(value="each_periodization_mny")
    private BigDecimal eachPeriodizationMny; //每期缴纳金额
    @TableField(value="payer_code")
    private String payerCode; //缴纳员工明细编码
    @TableField(value="payer_name")
    private String payerName; //缴纳员工明细名称
    @TableField(value="payer_org_id")
    private Long payerOrgId; //缴纳员工明细组织Id
    @TableField(value="payer_org_name")
    private String payerOrgName; //缴纳员工明细组织名称
    @TableField(value="payer_org_code")
    private String payerOrgCode; //缴纳员工明细组织编码
    @TableField(value="payer_project_id")
    private Long payerProjectId; //缴纳员工明细项目Id
    @TableField(value="payer_project_name")
    private String payerProjectName; //缴纳员工明细项目名称
    @TableField(value="payer_project_code")
    private String payerProjectCode; //缴纳员工明细项目编码
    @TableField(value="payer_risk_deposit_type")
    private String payerRiskDepositType; // 风险保证金类型(directDept-直管部、projectDept-项目部)
    @TableField(value="payer_project_parent_org_id")
    private Long payerProjectParentOrgId; //缴纳员工明细项目父组织Id
    @TableField(value="payer_project_parent_org_name")
    private String payerProjectParentOrgName; //缴纳员工明细项目父组织名称
    @TableField(value="payer_project_parent_org_code")
    private String payerProjectParentOrgCode; //缴纳员工明细项目父组织编码
    @TableField(value="user_id")
    private Long userId; //员工id（同sourceId）
    @TableField(value="payer_employee_id")
    private Long payerEmployeeId; //缴纳员工明细经办人id
    @TableField(value="payer_employee_name")
    private String payerEmployeeName; //缴纳员工明细经办人名称
    @TableField(value="payer_belong_year")
    private Date payerBelongYear; // 缴纳员工明细所属年度
    @TableField(value="actual_payer_ratio")
    private BigDecimal actualPayerRatio; //实际缴纳占比（实际已缴纳金额 / 主表实际缴纳金额汇总）
    
    
    

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getPayerMny() {
        return payerMny;
    }

    public void setPayerMny(BigDecimal payerMny) {
        this.payerMny = payerMny;
    }
    public BigDecimal getPayerScale() {
        return payerScale;
    }

    public void setPayerScale(BigDecimal payerScale) {
        this.payerScale = payerScale;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    public Long getPayerId() {
        return payerId;
    }

    public void setPayerId(Long payerId) {
        this.payerId = payerId;
    }
    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
    public Long getSrcTableId() {
        return srcTableId;
    }

    public void setSrcTableId(Long srcTableId) {
        this.srcTableId = srcTableId;
    }

    public BigDecimal getActualPayerMny() {
        return actualPayerMny;
    }

    public void setActualPayerMny(BigDecimal actualPayerMny) {
        this.actualPayerMny = actualPayerMny;
    }

    public BigDecimal getRemainderPayerMny() {
        return remainderPayerMny;
    }

    public void setRemainderPayerMny(BigDecimal remainderPayerMny) {
        this.remainderPayerMny = remainderPayerMny;
    }

    public Integer getPeriodizationFlag() {
        return periodizationFlag;
    }

    public void setPeriodizationFlag(Integer periodizationFlag) {
        this.periodizationFlag = periodizationFlag;
    }

    public Integer getPeriodizationNum() {
        return periodizationNum;
    }

    public void setPeriodizationNum(Integer periodizationNum) {
        this.periodizationNum = periodizationNum;
    }

    public BigDecimal getPeriodizationMny() {
        return periodizationMny;
    }

    public void setPeriodizationMny(BigDecimal periodizationMny) {
        this.periodizationMny = periodizationMny;
    }

    public BigDecimal getActualPayerScale() {
        return actualPayerScale;
    }

    public void setActualPayerScale(BigDecimal actualPayerScale) {
        this.actualPayerScale = actualPayerScale;
    }

    public BigDecimal getEachPeriodizationMny() {
        return eachPeriodizationMny;
    }

    public void setEachPeriodizationMny(BigDecimal eachPeriodizationMny) {
        this.eachPeriodizationMny = eachPeriodizationMny;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public Long getPayerOrgId() {
        return payerOrgId;
    }

    public void setPayerOrgId(Long payerOrgId) {
        this.payerOrgId = payerOrgId;
    }

    public String getPayerOrgName() {
        return payerOrgName;
    }

    public void setPayerOrgName(String payerOrgName) {
        this.payerOrgName = payerOrgName;
    }

    public String getPayerOrgCode() {
        return payerOrgCode;
    }

    public void setPayerOrgCode(String payerOrgCode) {
        this.payerOrgCode = payerOrgCode;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getPayerEmployeeId() {
        return payerEmployeeId;
    }

    public void setPayerEmployeeId(Long payerEmployeeId) {
        this.payerEmployeeId = payerEmployeeId;
    }

    public String getPayerEmployeeName() {
        return payerEmployeeName;
    }

    public void setPayerEmployeeName(String payerEmployeeName) {
        this.payerEmployeeName = payerEmployeeName;
    }

    public Date getPayerBelongYear() {
        return payerBelongYear;
    }

    public void setPayerBelongYear(Date payerBelongYear) {
        this.payerBelongYear = payerBelongYear;
    }

    public Long getPayerProjectId() {
        return payerProjectId;
    }

    public void setPayerProjectId(Long payerProjectId) {
        this.payerProjectId = payerProjectId;
    }

    public String getPayerProjectName() {
        return payerProjectName;
    }

    public void setPayerProjectName(String payerProjectName) {
        this.payerProjectName = payerProjectName;
    }

    public String getPayerProjectCode() {
        return payerProjectCode;
    }

    public void setPayerProjectCode(String payerProjectCode) {
        this.payerProjectCode = payerProjectCode;
    }

    public String getPayerRiskDepositType() {
        return payerRiskDepositType;
    }

    public void setPayerRiskDepositType(String payerRiskDepositType) {
        this.payerRiskDepositType = payerRiskDepositType;
    }

    public Long getPayerProjectParentOrgId() {
        return payerProjectParentOrgId;
    }

    public void setPayerProjectParentOrgId(Long payerProjectParentOrgId) {
        this.payerProjectParentOrgId = payerProjectParentOrgId;
    }

    public String getPayerProjectParentOrgName() {
        return payerProjectParentOrgName;
    }

    public void setPayerProjectParentOrgName(String payerProjectParentOrgName) {
        this.payerProjectParentOrgName = payerProjectParentOrgName;
    }

    public String getPayerProjectParentOrgCode() {
        return payerProjectParentOrgCode;
    }

    public void setPayerProjectParentOrgCode(String payerProjectParentOrgCode) {
        this.payerProjectParentOrgCode = payerProjectParentOrgCode;
    }

    public BigDecimal getActualPayerRatio() {
        return actualPayerRatio;
    }

    public void setActualPayerRatio(BigDecimal actualPayerRatio) {
        this.actualPayerRatio = actualPayerRatio;
    }
}
