package com.ejianc.business.payer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.payer.bean.*;
import com.ejianc.business.payer.service.IPayerRecordService;
import com.ejianc.business.payer.service.IPayerService;
import com.ejianc.business.payer.vo.PayerChangeDetailVO;
import com.ejianc.business.payer.vo.PayerChangeVO;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.payer.mapper.PayerChangeMapper;
import com.ejianc.business.payer.service.IPayerChangeService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 缴纳员工明细变更表主实体
 * 
 * @author generator
 * 
 */
@Service("payerChangeService")
public class PayerChangeServiceImpl extends BaseServiceImpl<PayerChangeMapper, PayerChangeEntity> implements IPayerChangeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayerService payerService;
    @Autowired
    private IPayerRecordService recordService;

    @Autowired
    private IAttachmentApi attachmentApi;

    private final String STANDARD_FILE_SOURCE_TYPE = "payerFile"; // 记录单据业务
    private final String STANDARD_ATTACH_SOURCE_TYPE = "payerBill"; //原单据业务类型

    //直管部缴纳员工明细表单据编码
    private final String DIRECT_Bill_CODE = "EJCBT202206000043";
    //直管部缴纳员工明细表记录单据编码
    private final String DIRECT_RECORD_Bill_CODE = "EJCBT202206000045";

    //项目部缴纳员工明细表单据编码
    private final String PROSUB_Bill_CODE = "EJCBT202206000046";
    //项目部缴纳员工明细表记录单据编码
    private final String PROSUB_RECORD_Bill_CODE = "EJCBT202206000048";

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> effectiveSaveWriteStandard(Long changeBillId, String billTypeCode) {
        CommonResponse<String> resp = null;
        PayerChangeEntity changeEntity = super.selectById(changeBillId);
        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));

        /**复制缴纳员工明细表数据到记录表 begin */
        PayerEntity payerEntity = payerService.selectById(changeEntity.getMainPayerId());
        payerEntity.setChangeEffectDate(new Date());

        PayerRecordEntity recordEntity = BeanMapper.map(payerEntity, PayerRecordEntity.class);

        //设置变更后金额（暂时用变更中金额代替）
        recordEntity.setChangingPayerMny(changeEntity.getTotalPayerMny());
        recordEntity.setId(null);
        recordEntity.setMainPayerId(payerEntity.getId());
        recordEntity.setBillCode(changeEntity.getBillCode());
        logger.info("变更前主缴纳员工明细表数据: {}", JSONObject.toJSONString(payerEntity));
        logger.info("变更前主缴纳员工明细表子表detail数据: {}", JSONObject.toJSONString(payerEntity.getDetailList()));
        logger.info("记录表从主缴纳员工明细表复制的数据: {}", JSONObject.toJSONString(recordEntity));
        logger.info("记录表从主缴纳员工明细表复制的数据的子表detail数据: {}", JSONObject.toJSONString(recordEntity.getDetailList()));
        logger.info("记录表从主缴纳员工明细表复制的数据的变更前金额: {}", JSONObject.toJSONString(recordEntity.getBeforeChangePayerMny()));

        if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
            recordEntity.getDetailList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }

        logger.info("记录表从主缴纳员工明细表表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(recordEntity.getDetailList()));
        recordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主缴纳员工明细表数据成功！");

        //根据实体RefCode查询实体单据类型
        String srcBillCode = PROSUB_Bill_CODE;
        String targetBillCode = PROSUB_RECORD_Bill_CODE;
        if (("directDept").equals(payerEntity.getRiskDepositType())){//直管部
            srcBillCode = DIRECT_Bill_CODE;
            targetBillCode = DIRECT_RECORD_Bill_CODE;
        }

        //原缴纳员工明细表附件、起草附件同步到记录单据中
        resp = copyFile(payerEntity.getId().toString(), srcBillCode,
                recordEntity.getId().toString(), targetBillCode, STANDARD_ATTACH_SOURCE_TYPE, STANDARD_FILE_SOURCE_TYPE);
        if(resp != null) {
            logger.error("同步原缴纳员工明细表附件到记录单据失败，失败原因：{}", JSONObject.toJSONString(resp));
        }
        /**复制缴纳员工明细表数据到记录表 end */


        /**更新变更表主表数据到原缴纳员工明细表 begin */
        logger.info("更新变更数据到主缴纳员工明细表,standardEntity---------------->: {}", JSONObject.toJSONString(payerEntity));
        //基本信息

        payerEntity.setBeforeChangePayerMny(changeEntity.getBeforeChangePayerMny());
        payerEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        payerEntity.setTotalPayerMny(changeEntity.getTotalPayerMny());

        logger.info("1212-进入变更终审审核完回调：billTypeCode------>", billTypeCode);
        //同步变更单附件（不包含变更变更附件）到原缴纳员工明细表

        resp = copyFile(changeBillId.toString(), billTypeCode, payerEntity.getId().toString(), srcBillCode, "payerChangeFile", STANDARD_ATTACH_SOURCE_TYPE);
        if(resp != null) {
            logger.error("同步变更附件到原缴纳员工明细表失败，失败原因：{}", JSONObject.toJSONString(resp));
        }

        //变更单更新
        changeEntity.setEffectDate(new Date());
        super.saveOrUpdate(changeEntity);
        logger.info("更新变更表生效时间,changeEntity---------->： {}", JSONObject.toJSONString(changeEntity));

        /**更新变更表数据到原缴纳员工明细表 end */

        /**更新变更子表数据到原缴纳员工明细表 begin */
        logger.info("更新变更表数据到原缴纳员工明细表开始----------->" + payerEntity.getChangeStatus());


        List<PayerChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
		/*
			变更详情表和缴纳员工明细表详情表有一个字段不一样
			变更详情表里 来源子表主键 srcTblId
		 */
        Map<Long, PayerChangeDetailEntity> changeSrcIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailEntity -> {
                //设置id和来源子表主键对应map
                changeSrcIdMap.put(changeDetailEntity.getSrcTblId() == null ? IdWorker.getId() : changeDetailEntity.getSrcTblId(), changeDetailEntity);
            });
        }

        //将变更的子表赋值给原单据
        List<PayerDetailEntity> payerDetailList = payerEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(payerDetailList)){
            for(PayerDetailEntity payerDetail : payerDetailList) {
                if (changeSrcIdMap.containsKey(payerDetail.getId())){
                    //如果变更包含原单据子表
                    payerDetail.setDetailMemo(changeSrcIdMap.get(payerDetail.getId()).getDetailMemo());
                    payerDetail.setPhone(changeSrcIdMap.get(payerDetail.getId()).getPhone());
                    payerDetail.setPayerMny(changeSrcIdMap.get(payerDetail.getId()).getPayerMny());
                    payerDetail.setSalary(changeSrcIdMap.get(payerDetail.getId()).getSalary());
                    payerDetail.setJob(changeSrcIdMap.get(payerDetail.getId()).getJob());
                    payerDetail.setPayerScale(changeSrcIdMap.get(payerDetail.getId()).getPayerScale());
                    payerDetail.setRemainderPayerMny(changeSrcIdMap.get(payerDetail.getId()).getRemainderPayerMny());
                    changeSrcIdMap.remove(payerDetail.getId());
                }else {
                    //如果变更不包含原单据子表
                    payerDetail.setRowState("del");
                }
            }
            //如果还有剩余的变更子表 即是变更单新增的数据
            if (null != changeSrcIdMap){
                for (Long key : changeSrcIdMap.keySet()) {
                    PayerChangeDetailEntity changeDetailEntity = changeSrcIdMap.get(key);
                    changeDetailEntity.setId(null);
                    changeDetailEntity.setRowState("add");
                    payerDetailList.add(BeanMapper.map(changeDetailEntity, PayerDetailEntity.class));
                }
            }
        }
        payerEntity.setDetailList(payerDetailList);

        payerService.saveOrUpdate(payerEntity, false);
        logger.info("更新缴纳员工明细表数据成功,standardEntity---------->: {}", JSONObject.toJSONString(payerEntity));

        /**更新变更子表数据到原缴纳员工明细表子表 end */
        return CommonResponse.success("变更单生效，回写主缴纳员工明细表成功！");
    }

    @Override
    public PayerChangeVO addConvertById(Long payerId) {
        PayerEntity payerEntity = payerService.selectById(payerId);
        PayerChangeVO changeVO = BeanMapper.map(payerEntity, PayerChangeVO.class);
        changeVO.setBillState(null);

        changeVO.setMainPayerId(payerId);
        changeVO.setMainPayerCode(payerEntity.getBillCode());
        changeVO.setChangeVersion(payerEntity.getChangeVersion() == null ? 1 : payerEntity.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setEffectDate(null);
        changeVO.setBeforeChangePayerMny(payerEntity.getTotalPayerMny());

        changeVO.setChangingPayerMny(BigDecimal.ZERO);
        changeVO.setChangeScale(BigDecimal.ZERO);

        //设置明细表字段
        for (PayerChangeDetailVO changeDetailVO : changeVO.getDetailList()) {
            changeDetailVO.setSrcTblId(changeDetailVO.getId());
            changeDetailVO.setId(IdWorker.getId());
        }

        changeVO = transformWan(changeVO);
        return changeVO;
    }

    @Override
    public PayerChangeVO insertOrUpdate(PayerChangeVO saveOrUpdateVO) {
        PayerChangeEntity entity = BeanMapper.map(saveOrUpdateVO, PayerChangeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            PayerEntity standardEntity = payerService.selectById(entity.getMainPayerId());
            //历史记录 单据编码 第一个是 123456 第二个是123456101
            if(entity.getChangeVersion() < 11){
                if (entity.getChangeVersion() == 1){
                    entity.setBillCode(standardEntity.getBillCode());
                }else {
                    entity.setBillCode(entity.getBillCode() + "10" + (entity.getChangeVersion() - 1));
                }
            }else{
                entity.setBillCode(entity.getBillCode() + "1" + (entity.getChangeVersion() - 1));
            }

        }
        //给新加缴纳人员赋值
        List<PayerChangeDetailEntity> payerChangeDetailList = entity.getDetailList();
        for (PayerChangeDetailEntity detail : payerChangeDetailList) {
            if (null == detail.getPayerOrgId()){
                detail.setPayerId(entity.getId());
                detail.setPayerCode(entity.getBillCode());
                detail.setPayerName(entity.getBillCode());
                detail.setPayerOrgId(entity.getOrgId());
                detail.setPayerOrgCode(entity.getOrgCode());
                detail.setPayerOrgName(entity.getOrgName());
                if ("projectDept".equals(saveOrUpdateVO.getRiskDepositType())){
                    detail.setPayerProjectId(entity.getProjectId());
                    detail.setPayerProjectCode(entity.getProjectCode());
                    detail.setPayerProjectName(entity.getProjectName());
                    //项目部缴纳明细存项目信息
                    detail.setPayerProjectParentOrgId(entity.getProjectParentOrgId());
                    detail.setPayerProjectParentOrgCode(entity.getProjectParentOrgCode());
                    detail.setPayerProjectParentOrgName(entity.getProjectParentOrgName());
                }
                detail.setPayerRiskDepositType(entity.getRiskDepositType());
                detail.setPayerBelongYear(entity.getBelongYear());
                detail.setPeriodizationFlag(0);
                detail.setActualPayerScale(BigDecimal.ZERO);
            }
            detail.setPayerEmployeeId(entity.getEmployeeId());
            detail.setPayerEmployeeName(entity.getEmployeeName());
        }

        super.saveOrUpdate(entity, false);
        writeBackPayer(entity);
        PayerChangeVO returnVO = BeanMapper.map(super.selectById(entity.getId()), PayerChangeVO.class);
        returnVO = transformWan(returnVO);
        return returnVO;
    }

    @Override
    public void removePayerChange(Long id) {
        PayerChangeEntity changeEntity = super.selectById(id);
        //回写主标准表 把相关变更内容都删除
        PayerEntity payerEntity = payerService.selectById(changeEntity.getMainPayerId());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainPayerId", new Parameter(QueryParam.EQ, changeEntity.getMainPayerId()));
        List<PayerChangeEntity> changeEntityList = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(changeEntityList) && changeEntityList.size() > 1){
            payerEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        }else {
            payerEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        }
        payerEntity.setChangeId(null);
        payerEntity.setChangeCode(null);
        payerEntity.setChangeVersion(payerEntity.getChangeStatus() - 1);
        payerEntity.setChangeDate(null);
        payerEntity.setChangeEmployeeId(null);
        payerEntity.setChangeEmployeeName(null);
        payerService.saveOrUpdate(payerEntity, false);
        super.removeById(id, false);
    }

    @Override
    public PayerChangeVO transformWan(PayerChangeVO vo) {
        if (null != vo.getTotalPayerMny()){
            vo.setTotalPayerMnyWan(vo.getTotalPayerMny().divide(new BigDecimal(10000)));
        }else {
            vo.setTotalPayerMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getRiskDepositMny()){
            vo.setRiskDepositMnyWan(vo.getRiskDepositMny().divide(new BigDecimal(10000)));
        }else {
            vo.setRiskDepositMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getTotalActualPayerMny()){
            vo.setTotalActualPayerMnyWan(vo.getTotalActualPayerMny().divide(new BigDecimal(10000)));
        }else {
            vo.setTotalActualPayerMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getChangePayerMny()){
            vo.setChangePayerMnyWan(vo.getChangePayerMny().divide(new BigDecimal(10000)));
        }else {
            vo.setChangePayerMnyWan(BigDecimal.ZERO);
        }
        List<PayerChangeDetailVO> detailVOList = vo.getDetailList();
        for (PayerChangeDetailVO detail : detailVOList) {
            if (null != detail.getPayerMny()){
                detail.setPayerMnyWan(detail.getPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getActualPayerMny()){
                detail.setActualPayerMnyWan(detail.getActualPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setActualPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getRemainderPayerMny()){
                detail.setRemainderPayerMnyWan(detail.getRemainderPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setRemainderPayerMnyWan(BigDecimal.ZERO);
            }
        }
        return vo;
    }

    /**
     * 回写主缴纳人员明细表
     * @param changeEntity
     */
    private void writeBackPayer(PayerChangeEntity changeEntity) {

        PayerEntity payerEntity = payerService.selectById(changeEntity.getMainPayerId());
        if (!(null != payerEntity.getChangeId() && payerEntity.getChangeId().equals(changeEntity.getId()))){
            payerEntity.setChangeId(changeEntity.getId());
            payerEntity.setChangeCode(changeEntity.getBillCode());
            payerEntity.setChangeVersion(changeEntity.getChangeVersion());
            payerEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
            payerEntity.setChangeDate(new Date());
        }
        payerEntity.setChangeEmployeeId(changeEntity.getChangeEmployeeId());
        payerEntity.setChangeEmployeeName(changeEntity.getChangeEmployeeName());
        payerService.saveOrUpdate(payerEntity, false);
    }

    //查询变更明细
    private PayerChangeVO queryDetail(Long changeId) {
        return BeanMapper.map(super.selectById(changeId), PayerChangeVO.class);
    }


    /**
     * 文件复制
     *
     * @param srcBillId 源单据Id
     * @param srcBillTypeCode 源单据类型
     * @param targetBillId 目标单据Id
     * @param targetBillTypeCode 目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @param targetBillType 目标单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, String targetBillType) {

        //同步原标准表附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, targetBillType);
        if (!copyContractAttachResp.isSuccess()){
            logger.info("同步标准表文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    ,srcBillId, srcBillTypeCode, targetBillType, targetBillId, targetBillTypeCode, targetBillType, copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }

        return null;
    }
}
