package com.ejianc.business.share.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.share.bean.ShareDeptEntity;
import com.ejianc.business.share.bean.ShareOrgEntity;
/**
 * 激励/补亏分配
 * 
 * @author generator
 * 
 */
 @TableName("ejc_riskmortgage_share")
public class ShareEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_org_id")
    private Long projectOrgId; // 项目所属组织id
    @TableField(value="project_org_code")
    private String projectOrgCode; // 项目所属组织编码
    @TableField(value="project_org_name")
    private String projectOrgName; // 项目所属组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_code")
    private String departmentCode; // 经办人部门编码
    @TableField(value="department_name")
    private String departmentName; // 经办人部门名称
    @TableField(value="approvee_id")
    private Long approveeId; // 兑现审批主键id
    @TableField(value="approvee_code")
    private String approveeCode; // 兑现审批编码
    @TableField(value="standard_id")
    private Long standardId; // 标准表主键id
    @TableField(value="standard_code")
    private String standardCode; // 标准表编码
    @TableField(value="node_stage")
    private String nodeStage; // 绩效激励/补亏节点
    @TableField(value="year")
    private String year; // 所属年度
    @TableField(value="examine_cash_mny")
    private BigDecimal examineCashMny; // 考核兑现金额
    @TableField(value="share_mny")
    private BigDecimal shareMny; // 本期分配总金额
    @TableField(value="last_share_mny")
    private BigDecimal lastShareMny; // 本期分配总金额--不含本期
    @TableField(value="share_sum_mny")
    private BigDecimal shareSumMny; // 含本期累计分配总金额
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="shareDeptService", pidName = "shareId")
    private List<ShareDeptEntity> shareDeptList = new ArrayList<>(); // 分配—项目分配明细
    @TableField(exist=false)
    @SubEntity(serviceName="shareOrgService", pidName = "shareId")
    private List<ShareOrgEntity> shareOrgList = new ArrayList<>(); // 分配-直管部分配明细

    public BigDecimal getLastShareMny() {
        return lastShareMny;
    }

    public void setLastShareMny(BigDecimal lastShareMny) {
        this.lastShareMny = lastShareMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getProjectOrgCode() {
        return projectOrgCode;
    }

    public void setProjectOrgCode(String projectOrgCode) {
        this.projectOrgCode = projectOrgCode;
    }
    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getApproveeId() {
        return approveeId;
    }

    public void setApproveeId(Long approveeId) {
        this.approveeId = approveeId;
    }
    public String getApproveeCode() {
        return approveeCode;
    }

    public void setApproveeCode(String approveeCode) {
        this.approveeCode = approveeCode;
    }
    public Long getStandardId() {
        return standardId;
    }

    public void setStandardId(Long standardId) {
        this.standardId = standardId;
    }
    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }
    public String getNodeStage() {
        return nodeStage;
    }

    public void setNodeStage(String nodeStage) {
        this.nodeStage = nodeStage;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public BigDecimal getExamineCashMny() {
        return examineCashMny;
    }

    public void setExamineCashMny(BigDecimal examineCashMny) {
        this.examineCashMny = examineCashMny;
    }
    public BigDecimal getShareMny() {
        return shareMny;
    }

    public void setShareMny(BigDecimal shareMny) {
        this.shareMny = shareMny;
    }
    public BigDecimal getShareSumMny() {
        return shareSumMny;
    }

    public void setShareSumMny(BigDecimal shareSumMny) {
        this.shareSumMny = shareSumMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<ShareDeptEntity> getShareDeptList() {
        return shareDeptList;
    }

    public void setShareDeptList(List<ShareDeptEntity> shareDeptList) {
        this.shareDeptList = shareDeptList;
    }

    public List<ShareOrgEntity> getShareOrgList() {
        return shareOrgList;
    }

    public void setShareOrgList(List<ShareOrgEntity> shareOrgList) {
        this.shareOrgList = shareOrgList;
    }
}
