/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pay.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.enums.ConfirmStatusEnum;
import com.ejianc.business.pay.mapper.PayMapper;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.business.pay.vo.PayVO;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.service.IPayerDetailService;
import com.ejianc.business.payer.service.IPayerService;
import com.ejianc.business.repay.service.IRepayService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payService")
public class PayServiceImpl
extends BaseServiceImpl<PayMapper, PayEntity>
implements IPayService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPayerDetailService payerDetailService;
    @Autowired
    private IPayerService payerService;
    @Autowired
    private IRepayService repayService;

    @Override
    public Date fetchMaxPayDate(Long sourceBillId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.select(new String[]{"max(pay_date) as payDate"}).eq((Object)"source_bill_id", (Object)sourceBillId)).eq((Object)"confirm_status", (Object)ConfirmStatusEnum.CONFIRM.getCode());
        if (super.getMap((Wrapper)queryWrapper) == null) {
            return null;
        }
        return (Date)super.getMap((Wrapper)queryWrapper).get("payDate");
    }

    @Override
    public boolean isLatestBill(Long billId, Long sourceBillId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"source_bill_id", (Object)sourceBillId)).orderByDesc((Object)"pay_date");
        List list = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return ((PayEntity)((Object)list.get(0))).getId().equals(billId);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchConfirm(List<PayVO> pays) {
        List payEntities = BeanMapper.mapList(pays, PayEntity.class);
        UserContext userContext = this.sessionManager.getUserContext();
        Map payMap = payEntities.stream().collect(Collectors.toMap(PayEntity::getSourceBillId, Function.identity()));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Map.Entry entry : payMap.entrySet()) {
            PayEntity pay = (PayEntity)((Object)entry.getValue());
            pay.setConfirmStatus(ConfirmStatusEnum.CONFIRM.getCode());
            pay.setConfirmStatusName(ConfirmStatusEnum.CONFIRM.getName());
            pay.setConfirmDate(new Date());
            pay.setConfirmUserId(userContext.getUserId());
            pay.setConfirmUserCode(userContext.getUserCode());
            pay.setConfirmUserName(userContext.getUserName());
            ids.add(pay.getSourceBillId());
        }
        Collection payerDetails = this.payerDetailService.listByIds(ids);
        for (PayerDetailEntity pd : payerDetails) {
            PayEntity pay = (PayEntity)((Object)payMap.get(pd.getId()));
            pd.setPeriodizationFlag(Integer.parseInt(pay.getInstallmentFlag()));
            if (Integer.parseInt(pay.getInstallmentFlag()) == 1) {
                pd.setPeriodizationMny(pay.getInstallmentTaxMny().setScale(2, RoundingMode.HALF_UP));
                pd.setPeriodizationNum(pay.getInstallmentNum());
                pd.setEachPeriodizationMny(pay.getInstallmentTaxMny().divide(new BigDecimal(pay.getInstallmentNum()), 2, RoundingMode.HALF_UP));
            }
            BigDecimal actually = pay.getPayTaxMny().add(pd.getActualPayerMny());
            pd.setActualPayerMny(actually.setScale(2, RoundingMode.HALF_UP));
            pd.setActualPayerScale(actually.divide(pd.getPayerMny(), 2, RoundingMode.HALF_UP));
            pd.setRemainderPayerMny(pd.getPayerMny().subtract(actually).setScale(2, RoundingMode.HALF_UP));
        }
        this.payerDetailService.saveOrUpdateBatch(payerDetails, 10);
        List<Long> list = payerDetails.stream().map(PayerDetailEntity::getPayerId).distinct().collect(Collectors.toList());
        this.payerService.updateActualPayerMny(list);
        super.saveOrUpdateBatch((Collection)payEntities, 10);
    }

    @Override
    public CommonResponse<String> back(PayVO payVO) {
        PayEntity entity = (PayEntity)((Object)this.selectById(payVO.getId()));
        QueryWrapper payWrapper = new QueryWrapper();
        ((QueryWrapper)payWrapper.select(new String[]{"ifnull(count(*),0) as count"}).eq((Object)"source_bill_id", (Object)entity.getSourceBillId())).ne((Object)"confirm_status", (Object)ConfirmStatusEnum.CONFIRM.getCode());
        Long pay = (Long)this.getMap((Wrapper)payWrapper).get("count");
        if (pay != 0L) {
            return CommonResponse.error((String)"\u8be5\u5458\u5de5\u6709\u5f85\u786e\u8ba4/\u786e\u8ba4\u4e2d\u7684\u5355\u636e\uff0c\u4e0d\u652f\u6301\u64a4\u56de");
        }
        QueryWrapper repayWrapper = new QueryWrapper();
        ((QueryWrapper)repayWrapper.select(new String[]{"ifnull(count(*),0) as count"}).eq((Object)"source_bill_id", (Object)entity.getSourceBillId())).ne((Object)"confirm_status", (Object)ConfirmStatusEnum.CONFIRM.getCode());
        Long repay = (Long)this.repayService.getMap((Wrapper)repayWrapper).get("count");
        if (repay != 0L) {
            return CommonResponse.error((String)"\u8be5\u5458\u5de5\u6709\u5f85\u786e\u8ba4/\u786e\u8ba4\u4e2d\u5355\u636e\uff0c\u4e0d\u652f\u6301\u64a4\u56de");
        }
        entity.setConfirmStatus(ConfirmStatusEnum.CONFIRMING.getCode());
        entity.setConfirmStatusName(ConfirmStatusEnum.CONFIRMING.getName());
        entity.setConfirmDate(null);
        entity.setConfirmUserId(null);
        entity.setConfirmUserCode(null);
        entity.setConfirmUserName(null);
        PayerDetailEntity pd = (PayerDetailEntity)((Object)this.payerDetailService.selectById(entity.getSourceBillId()));
        pd.setPeriodizationFlag(Integer.parseInt(entity.getInstallmentFlag()));
        if (Integer.parseInt(entity.getInstallmentFlag()) == 1) {
            pd.setPeriodizationMny(null);
            pd.setPeriodizationNum(null);
            pd.setEachPeriodizationMny(null);
        }
        pd.setActualPayerMny(ComputeUtil.safeSub((BigDecimal)pd.getActualPayerMny(), (BigDecimal)entity.getPayTaxMny()));
        pd.setActualPayerScale(ComputeUtil.safeDiv((BigDecimal)pd.getActualPayerMny(), (BigDecimal)pd.getPayerMny()));
        pd.setRemainderPayerMny(ComputeUtil.safeSub((BigDecimal)pd.getPayerMny(), (BigDecimal)pd.getActualPayerMny()));
        this.payerDetailService.saveOrUpdate((Object)pd);
        ArrayList<Long> payerIdList = new ArrayList<Long>();
        payerIdList.add(pd.getPayerId());
        this.payerService.updateActualPayerMny(payerIdList);
        this.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u64a4\u56de\u6210\u529f");
    }
}

