/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.payer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.payer.bean.PayerChangeDetailEntity;
import com.ejianc.business.payer.bean.PayerChangeEntity;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.bean.PayerRecordEntity;
import com.ejianc.business.payer.mapper.PayerChangeMapper;
import com.ejianc.business.payer.service.IPayerChangeService;
import com.ejianc.business.payer.service.IPayerRecordService;
import com.ejianc.business.payer.service.IPayerService;
import com.ejianc.business.payer.vo.PayerChangeDetailVO;
import com.ejianc.business.payer.vo.PayerChangeVO;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payerChangeService")
public class PayerChangeServiceImpl
extends BaseServiceImpl<PayerChangeMapper, PayerChangeEntity>
implements IPayerChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayerService payerService;
    @Autowired
    private IPayerRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private final String STANDARD_FILE_SOURCE_TYPE = "payerFile";
    private final String STANDARD_ATTACH_SOURCE_TYPE = "payerBill";
    private final String DIRECT_Bill_CODE = "EJCBT202206000043";
    private final String DIRECT_RECORD_Bill_CODE = "EJCBT202206000045";
    private final String PROSUB_Bill_CODE = "EJCBT202206000046";
    private final String PROSUB_RECORD_Bill_CODE = "EJCBT202206000048";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> effectiveSaveWriteStandard(Long changeBillId, String billTypeCode) {
        List<PayerDetailEntity> payerDetailList;
        CommonResponse resp = null;
        PayerChangeEntity changeEntity = (PayerChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\uff01\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        PayerEntity payerEntity = (PayerEntity)((Object)this.payerService.selectById(changeEntity.getMainPayerId()));
        payerEntity.setChangeEffectDate(new Date());
        PayerRecordEntity recordEntity = (PayerRecordEntity)((Object)BeanMapper.map((Object)((Object)payerEntity), PayerRecordEntity.class));
        recordEntity.setChangingPayerMny(changeEntity.getTotalPayerMny());
        recordEntity.setId(null);
        recordEntity.setMainPayerId(payerEntity.getId());
        recordEntity.setBillCode(changeEntity.getBillCode());
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)payerEntity)));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(payerEntity.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)recordEntity)));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u53d8\u66f4\u524d\u91d1\u989d: {}", (Object)JSONObject.toJSONString((Object)recordEntity.getBeforeChangePayerMny()));
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u6570\u636e\u6210\u529f\uff01");
        String srcBillCode = "EJCBT202206000046";
        String targetBillCode = "EJCBT202206000048";
        if ("directDept".equals(payerEntity.getRiskDepositType())) {
            srcBillCode = "EJCBT202206000043";
            targetBillCode = "EJCBT202206000045";
        }
        if ((resp = this.copyFile(payerEntity.getId().toString(), srcBillCode, recordEntity.getId().toString(), targetBillCode, "payerBill", "payerFile")) != null) {
            this.logger.error("\u540c\u6b65\u539f\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u9644\u4ef6\u5230\u8bb0\u5f55\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868,standardEntity---------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)payerEntity)));
        payerEntity.setBeforeChangePayerMny(changeEntity.getBeforeChangePayerMny());
        payerEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        payerEntity.setTotalPayerMny(changeEntity.getTotalPayerMny());
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\uff1abillTypeCode------>", (Object)billTypeCode);
        resp = this.copyFile(changeBillId.toString(), billTypeCode, payerEntity.getId().toString(), srcBillCode, "payerChangeFile", "payerBill");
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u53d8\u66f4\u9644\u4ef6\u5230\u539f\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        changeEntity.setEffectDate(new Date());
        super.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u751f\u6548\u65f6\u95f4,changeEntity---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u5230\u539f\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u5f00\u59cb----------->" + payerEntity.getChangeStatus());
        List<PayerChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
        HashMap changeSrcIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailEntity -> changeSrcIdMap.put(changeDetailEntity.getSrcTblId() == null ? IdWorker.getId() : changeDetailEntity.getSrcTblId(), changeDetailEntity));
        }
        if (CollectionUtils.isNotEmpty(payerDetailList = payerEntity.getDetailList())) {
            for (PayerDetailEntity payerDetail : payerDetailList) {
                if (changeSrcIdMap.containsKey(payerDetail.getId())) {
                    payerDetail.setDetailMemo(((PayerChangeDetailEntity)((Object)changeSrcIdMap.get(payerDetail.getId()))).getDetailMemo());
                    payerDetail.setPhone(((PayerChangeDetailEntity)((Object)changeSrcIdMap.get(payerDetail.getId()))).getPhone());
                    payerDetail.setPayerMny(((PayerChangeDetailEntity)((Object)changeSrcIdMap.get(payerDetail.getId()))).getPayerMny());
                    payerDetail.setSalary(((PayerChangeDetailEntity)((Object)changeSrcIdMap.get(payerDetail.getId()))).getSalary());
                    payerDetail.setJob(((PayerChangeDetailEntity)((Object)changeSrcIdMap.get(payerDetail.getId()))).getJob());
                    payerDetail.setPayerScale(((PayerChangeDetailEntity)((Object)changeSrcIdMap.get(payerDetail.getId()))).getPayerScale());
                    payerDetail.setRemainderPayerMny(((PayerChangeDetailEntity)((Object)changeSrcIdMap.get(payerDetail.getId()))).getRemainderPayerMny());
                    changeSrcIdMap.remove(payerDetail.getId());
                    continue;
                }
                payerDetail.setRowState("del");
            }
            if (null != changeSrcIdMap) {
                for (Long key : changeSrcIdMap.keySet()) {
                    PayerChangeDetailEntity changeDetailEntity2 = (PayerChangeDetailEntity)((Object)changeSrcIdMap.get(key));
                    changeDetailEntity2.setId(null);
                    changeDetailEntity2.setRowState("add");
                    payerDetailList.add((PayerDetailEntity)((Object)BeanMapper.map((Object)((Object)changeDetailEntity2), PayerDetailEntity.class)));
                }
            }
        }
        payerEntity.setDetailList(payerDetailList);
        this.payerService.saveOrUpdate((Object)payerEntity, false);
        this.logger.info("\u66f4\u65b0\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u6570\u636e\u6210\u529f,standardEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)payerEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u4e3b\u7f34\u7eb3\u5458\u5de5\u660e\u7ec6\u8868\u6210\u529f\uff01");
    }

    @Override
    public PayerChangeVO addConvertById(Long payerId) {
        PayerEntity payerEntity = (PayerEntity)((Object)this.payerService.selectById(payerId));
        PayerChangeVO changeVO = (PayerChangeVO)BeanMapper.map((Object)((Object)payerEntity), PayerChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setMainPayerId(payerId);
        changeVO.setMainPayerCode(payerEntity.getBillCode());
        changeVO.setChangeVersion(Integer.valueOf(payerEntity.getChangeVersion() == null ? 1 : payerEntity.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setEffectDate(null);
        changeVO.setBeforeChangePayerMny(payerEntity.getTotalPayerMny());
        changeVO.setChangingPayerMny(BigDecimal.ZERO);
        changeVO.setChangeScale(BigDecimal.ZERO);
        for (PayerChangeDetailVO changeDetailVO : changeVO.getDetailList()) {
            changeDetailVO.setSrcTblId(changeDetailVO.getId());
            changeDetailVO.setId(Long.valueOf(IdWorker.getId()));
        }
        changeVO = this.transformWan(changeVO);
        return changeVO;
    }

    @Override
    public PayerChangeVO insertOrUpdate(PayerChangeVO saveOrUpdateVO) {
        PayerChangeEntity entity = (PayerChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayerChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            PayerEntity standardEntity = (PayerEntity)((Object)this.payerService.selectById(entity.getMainPayerId()));
            if (entity.getChangeVersion() < 11) {
                if (entity.getChangeVersion() == 1) {
                    entity.setBillCode(standardEntity.getBillCode());
                } else {
                    entity.setBillCode(entity.getBillCode() + "10" + (entity.getChangeVersion() - 1));
                }
            } else {
                entity.setBillCode(entity.getBillCode() + "1" + (entity.getChangeVersion() - 1));
            }
        }
        List<PayerChangeDetailEntity> payerChangeDetailList = entity.getDetailList();
        for (PayerChangeDetailEntity detail : payerChangeDetailList) {
            if (null == detail.getPayerOrgId()) {
                detail.setPayerId(entity.getId());
                detail.setPayerCode(entity.getBillCode());
                detail.setPayerName(entity.getBillCode());
                detail.setPayerOrgId(entity.getOrgId());
                detail.setPayerOrgCode(entity.getOrgCode());
                detail.setPayerOrgName(entity.getOrgName());
                if ("projectDept".equals(saveOrUpdateVO.getRiskDepositType())) {
                    detail.setPayerProjectId(entity.getProjectId());
                    detail.setPayerProjectCode(entity.getProjectCode());
                    detail.setPayerProjectName(entity.getProjectName());
                    detail.setPayerProjectParentOrgId(entity.getProjectParentOrgId());
                    detail.setPayerProjectParentOrgCode(entity.getProjectParentOrgCode());
                    detail.setPayerProjectParentOrgName(entity.getProjectParentOrgName());
                }
                detail.setPayerRiskDepositType(entity.getRiskDepositType());
                detail.setPayerBelongYear(entity.getBelongYear());
                detail.setPeriodizationFlag(0);
                detail.setActualPayerScale(BigDecimal.ZERO);
            }
            detail.setPayerEmployeeId(entity.getEmployeeId());
            detail.setPayerEmployeeName(entity.getEmployeeName());
        }
        super.saveOrUpdate((Object)entity, false);
        this.writeBackPayer(entity);
        PayerChangeVO returnVO = (PayerChangeVO)BeanMapper.map((Object)super.selectById((Serializable)entity.getId()), PayerChangeVO.class);
        returnVO = this.transformWan(returnVO);
        return returnVO;
    }

    @Override
    public void removePayerChange(Long id) {
        PayerChangeEntity changeEntity = (PayerChangeEntity)((Object)super.selectById((Serializable)id));
        PayerEntity payerEntity = (PayerEntity)((Object)this.payerService.selectById(changeEntity.getMainPayerId()));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainPayerId", new Parameter("eq", (Object)changeEntity.getMainPayerId()));
        List changeEntityList = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)changeEntityList) && changeEntityList.size() > 1) {
            payerEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        } else {
            payerEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        payerEntity.setChangeId(null);
        payerEntity.setChangeCode(null);
        payerEntity.setChangeVersion(payerEntity.getChangeStatus() - 1);
        payerEntity.setChangeDate(null);
        payerEntity.setChangeEmployeeId(null);
        payerEntity.setChangeEmployeeName(null);
        this.payerService.saveOrUpdate((Object)payerEntity, false);
        super.removeById((Serializable)id, false);
    }

    @Override
    public PayerChangeVO transformWan(PayerChangeVO vo) {
        if (null != vo.getTotalPayerMny()) {
            vo.setTotalPayerMnyWan(vo.getTotalPayerMny().divide(new BigDecimal(10000)));
        } else {
            vo.setTotalPayerMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getRiskDepositMny()) {
            vo.setRiskDepositMnyWan(vo.getRiskDepositMny().divide(new BigDecimal(10000)));
        } else {
            vo.setRiskDepositMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getTotalActualPayerMny()) {
            vo.setTotalActualPayerMnyWan(vo.getTotalActualPayerMny().divide(new BigDecimal(10000)));
        } else {
            vo.setTotalActualPayerMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getChangePayerMny()) {
            vo.setChangePayerMnyWan(vo.getChangePayerMny().divide(new BigDecimal(10000)));
        } else {
            vo.setChangePayerMnyWan(BigDecimal.ZERO);
        }
        List detailVOList = vo.getDetailList();
        for (PayerChangeDetailVO detail : detailVOList) {
            if (null != detail.getPayerMny()) {
                detail.setPayerMnyWan(detail.getPayerMny().divide(new BigDecimal(10000)));
            } else {
                detail.setPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getActualPayerMny()) {
                detail.setActualPayerMnyWan(detail.getActualPayerMny().divide(new BigDecimal(10000)));
            } else {
                detail.setActualPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getRemainderPayerMny()) {
                detail.setRemainderPayerMnyWan(detail.getRemainderPayerMny().divide(new BigDecimal(10000)));
                continue;
            }
            detail.setRemainderPayerMnyWan(BigDecimal.ZERO);
        }
        return vo;
    }

    private void writeBackPayer(PayerChangeEntity changeEntity) {
        PayerEntity payerEntity = (PayerEntity)((Object)this.payerService.selectById(changeEntity.getMainPayerId()));
        if (null == payerEntity.getChangeId() || !payerEntity.getChangeId().equals(changeEntity.getId())) {
            payerEntity.setChangeId(changeEntity.getId());
            payerEntity.setChangeCode(changeEntity.getBillCode());
            payerEntity.setChangeVersion(changeEntity.getChangeVersion());
            payerEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
            payerEntity.setChangeDate(new Date());
        }
        payerEntity.setChangeEmployeeId(changeEntity.getChangeEmployeeId());
        payerEntity.setChangeEmployeeName(changeEntity.getChangeEmployeeName());
        this.payerService.saveOrUpdate((Object)payerEntity, false);
    }

    private PayerChangeVO queryDetail(Long changeId) {
        return (PayerChangeVO)BeanMapper.map((Object)super.selectById((Serializable)changeId), PayerChangeVO.class);
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, String targetBillType) {
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, targetBillType);
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u6807\u51c6\u8868\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, targetBillType, targetBillId, targetBillTypeCode, targetBillType, copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        return null;
    }
}

