package com.ejianc.business.payer.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.payer.vo.*;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.payer.bean.PayerEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 缴纳员工明细表主实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface PayerMapper extends BaseCrudMapper<PayerEntity> {

    List<EmployeeMnyVO> pageList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper,@Param("orgIdList") List<Long> orgIdList);


    List<EmployeePayVO> queryPayList(@Param("employeeId") Long employeeId);

    List<EmployeeShareVO> queryShareList(@Param("employeeId") Long employeeId);

    List<ReportPayerVO> selectReportPayerPage(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("orgIdList") List<Long> orgIdList, @Param("riskDepositType") String riskDepositType);

    List<ReportPayerDetailVO> selectReportPayerDetailList(@Param("payerId") Long payerId, @Param("riskDepositType") String riskDepositType, List<Long> leaveIdList);

    List<ReportPayerDetailVO> selectLeavePayerDetailList(@Param("payerId") Long payerId, @Param("payerDetailIdList") List<Long> payerDetailIdList);

    List<ReportPayerRecordVO> selectReportPayerRecordList(@Param("payerId") Long payerId);

    List<ReportPayerShareVO> selectReportPayerShareOrgList(@Param("payerId") Long payerId);

    List<ReportPayerShareVO> selectReportPayerShareDeptList(@Param("payerId") Long payerId);
}
