package com.ejianc.business.rmat.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.pub.api.IPubContractApi;
import com.ejianc.business.rmat.hystrix.RmatContractHystrix;
import com.ejianc.business.rmat.vo.RmatSettlementVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 */
@FeignClient(name = "ejc-rmat-web", url = "${common.env.feign-client-url}", path = "ejc-rmat-web", fallback = RmatContractHystrix.class)
public interface IRmatContractApi {


    /**
     * 根据条件查询不同合同类型的合同结算
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "/api/rmat/getRmatSettle")
    public CommonResponse<JSONObject> getRmatSettle(@RequestBody QueryParam queryParam);

    /**
     * 回写周转材租赁结算单累计付款金额
     *
     * @param settleId 结算单id
     * @param payMny   本期支付金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/rmat/updateRentSettleSumPayMny")
    CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                     @RequestParam("payMny") BigDecimal payMny);


    /**
     * 回写周转材租赁结算单累计申请金额、剩余可申请金额
     *
     * @param settleId 结算单id
     * @param applyMny 本期申请金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/rmat/updateRentSettleSumApplyMny")
    CommonResponse<String> updateRentSettleSumApplyMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                       @RequestParam("applyMny") BigDecimal applyMny);


    /**
     * 回写周转材租赁合同累计付款金额、累计预付款金额
     *
     * @param contractId
     * @param payMny     本期支付金额，正为回写，负为逆回写
     * @param prepayMny  本期预付款金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/rmat/updateRentContractSumPayMny")
    CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value = "contractId", required = true) Long contractId,
                                                       @RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny);


    /**
     * /**
     * 根据条件查询结算单累计冲抵金额
     *
     * @return
     */
    @GetMapping(value = "/api/rmat/getRentSettlementById")
    public CommonResponse<RmatSettlementVO> getRentSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId);

}
