package com.ejianc.business.rmat.vo;

import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 设备合同表
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
public class RentContractPayVO extends BaseVO {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 合同主键
     */
    private Long contractId;
    private BigDecimal contractTaxMny;
    private BigDecimal sumSettlementTaxMny;
    private BigDecimal sumInvoiceTaxMny;
    /**
     * 组织
     */
    private Long orgId;

    /**
     * 累计付款金额
     */
    private BigDecimal sumPayMny;

    /**
     * 累计预付款金额
     */
    private BigDecimal sumPrePayMny;

    /**
     * 累计未付金额
     */
    private BigDecimal sumUnPayMny;

    /**
     * 付款详情子表
     */
    private List<PayContractVO> contractVOList;

    public BigDecimal getSumUnPayMny() {
        return sumUnPayMny;
    }

    public void setSumUnPayMny(BigDecimal sumUnPayMny) {
        this.sumUnPayMny = sumUnPayMny;
    }

    public List<PayContractVO> getContractVOList() {
        return contractVOList;
    }

    public void setContractVOList(List<PayContractVO> contractVOList) {
        this.contractVOList = contractVOList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumPrePayMny() {
        return sumPrePayMny;
    }

    public void setSumPrePayMny(BigDecimal sumPrePayMny) {
        this.sumPrePayMny = sumPrePayMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    public void setSumSettlementTaxMny(BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }

    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }
}
