/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.pub.utils.HttpTookit;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NCUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ISupplierWebApi supplierWebApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Value(value="${nc.ncArUrl}")
    private String ncArUrl;
    private static final Map<Integer, String> invoiceMainMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> taxWayMap;

    public String getInvoiceMainDefCode(Integer key) {
        if (invoiceMainMap.containsKey(key)) {
            return invoiceMainMap.get(key);
        }
        return null;
    }

    public String getTaxWayDefCode(Integer key) {
        if (taxWayMap.containsKey(key)) {
            return taxWayMap.get(key);
        }
        return null;
    }

    public String getTaxRateDefCode(BigDecimal taxRate) {
        String tax;
        if (taxRate == null) {
            throw new BusinessException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DefdocDetailVO> defList = this.getDefDocListById(515260415240835083L);
        Map<String, String> defMap = defList.stream().collect(Collectors.toMap(x -> x.getName(), DefdocDetailVO::getCode));
        if (defMap.containsKey(tax = taxRate.stripTrailingZeros().toPlainString() + "%")) {
            return defMap.get(tax);
        }
        throw new BusinessException("\u5f55\u5165\u7a0e\u7387\u201c" + tax + "\u201d\u548c\u8d22\u52a1\u7a0e\u7387\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\uff01");
    }

    public List<DefdocDetailVO> getDefDocListById(Long id) {
        CommonResponse resp = this.defdocApi.getDefDocByDefId(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    public OrgVO queryOrgById(Long id) {
        CommonResponse resp = this.orgApi.detailById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (OrgVO)resp.getData();
    }

    public List<ProjectRegisterVO> queryProjectByIds(List<Long> ids) {
        CommonResponse resp = this.projectApi.queryProjectByIds(ids);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    public SupplierVO querySupplierById(Long id) {
        CommonResponse resp = this.supplierApi.queryById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (SupplierVO)resp.getData();
    }

    public CustomerVO queryCustomerById(Long id) {
        CommonResponse resp = this.customerApi.detailById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (CustomerVO)resp.getData();
    }

    public BankAccountVO queryDefaultBankAccountById(Long id, String type) {
        CommonResponse resp = this.supplierWebApi.queryDefaultBankAccountById(id, type);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (BankAccountVO)resp.getData();
    }

    public List<Long> validateDaoQiaoOrg(Long orgId, Integer invoiceMain) {
        Long daoQiaoId = 1406795679766782028L;
        OrgVO orgVO = this.queryOrgById(orgId);
        if (orgVO.getInnerCode().contains(String.valueOf(daoQiaoId))) {
            if (new Integer(0).equals(invoiceMain) || daoQiaoId.equals(orgId)) {
                return Arrays.asList(daoQiaoId);
            }
            if (new Integer(1).equals(invoiceMain)) {
                return Arrays.asList(orgId, daoQiaoId);
            }
        }
        return Arrays.asList(orgId);
    }

    public String postByJson(String param) {
        HashMap headers = new HashMap();
        this.logger.info("-\u4f20NC\u51ed\u8bc1\u5165\u53c2:" + param);
        String back = null;
        try {
            back = HttpTookit.postByJson((String)this.ncArUrl, (String)param, headers);
        }
        catch (Exception e) {
            throw new BusinessException("\u63a8\u9001NC\u63a5\u53e3\u5f02\u5e38!");
        }
        this.logger.info("-\u4f20NC\u51ed\u8bc1\u56de\u53c2:" + back);
        JSONObject json = JSONObject.parseObject((String)back);
        if (!"200".equals(json.getString("code"))) {
            throw new BusinessException(json.getString("msg"));
        }
        return json.getString("result");
    }

    static {
        invoiceMainMap.put(0, "PMDA06001");
        invoiceMainMap.put(1, "PMDA06002");
        taxWayMap = new HashMap<Integer, String>();
        taxWayMap.put(0, "01");
        taxWayMap.put(1, "02");
        taxWayMap.put(2, "03");
    }
}

