package com.ejianc.business.rmat.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;

/**
 * <p>
 * 租赁结算明细
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@TableName("ejc_rmat_rent_settlement_detail")
public class RentSettlementDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 结算表主键
     */
    @TableField("settlement_id")
    private Long settlementId;

    /**
     * 物资ID
     */
    @TableField("material_id")
    private Long materialId;

    /**
     * 合同明细主键
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 合同使用记录主键
     */
    @TableField("use_id")
    private Long useId;

    /**
     * 合同使用记录子表主键
     */
    @TableField("use_detail_id")
    private Long useDetailId;

    /**
     * 使用记录编码
     */
    @TableField("use_code")
    private String useCode;
    /**
     * 物资分类ID
     */
    @TableField("material_type_id")
    private String materialTypeId;
    /**
     * 物资分类编码
     */
    @TableField("material_type_code")
    private String materialTypeCode;
    /**
     * 结算类型(0:过程结算，1:最终结算)
     */
    @TableField("settlement_type")
    private Integer settlementType;

    @TableField("detail_tax_rate")
    private BigDecimal detailTaxRate;//税率
    @TableField("tax_price")
    private BigDecimal taxPrice;//含税单价
    @TableField("tax_money")
    private BigDecimal taxMoney;//含税金额
    @TableField("tax")
    private BigDecimal tax;//税额
    @TableField("settlement_tax_mny")
    private BigDecimal settlementTaxMny;//本期结算金额(含税)


    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    public String getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(String materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 物资分类名称
     */
    @TableField("material_type_name")
    private String materialTypeName;

    /**
     * 来源类型,0-设备档案,1-设备使用记录,2-设备租赁合同
     */
    @TableField("source")
    private Integer source;
    /**
     * 来源名称
     */
    @TableField("source_name")
    private String sourceName;
    /**
     * 设备编码
     */
    @TableField("material_code")
    private String materialCode;

    /**
     * 设备名称
     */
    @TableField("material_name")
    private String materialName;

    /**
     * 规格型号
     */
    @TableField("spec")
    private String spec;

    /**
     * 计量单位名称
     */
    @TableField("unit")
    private String unit;

    /**
     * 单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 数量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 本期结算金额
     */
    @TableField("settlement_mny")
    private BigDecimal settlementMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 起租日期
     */
    @TableField("start_date")
    private Date startDate;

    /**
     * 停租日期
     */
    @TableField("end_date")
    private Date endDate;
    /**
     * 租期
     */
    @TableField("rent_term")
    private String rentTerm;
    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;
    /**
     * 成本科目集团主键
     */
    @TableField(value = "org_subject_id")
    private Long orgSubjectId;
    /**
     * 核算对象主键
     */
    @TableField(value = "accounting_id")
    private Long accountingId;

    /**
     * 核算对象名称
     */
    @TableField(value = "accounting_name")
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    @TableField(value = "org_accounting_id")
    private Long orgAccountingId;


    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRentTerm() {
        return rentTerm;
    }

    public void setRentTerm(String rentTerm) {
        this.rentTerm = rentTerm;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }
    public Long getUseDetailId() {
        return useDetailId;
    }

    public void setUseDetailId(Long useDetailId) {
        this.useDetailId = useDetailId;
    }

    public String getUseCode() {
        return useCode;
    }

    public void setUseCode(String useCode) {
        this.useCode = useCode;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getSpec() {
        return spec;
    }

    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    public Long getAccountingId() {
        return accountingId;
    }

    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }
}
