package com.ejianc.business.rmat.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 周转材租赁合同补充协议
 * 
 * @author generator
 * 
 */
 @TableName("ejc_rmat_contract")
public class SupplementRentContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_name")
    private java.lang.String contractName; // 合同名称
    @TableField(value="bill_code")
    private java.lang.String billCode; // 合同编码
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织主键
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目主键
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="customer_id")
    private java.lang.Long customerId; // 总包企业主键
    @TableField(value="customer_name")
    private java.lang.String customerName; // 总包企业名称
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 设备供应商主键
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 设备供应商名称
    @TableField(value="sign_date")
    private java.util.Date signDate; // 签约日期
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 合同税率
    @TableField(value="pay_scale")
    private java.math.BigDecimal payScale; // 合同支付比例
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 经办人
    @TableField(value="contract_status")
    private java.lang.String contractStatus; // 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    @TableField(value="memo")
    private java.lang.String memo; // 备注
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="change_version")
    private java.lang.Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private java.lang.Long changeId; // 变更主键
    @TableField(value="change_code")
    private java.lang.String changeCode; // 变更编号
    @TableField(value="contract_mny")
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税金
    @TableField(value="contract_tax_mny")
    private java.math.BigDecimal contractTaxMny; // 合同金额(含税)
    @TableField(value="base_money")
    private java.math.BigDecimal baseMoney; // 初始版本金额（不含税）
    @TableField(value="base_tax_money")
    private java.math.BigDecimal baseTaxMoney; // 初始版本金额
    @TableField(value="before_change_mny")
    private java.math.BigDecimal beforeChangeMny; // 变更前金额（不含税）
    @TableField(value="before_change_tax_mny")
    private java.math.BigDecimal beforeChangeTaxMny; // 变更前金额
    @TableField(value="changing_mny")
    private java.math.BigDecimal changingMny; // 变更中金额(不含税)
    @TableField(value="changing_tax_mny")
    private java.math.BigDecimal changingTaxMny; // 变更中金额
    @TableField(value="change_status")
    private java.lang.Integer changeStatus; // 变更状态1-未变更 2-变更中 3-已变更
    @TableField(value="sum_prepay_mny")
    private java.math.BigDecimal sumPrepayMny; // 累计预付款金额
    @TableField(value="sum_pay_mny")
    private java.math.BigDecimal sumPayMny; // 累计付款金额
    @TableField(value="sum_offset_mny")
    private java.math.BigDecimal sumOffsetMny; // 累计冲抵金额
    @TableField(value="sum_settlement_mny")
    private java.math.BigDecimal sumSettlementMny; // 累计结算金额(不含税)
    @TableField(value="sum_settlement_tax_mny")
    private java.math.BigDecimal sumSettlementTaxMny; // 累计结算金额
    @TableField(value="sum_invoice_mny")
    private java.math.BigDecimal sumInvoiceMny; // 累计收票金额(不含税)
    @TableField(value="sum_invoice_tax_mny")
    private java.math.BigDecimal sumInvoiceTaxMny; // 累计收票金额
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 经办人名称
    @TableField(value="settlement_type")
    private java.lang.Integer settlementType; // 结算类型(0:过程结算，1:最终结算)
    @TableField(value="main_contract_id")
    private java.lang.Long mainContractId; // 主合同ID
    @TableField(value="main_contract_code")
    private java.lang.String mainContractCode; // 主合同编码
    @TableField(value="supplement_flag")
    private java.lang.Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="main_contract_name")
    private java.lang.String mainContractName; // 主合同名称

    /**
     * 所属组织(采购组织)
     */
    @TableField("purchase_org_id")
    private Long purchaseOrgId;

    /**
     * 所属组织名称(采购组织)
     */
    @TableField("purchase_org_name")
    private String purchaseOrgName;

    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="supplementRentContractDetailService",pidName = "contractId")
    private List<SupplementRentContractDetailEntity> rentdetail = new ArrayList<>();

    // 合同条款子表
    @TableField(exist = false)
    @SubEntity(serviceName="supplementRentContractClauseService",pidName = "contractId")
    private List<SupplementRentContractClauseEntity> rentclause = new ArrayList<>();

    // 其他费用子表
    @TableField(exist = false)
    @SubEntity(serviceName="supplementRentContractFeeService",pidName = "contractId")
    private List<SupplementRentContractFeeEntity> rentfee = new ArrayList<>();

    // 付款阶段子表
    @TableField(exist = false)
    @SubEntity(serviceName="supplementRentContractStageService",pidName = "contractId")
    private List<SupplementRentContractStageEntity> rentstage = new ArrayList<>();


    public List<SupplementRentContractDetailEntity> getRentdetail() {
        return rentdetail;
    }

    public void setRentdetail(List<SupplementRentContractDetailEntity> rentdetail) {
        this.rentdetail = rentdetail;
    }

    public List<SupplementRentContractClauseEntity> getRentclause() {
        return rentclause;
    }

    public void setRentclause(List<SupplementRentContractClauseEntity> rentclause) {
        this.rentclause = rentclause;
    }

    public List<SupplementRentContractFeeEntity> getRentfee() {
        return rentfee;
    }

    public void setRentfee(List<SupplementRentContractFeeEntity> rentfee) {
        this.rentfee = rentfee;
    }

    public List<SupplementRentContractStageEntity> getRentstage() {
        return rentstage;
    }

    public void setRentstage(List<SupplementRentContractStageEntity> rentstage) {
        this.rentstage = rentstage;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编码
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 合同编码
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织主键
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目主键
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目主键
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 总包企业主键
     */
    public java.lang.Long getCustomerId() {
        return customerId;
    }

    /**
     * 总包企业主键
     */
    public void setCustomerId(java.lang.Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 总包企业名称
     */
    public java.lang.String getCustomerName() {
        return customerName;
    }

    /**
     * 总包企业名称
     */
    public void setCustomerName(java.lang.String customerName) {
        this.customerName = customerName;
    }
    /**
     * 设备供应商主键
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商主键
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 设备供应商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 设备供应商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同支付比例
     */
    public java.math.BigDecimal getPayScale() {
        return payScale;
    }

    /**
     * 合同支付比例
     */
    public void setPayScale(java.math.BigDecimal payScale) {
        this.payScale = payScale;
    }
    /**
     * 经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public java.lang.String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public void setContractStatus(java.lang.String contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 变更版本
     */
    public java.lang.Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(java.lang.Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更主键
     */
    public java.lang.Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(java.lang.Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更编号
     */
    public java.lang.String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更编号
     */
    public void setChangeCode(java.lang.String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 合同金额(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同金额(含税)
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额(含税)
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 初始版本金额（不含税）
     */
    public java.math.BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额（不含税）
     */
    public void setBaseMoney(java.math.BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 初始版本金额
     */
    public java.math.BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseTaxMoney(java.math.BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 变更前金额（不含税）
     */
    public java.math.BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额（不含税）
     */
    public void setBeforeChangeMny(java.math.BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更前金额
     */
    public java.math.BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeTaxMny(java.math.BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更中金额(不含税)
     */
    public java.math.BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额(不含税)
     */
    public void setChangingMny(java.math.BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 变更中金额
     */
    public java.math.BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingTaxMny(java.math.BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    /**
     * 变更状态1-未变更 2-变更中 3-已变更
     */
    public java.lang.Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态1-未变更 2-变更中 3-已变更
     */
    public void setChangeStatus(java.lang.Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 累计预付款金额
     */
    public java.math.BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    /**
     * 累计预付款金额
     */
    public void setSumPrepayMny(java.math.BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }
    /**
     * 累计付款金额
     */
    public java.math.BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    /**
     * 累计付款金额
     */
    public void setSumPayMny(java.math.BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    /**
     * 累计冲抵金额
     */
    public java.math.BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    /**
     * 累计冲抵金额
     */
    public void setSumOffsetMny(java.math.BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }
    /**
     * 累计结算金额(不含税)
     */
    public java.math.BigDecimal getSumSettlementMny() {
        return sumSettlementMny;
    }

    /**
     * 累计结算金额(不含税)
     */
    public void setSumSettlementMny(java.math.BigDecimal sumSettlementMny) {
        this.sumSettlementMny = sumSettlementMny;
    }
    /**
     * 累计结算金额
     */
    public java.math.BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    /**
     * 累计结算金额
     */
    public void setSumSettlementTaxMny(java.math.BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }
    /**
     * 累计收票金额(不含税)
     */
    public java.math.BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    /**
     * 累计收票金额(不含税)
     */
    public void setSumInvoiceMny(java.math.BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }
    /**
     * 累计收票金额
     */
    public java.math.BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    /**
     * 累计收票金额
     */
    public void setSumInvoiceTaxMny(java.math.BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 结算类型(0:过程结算，1:最终结算)
     */
    public java.lang.Integer getSettlementType() {
        return settlementType;
    }

    /**
     * 结算类型(0:过程结算，1:最终结算)
     */
    public void setSettlementType(java.lang.Integer settlementType) {
        this.settlementType = settlementType;
    }
    /**
     * 主合同ID
     */
    public java.lang.Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(java.lang.Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public java.lang.String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(java.lang.String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public java.lang.Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(java.lang.Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 主合同名称
     */
    public java.lang.String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(java.lang.String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Long getPurchaseOrgId() {
        return purchaseOrgId;
    }

    @TableField(value="replace_sign_flag")
    private Integer replaceSignFlag; // 是否代签：0-否，1-是

    public Integer getReplaceSignFlag() {
        return replaceSignFlag;
    }

    public void setReplaceSignFlag(Integer replaceSignFlag) {
        this.replaceSignFlag = replaceSignFlag;
    }

    public void setPurchaseOrgId(Long purchaseOrgId) {
        this.purchaseOrgId = purchaseOrgId;
    }

    public String getPurchaseOrgName() {
        return purchaseOrgName;
    }

    public void setPurchaseOrgName(String purchaseOrgName) {
        this.purchaseOrgName = purchaseOrgName;
    }
}
