package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.utils.NCUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 设备合同结算单审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("rentSettlement")
public class RentSettlementBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService rentContractService;

    @Autowired
    private IRentSettlementService rentSettlementService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private NCUtil ncUtil;
    
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入审批同意后回写--- billId:"+billId+"  state:"+state);
        RentSettlementEntity settlementEntity= rentSettlementService.selectById(billId);
        BigDecimal offsetMny = settlementEntity.getOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getOffsetMny();//本次冲抵金额
        BigDecimal settlementMny = settlementEntity.getSettlementMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementMny();//本期结算金额(不含税)
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementTaxMny();//本期结算金额(含税)

        BigDecimal sumOffsetMnys = settlementEntity.getSumOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getSumOffsetMny();//实际累计冲抵金额
        BigDecimal sumPayMnys = settlementEntity.getSumPayMny()==null?BigDecimal.ZERO:settlementEntity.getSumPayMny();//实际预付款金额
        //1，先查出合同
        RentContractEntity contractEntity = rentContractService.selectById(settlementEntity.getContractId());
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny()==null?BigDecimal.ZERO:contractEntity.getSumOffsetMny();//累计冲抵金额
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementMny();//累计结算金额(不含税)
        BigDecimal sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementTaxMny();//累计结算金额

        if(offsetMny.compareTo(sumPayMnys.subtract(sumOffsetMnys))>0){
            return CommonResponse.error("审批回写异常!该合同冲抵金额已超出预付款金额!");
        }

        contractEntity.setSumOffsetMny(sumOffsetMny.add(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.add(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.add(settlementTaxMny));
        logger.info("业务逻辑完成--"+contractEntity.getSumOffsetMny()+"    --"+contractEntity.getSumSettlementTaxMny());

        Boolean flag = rentContractService.saveOrUpdate(contractEntity,false);
        logger.info("业务逻辑完成--返回"+flag);
        if(settlementEntity.getBillState()==BillStateEnum.COMMITED_STATE.getBillStateCode()||settlementEntity.getBillState()==BillStateEnum.PASSED_STATE.getBillStateCode()){
            rentSettlementService.costPush(settlementEntity);
        }
        if(flag){

            // 推送NC传应付单凭证
            this.pushToNC(settlementEntity);
            
            return CommonResponse.success();
        }else{
            return CommonResponse.error("审批回写异常!");
        }
    }

    /**
     * 推送NC传应付单凭证
     * @param entity
     */
    private void pushToNC(RentSettlementEntity entity) {
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ApBillVO vo = this.transferToNCVO(entity, project); // 转换成NCVO

        List<Long> orgIds = ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            OrgVO orgVO = ncUtil.queryOrgById(orgId);
            vo.setPk_org(orgVO.getCode());
            String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString()); // 调用NC传凭证接口
            sourceIds += sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        
        LambdaUpdateWrapper<RentSettlementEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(RentSettlementEntity::getSourceId, sourceIds);// 保存来源主键
        wrapper.eq(RentSettlementEntity::getId, entity.getId());
        rentSettlementService.update(wrapper);
    }

    /**
     * 转换成NCVO
     * @param entity
     * @return
     */
    private ApBillVO transferToNCVO(RentSettlementEntity entity, ProjectRegisterVO project){
        logger.info("----应付单传凭证开始:");
//        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
        SupplierVO supplierVO = ncUtil.querySupplierById(entity.getSupplierId());

        ApBillVO vo = new ApBillVO();
        vo.setBusitype("apbill"); // 业务标识(默认apbill)
        vo.setTradetype("F1-Cxx-011"); // 交易类型
        vo.setPk_project(String.valueOf(entity.getProjectId())); // 项目主键
        vo.setDef12(String.valueOf(entity.getId())); // PM单据主键
        vo.setPk_org(orgVO.getCode()); // 财务组织编码
        vo.setDef1(false); // 是否有计量证书，必输，默认false
        vo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory())); // 开票主体分类 0-PMDA06001,1-PMDA06002
        vo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay())); // 计税方式 0-01,1-02
        if (StringUtils.isEmpty(project.getAreaCode())) {
            throw new BusinessException("项目-区域不能为空！");
        }
        vo.setDef5(project.getAreaCode()); // 区域编码
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));// 供应商主键
//        vo.setPk_supplier(String.valueOf(supplierVO.getCategoryId()));// 供应商分类主键
        vo.setDef6(supplierVO.getInsideOrgId() != null);// 是否内部单位 true/false
        vo.setPk_dept(String.valueOf(entity.getDeptId()));// 部门主键
        vo.setDef7(ncUtil.getTaxRateDefCode(entity.getTaxRate())); // 税率


        List<ApBillDetailVO> detailVOS = new ArrayList<>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getSettlementMny());
        detailVO.setLocal_mny(entity.getSettlementTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);

        vo.setDetail(detailVOS);
        return vo;
    }
    
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        RentSettlementEntity settlementEntity = rentSettlementService.selectById(billId);
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
            lambdachange.eq(RentSettlementEntity::getContractId, settlementEntity.getContractId());
            lambdachange.eq(RentSettlementEntity::getOrgId, settlementEntity.getOrgId());
            lambdachange.gt(RentSettlementEntity::getCreateTime, settlementEntity.getCreateTime());
            lambdachange.ne(RentSettlementEntity::getId,billId);
            lambdachange.in(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = rentSettlementService.count(lambdachange);
            if (num > 0) {
                return CommonResponse.error("审批回写异常!该合同不是最新的结算日期，不能回退!");
            } else {
                return CommonResponse.success();
            }
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入同意后回写--- billId:"+billId+"  state:"+state);
        RentSettlementEntity settlementEntity= rentSettlementService.selectById(billId);
        BigDecimal offsetMny = settlementEntity.getOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getOffsetMny();//本次冲抵金额
        BigDecimal settlementMny = settlementEntity.getSettlementMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementMny();//本期结算金额(不含税)
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementTaxMny();//本期结算金额(含税)

        //1，先查出合同
        RentContractEntity contractEntity = rentContractService.selectById(settlementEntity.getContractId());
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny()==null?BigDecimal.ZERO:contractEntity.getSumOffsetMny();//累计冲抵金额
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementMny();//累计结算金额(不含税)
        BigDecimal sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementTaxMny();//累计结算金额

        //弃审回写合同
        contractEntity.setSumOffsetMny(sumOffsetMny.subtract(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.subtract(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.subtract(settlementTaxMny));

        //弃审回写结算单上对应的金额，与合同保持一致
        logger.info("业务逻辑完成--"+contractEntity.getSumOffsetMny()+"    --"+contractEntity.getSumSettlementTaxMny());
        Boolean flag = rentContractService.saveOrUpdate(contractEntity,false);
        logger.info("业务逻辑完成--返回"+flag);
        //删除成本中心数据, 更新关联状态为未关联
        rentSettlementService.pullCost(billId);
        if(flag){
            if (StringUtils.isNotEmpty(settlementEntity.getSourceId())) {
                String sourceId = settlementEntity.getSourceId();
                String[] split = sourceId.split(",");
                for (String s : split) {
                    JSONObject json = new JSONObject();
                    json.put("busitype", "deleteapbill");
                    json.put("pk_bill", s);
                    ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
                }
            }

            // 清空来源主键
            LambdaUpdateWrapper<RentSettlementEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(RentSettlementEntity::getSourceId, null);
            wrapper.eq(RentSettlementEntity::getId, billId);
            rentSettlementService.update(wrapper);
            
            return CommonResponse.success();
        }else{
            return CommonResponse.error("审批回写异常!");
        }
    }
}
