/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.utils.NCUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentSettlement")
public class RentSettlementBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private NCUtil ncUtil;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BigDecimal sumSettlementTaxMny;
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        RentSettlementEntity settlementEntity = (RentSettlementEntity)((Object)this.rentSettlementService.selectById(billId));
        BigDecimal offsetMny = settlementEntity.getOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getOffsetMny();
        BigDecimal settlementMny = settlementEntity.getSettlementMny() == null ? BigDecimal.ZERO : settlementEntity.getSettlementMny();
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getSettlementTaxMny();
        BigDecimal sumOffsetMnys = settlementEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getSumOffsetMny();
        BigDecimal sumPayMnys = settlementEntity.getSumPayMny() == null ? BigDecimal.ZERO : settlementEntity.getSumPayMny();
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(settlementEntity.getContractId()));
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettlementMny();
        BigDecimal bigDecimal = sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettlementTaxMny();
        if (offsetMny.compareTo(sumPayMnys.subtract(sumOffsetMnys)) > 0) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u51b2\u62b5\u91d1\u989d\u5df2\u8d85\u51fa\u9884\u4ed8\u6b3e\u91d1\u989d!");
        }
        contractEntity.setSumOffsetMny(sumOffsetMny.add(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.add(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.add(settlementTaxMny));
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--" + contractEntity.getSumOffsetMny() + "    --" + contractEntity.getSumSettlementTaxMny());
        Boolean flag = this.rentContractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (settlementEntity.getBillState() == BillStateEnum.COMMITED_STATE.getBillStateCode() || settlementEntity.getBillState() == BillStateEnum.PASSED_STATE.getBillStateCode()) {
            this.rentSettlementService.costPush(settlementEntity);
        }
        if (flag.booleanValue()) {
            this.pushToNC(settlementEntity);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    private void pushToNC(RentSettlementEntity entity) {
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ApBillVO vo = this.transferToNCVO(entity, project);
        List<Long> orgIds = this.ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            OrgVO orgVO = this.ncUtil.queryOrgById(orgId);
            vo.setPk_org(orgVO.getCode());
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            sourceIds = sourceIds + sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(RentSettlementEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.rentSettlementService.update((Wrapper)wrapper);
    }

    private ApBillVO transferToNCVO(RentSettlementEntity entity, ProjectRegisterVO project) {
        this.logger.info("----\u5e94\u4ed8\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        OrgVO orgVO = this.ncUtil.queryOrgById(project.getOrgId());
        SupplierVO supplierVO = this.ncUtil.querySupplierById(entity.getSupplierId());
        ApBillVO vo = new ApBillVO();
        vo.setBusitype("apbill");
        vo.setTradetype("F1-Cxx-011");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setPk_org(orgVO.getCode());
        vo.setDef1(Boolean.valueOf(false));
        vo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        vo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        if (StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        vo.setDef5(project.getAreaCode());
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));
        vo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef7(this.ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        ArrayList<ApBillDetailVO> detailVOS = new ArrayList<ApBillDetailVO>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getSettlementMny());
        detailVO.setLocal_mny(entity.getSettlementTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentSettlementEntity settlementEntity = (RentSettlementEntity)((Object)this.rentSettlementService.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(RentSettlementEntity::getContractId, (Object)settlementEntity.getContractId());
            lambdachange.eq(RentSettlementEntity::getOrgId, (Object)settlementEntity.getOrgId());
            lambdachange.gt(BaseEntity::getCreateTime, (Object)settlementEntity.getCreateTime());
            lambdachange.ne(BaseEntity::getId, (Object)billId);
            lambdachange.in(RentSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            int num = this.rentSettlementService.count((Wrapper)lambdachange);
            if (num > 0) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u4e0d\u662f\u6700\u65b0\u7684\u7ed3\u7b97\u65e5\u671f\uff0c\u4e0d\u80fd\u56de\u9000!");
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        RentSettlementEntity settlementEntity = (RentSettlementEntity)((Object)this.rentSettlementService.selectById(billId));
        BigDecimal offsetMny = settlementEntity.getOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getOffsetMny();
        BigDecimal settlementMny = settlementEntity.getSettlementMny() == null ? BigDecimal.ZERO : settlementEntity.getSettlementMny();
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getSettlementTaxMny();
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(settlementEntity.getContractId()));
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettlementMny();
        BigDecimal sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettlementTaxMny();
        contractEntity.setSumOffsetMny(sumOffsetMny.subtract(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.subtract(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.subtract(settlementTaxMny));
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--" + contractEntity.getSumOffsetMny() + "    --" + contractEntity.getSumSettlementTaxMny());
        Boolean flag = this.rentContractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        this.rentSettlementService.pullCost(billId);
        if (flag.booleanValue()) {
            if (StringUtils.isNotEmpty((CharSequence)settlementEntity.getSourceId())) {
                String[] split;
                String sourceId = settlementEntity.getSourceId();
                for (String s : split = sourceId.split(",")) {
                    JSONObject json = new JSONObject();
                    json.put("busitype", (Object)"deleteapbill");
                    json.put("pk_bill", (Object)s);
                    this.ncUtil.postByJson(json.toJSONString());
                }
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(RentSettlementEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.rentSettlementService.update((Wrapper)wrapper);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }
}

