package com.ejianc.business.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 合同阶段表
 * </p>
 *
 * @author 曹庆伟
 * @since 2021-06-22
 */
@TableName("ejc_rmat_change_stage")
public class RentChangeStageEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 付款阶段id(为档案时才有值)
     */
    @TableField("doc_id")
    private Long docId;

    /**
     * 付款阶段名称
     */
    @TableField("name")
    private String name;

    /**
     * 付款阶段比例
     */
    @TableField("scale")
    private BigDecimal scale;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 变更主表主键
     */
    @TableField("change_id")
    private Long changeId;

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getScale() {
        return scale;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
}
