package com.ejianc.business.rmat.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rmat.bean.ApproachEntity;
import com.ejianc.business.rmat.vo.ApproachVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.service.IExitService;
import com.ejianc.business.rmat.vo.ExitVO;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/**
 * 周转材退场单实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("exit")
public class ExitController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Exit_Code";//此处需要根据实际修改
    
    @Autowired
    private IExitService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitVO> saveOrUpdate(@RequestBody ExitVO saveorUpdateVO) {
    	ExitEntity entity = BeanMapper.map(saveorUpdateVO, ExitEntity.class);
        LambdaQueryWrapper<ExitEntity> query = new LambdaQueryWrapper<>();
        // 区别新增、修改，查询的时候排除自己
        if (saveorUpdateVO.getId()!=null){
            query.ne(ExitEntity::getId, saveorUpdateVO.getId());
        }
        // 校验相同合同下是否已存在自由态或审批中
        query.eq(ExitEntity::getContractId, saveorUpdateVO.getContractId());
        query.in(ExitEntity::getBillState,0,2,5);
        query.eq(ExitEntity::getDr,0);
        List<ExitEntity> entities =  service.list(query);
        if (CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("一个合同只能存在一个自由态或审批中的单据！");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ExitVO vo = BeanMapper.map(entity, ExitVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitVO> queryDetail(Long id) {
    	ExitEntity entity = service.selectById(id);
    	ExitVO vo = BeanMapper.map(entity, ExitVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitVO> vos) {
        service.removeByIds(vos.stream().map(ExitVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ExitEntity> page = service.queryPage(param,false);
        IPage<ExitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExitEntity> list = service.queryList(param);
        List<ExitVO> vos = new ArrayList<>();
        for(ExitEntity entity : list){
            ExitVO vo = BeanMapper.map(entity, ExitVO.class);
            //变更状态 0未变更 1 已变更
            if(vo.getBillState()!=null){
                if(vo.getBillState()==0){
                    vo.setBillStateName("自由态");
                }
                if(vo.getBillState()==1){
                    vo.setBillStateName("已提交");
                }
                if(vo.getBillState()==2){
                    vo.setBillStateName("审批中");
                }
                if(vo.getBillState()==3){
                    vo.setBillStateName("已通过");
                }
                if(vo.getBillState()==4){
                    vo.setBillStateName("已驳回");
                }
                if(vo.getBillState()==5){
                    vo.setBillStateName("审批中");
                }
            }
            vos.add(vo);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("exit-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refExitData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExitVO>> refExitData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExitEntity> page = service.queryPage(param,false);
        IPage<ExitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
