package com.ejianc.business.rmat.service;

import com.ejianc.business.rmat.bean.PurchaseChangeEntity;
import com.ejianc.business.rmat.vo.PurchaseChangeRecordVO;
import com.ejianc.business.rmat.vo.PurchaseChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * <p>
 * 设备合同变更表 服务类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
public interface IPurchaseChangeService extends IBaseService<PurchaseChangeEntity> {

    /**
     * 保存或修改信息
     *
     * @param PurchaseChangeVo
     * @return
     */
    CommonResponse<PurchaseChangeVO> saveOrUpdate(PurchaseChangeVO PurchaseChangeVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    PurchaseChangeVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param vos
     */
    void deletePurchaseChange(List<PurchaseChangeVO> vos);

    PurchaseChangeVO queryDetails(Long id);

    PurchaseChangeRecordVO queryChangeRecord(Long id);
}
