package com.ejianc.business.rmat.service;

import com.ejianc.business.rmat.bean.PurchaseContractEntity;
import com.ejianc.business.rmat.controller.SqlParam;
import com.ejianc.business.rmat.vo.EquipmentReportVo;
import com.ejianc.business.rmat.vo.PurchaseContractVO;
import com.ejianc.business.rmat.vo.warn.EquipmentWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface IPurchaseContractService extends IBaseService<PurchaseContractEntity> {

    /**
     * 保存或修改信息
     *
     * @param PurchaseContractVo
     * @return
     */
    CommonResponse<PurchaseContractVO> saveOrUpdate(PurchaseContractVO PurchaseContractVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    PurchaseContractVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param vos
     */
    void deletePurchaseContract(List<PurchaseContractVO> vos);

    /**
     * 汇总合同原始金额--现合同金额
     *
     * @param queryParam
     */
    Map<String, Object> countContractAmount(QueryParam queryParam);


    List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryPayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList);

    List<EquipmentWarnVo> equipmentProjectOutMny(List<Long> tenantIds);

    List<EquipmentReportVo> getMonthEquipmentMny(Long projectId, Integer lastDay);

    List<EquipmentReportVo> getEquipment(Long projectId);
}
