package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.rmat.bean.PurchaseRecordDetailEntity;
import com.ejianc.business.rmat.bean.PurchaseRecordEntity;
import com.ejianc.business.rmat.mapper.PurchaseRecordMapper;
import com.ejianc.business.rmat.service.IPurchaseRecordDetailService;
import com.ejianc.business.rmat.service.IPurchaseRecordService;
import com.ejianc.business.rmat.vo.PurchaseRecordDetailVO;
import com.ejianc.business.rmat.vo.PurchaseRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("PurchaseRecordService")
public class PurchaseRecordServiceImpl extends BaseServiceImpl<PurchaseRecordMapper, PurchaseRecordEntity> implements IPurchaseRecordService {
    @Autowired
    private IPurchaseRecordDetailService purchaseRecordDetailService;
    @Override
    public PurchaseRecordVO queryDetail(Long id) {
        LambdaQueryWrapper<PurchaseRecordEntity> lambda = Wrappers.<PurchaseRecordEntity>lambdaQuery();
        lambda.eq(PurchaseRecordEntity::getChangeId, id);
        PurchaseRecordEntity entity = super.getOne(lambda);
        if(null!=entity&&null!=entity.getId()){
            PurchaseRecordEntity aggVO = super.selectById(entity.getId());
            PurchaseRecordVO purchaseRecordVo = BeanMapper.map(aggVO, PurchaseRecordVO.class);
            List<PurchaseRecordDetailEntity> details = null;
            LambdaQueryWrapper<PurchaseRecordDetailEntity> lambdas = Wrappers.<PurchaseRecordDetailEntity>lambdaQuery();
            lambdas.eq(PurchaseRecordDetailEntity::getRecordId,purchaseRecordVo.getId());
            lambdas.ne(PurchaseRecordDetailEntity::getChangeType,"3");
            details = purchaseRecordDetailService.list(lambdas);
            if(CollectionUtils.isNotEmpty(details)){
                purchaseRecordVo.setPurchasedetail(BeanMapper.mapList(details,PurchaseRecordDetailVO.class));
            }
            return purchaseRecordVo;
        }else{
            return new PurchaseRecordVO();
        }
    }
}