package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.service.IRentContractDetailService;
import com.ejianc.business.rmat.service.IRentContractFeeService;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.ISupplementRentContractService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("supplementRentContract") 
public class SupplementRentContractBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ISupplementRentContractService supplementService;

	@Autowired
	private IRentContractService contractService;

	@Autowired
	private IRentContractDetailService RentContractDetailService;

	@Autowired
	private IRentContractFeeService RentContractFeeService;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SupplementRentContractEntity supplementEntity = supplementService.selectById(billId);
		RentContractEntity contractEntity  = contractService.selectById(supplementEntity.getMainContractId());
		BigDecimal contractMny = contractEntity.getContractMny()==null?BigDecimal.ZERO:contractEntity.getContractMny();
		BigDecimal contractTaxMny = contractEntity.getContractTaxMny()==null?BigDecimal.ZERO:contractEntity.getContractTaxMny();
		BigDecimal supplementcontractMny = supplementEntity.getContractMny()==null?BigDecimal.ZERO:supplementEntity.getContractMny();
		BigDecimal supplementcontractTaxMny = supplementEntity.getContractTaxMny()==null?BigDecimal.ZERO:supplementEntity.getContractTaxMny();
		contractEntity.setContractMny(contractMny.add(supplementcontractMny));
		contractEntity.setContractTaxMny(contractTaxMny.add(supplementcontractTaxMny));
		contractEntity.setTaxMny(contractEntity.getContractTaxMny().subtract(contractEntity.getContractMny()));
		contractService.updateById(contractEntity);
		List<SupplementRentContractDetailEntity> listdetail = supplementEntity.getRentdetail();
		//复制补充协议的子表到 合同子表   只涉及有金额的子表
		if(CollectionUtils.isNotEmpty(listdetail)){
			List<RentContractDetailEntity> Rentdetail = new ArrayList<>();
			listdetail.forEach(e->{
				RentContractDetailEntity detailEntity = BeanMapper.map(e, RentContractDetailEntity.class);
				detailEntity.setSrcSupplementFlag(1);
				detailEntity.setSrcSupplementDetailId(e.getId());
				detailEntity.setSrcSupplementId(billId);
				detailEntity.setContractId(supplementEntity.getMainContractId());
				detailEntity.setId(null);
				detailEntity.setCreateUserCode(null);
				detailEntity.setCreateTime(null);
				detailEntity.setUpdateTime(null);
				detailEntity.setUpdateUserCode(null);
				Rentdetail.add(detailEntity);
			});
			RentContractDetailService.saveBatch(Rentdetail);
		}

		List<SupplementRentContractFeeEntity> Rentfee = supplementEntity.getRentfee();
		if(CollectionUtils.isNotEmpty(Rentfee)){
			List<RentContractFeeEntity> feeetail = new ArrayList<>();
			Rentfee.forEach(e->{
				RentContractFeeEntity feeEntity = BeanMapper.map(e, RentContractFeeEntity.class);
				feeEntity.setSrcSupplementFlag(1);
				feeEntity.setSrcSupplementDetailId(e.getId());
				feeEntity.setSrcSupplementId(billId);
				feeEntity.setContractId(supplementEntity.getMainContractId());
				feeEntity.setId(null);
				feeEntity.setCreateUserCode(null);
				feeEntity.setCreateTime(null);
				feeEntity.setUpdateTime(null);
				feeEntity.setUpdateUserCode(null);
				feeetail.add(feeEntity);
			});
			RentContractFeeService.saveBatch(feeetail);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("补充协议暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
