package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.JspayableDetailEntity;
import com.ejianc.business.salary.bean.JspayableEntity;
import com.ejianc.business.salary.service.IJspayableService;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.JspayableAdjustMapper;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.service.IJspayableAdjustService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 应发公积金调整
 * 
 * @author generator
 * 
 */
@Service("jspayableAdjustService")
public class JspayableAdjustServiceImpl extends BaseServiceImpl<JspayableAdjustMapper, JspayableAdjustEntity> implements IJspayableAdjustService{
    @Autowired
    private IJspayableService jspayableService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insuranceAdjustApportion(Long jspayableId) {
//        JspayableEntity jspayableEntity = jspayableService.selectById(jspayableId);
//        List<JspayableDetailEntity> detailList = jspayableEntity.getJspayableDetailList();
//        List<Long> jsDetailIdList = detailList.stream().map(JspayableDetailEntity::getId).collect(Collectors.toList());
//
//        //分摊社保公积金 全删全加
//        super.remove(new QueryWrapper<JspayableAdjustEntity>().in("jspayableDetailId", jsDetailIdList));
//
//        //1.查询到对应的应发工资上传子表id
//        List<Long> sourceDetailIdList = detailList.stream().map(JspayableDetailEntity::getyf).collect(Collectors.toList());
//        Map<Long, TaxDetailEntity> sourIdMap = detailList.stream().collect(Collectors.toMap(p -> p.getYfgzjsBillDetailId(), Function.identity()));
//
//        //2.根据应发工资计算子表id查询对应的 应发公积金 调整单
//        List<JspayableAdjustEntity> adjustEntityList = jspayableAdjustService.list(new QueryWrapper<JspayableAdjustEntity>().in("jspayableDetailId", sourceDetailIdList));
//
//        //3.根据应发公积金调整单 保存对应的个税调整数据
//        List<TaxModifyEntity> taxModifySaveList = new ArrayList<>();
//        for (JspayableAdjustEntity jsAdjust : adjustEntityList) {
//            TaxModifyEntity taxModifyEntity = new TaxModifyEntity();
//            taxModifyEntity.setTaxHoldOrgId(jsAdjust.getSbcdOrgId());
//            taxModifyEntity.setTaxHoldOrgCode(jsAdjust.getSbcdOrgCode());
//            taxModifyEntity.setTaxHoldOrgName(jsAdjust.getSbcdOrgName());
//            taxModifyEntity.setAcSet(jsAdjust.getAcSet());
//            taxModifyEntity.setAcSetCode(jsAdjust.getAcSetCode());
//
//            //比例
//            taxModifyEntity.setScale(jsAdjust.getScale());
//            //todo：这里后续如果计算有差则用先A*比例，后B*比例，总值再减A减B的方式得C值
//            //设置个税金额（累计应补/退税额）
//            BigDecimal totalButuiTaxMny = sourIdMap.get(jsAdjust.getJspayableDetailId()).getTotalButuiTaxMny();
//            taxModifyEntity.setTaxMny(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(totalButuiTaxMny, jsAdjust.getScale()), new BigDecimal(100)));
//            taxModifyEntity.setTaxBillId(taxId);
//            taxModifyEntity.setTaxBillDetailId(sourIdMap.get(jsAdjust.getJspayableDetailId()).getId());
//            taxModifyEntity.setScale(jsAdjust.getScale());
//            //是否默认单位
//            taxModifyEntity.setIsDefault(sourIdMap.get(jsAdjust.getJspayableDetailId()).getTaxHoldOrgId().toString().equals(taxModifyEntity.getTaxHoldOrgId()) ? "1" : "2");
//            taxModifySaveList.add(taxModifyEntity);
//        }
//        super.saveOrUpdateBatch(taxModifySaveList, taxModifySaveList.size());
    }
}
