package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.salary.bean.JspayableDetailEntity;
import com.ejianc.business.salary.bean.JspayableEntity;
import com.ejianc.business.salary.bean.TaxDetailEntity;
import com.ejianc.business.salary.bean.TaxEntity;
import com.ejianc.business.salary.service.IJspayableService;
import com.ejianc.business.salary.service.ITaxModifyService;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.business.salary.vo.TaxDetailVO;
import com.ejianc.business.salary.vo.TaxVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("jspayable") 
public class JspayableBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String TAX_BILL_CODE = "TAX";//此处需要根据实际修改
	@Autowired
	private IJspayableService jspayableService;
	@Autowired
	private ITaxService taxService;
	@Autowired
	private IBillCodeApi billCodeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//生成个税计算单
		JspayableEntity jspayableEntity = jspayableService.selectById(billId);
		TaxEntity taxEntity = new TaxEntity();
		taxEntity.setBillState(0);
		taxEntity.setId(IdWorker.getId());
		taxEntity.setEmployeeId(jspayableEntity.getEmployeeId());
		taxEntity.setEmployeeName(jspayableEntity.getEmployeeName());
		taxEntity.setYfgzjsBillId(jspayableEntity.getId());
		taxEntity.setYfgzjsBillCode(jspayableEntity.getBillCode());
		taxEntity.setMonth(jspayableEntity.getMonth());
		//编码，看后期是否需要
		BillCodeParam billCodeParam = BillCodeParam.build(TAX_BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(taxEntity, TaxVO.class));
		CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
		if(billCode.isSuccess()) {
			taxEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
		}else{
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}

		List<TaxDetailEntity> taxDetailList = new ArrayList<>();
		for (JspayableDetailEntity detail : jspayableEntity.getJspayableDetailList()) {
			TaxDetailEntity taxDetailEntity = BeanMapper.map(detail, TaxDetailEntity.class);
			taxDetailEntity.setSybxMny(detail.getCriticalIllnessMny());
			taxDetailEntity.setIsAdjust("2");
			taxDetailEntity.setYfgzjsBillDetailId(detail.getId());
			taxDetailEntity.setYfgzjsBillId(billId);
			taxDetailEntity.setTaxId(taxEntity.getId());
			taxDetailList.add(taxDetailEntity);
		}
		taxEntity.setDetailList(taxDetailList);
		logger.info("生成个税计算单数据：{}", JSONObject.toJSONString(taxEntity));
		taxService.saveOrUpdate(taxEntity);

		//生成工资单



		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
