/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.ejianc.business.salary.bean.RosterAccumulationFundEntity;
import com.ejianc.business.salary.bean.RosterSocialSecurityEntity;
import com.ejianc.business.salary.bean.SocialSecurityChangeAdetailEntity;
import com.ejianc.business.salary.bean.SocialSecurityChangeEntity;
import com.ejianc.business.salary.bean.SocialSecurityChangeSdetailEntity;
import com.ejianc.business.salary.service.IRosterAccumulationFundService;
import com.ejianc.business.salary.service.IRosterSocialSecurityService;
import com.ejianc.business.salary.service.ISocialSecurityChangeService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="socialSecurityChange")
public class SocialSecurityChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ISocialSecurityChangeService service;
    @Autowired
    private IRosterSocialSecurityService socialSecurityService;
    @Autowired
    private IRosterAccumulationFundService accumulationFundService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u6b64\u5355\u636e\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SocialSecurityChangeEntity socialSecurityChangeEntity = (SocialSecurityChangeEntity)((Object)this.service.selectById(billId));
        if (socialSecurityChangeEntity != null) {
            List<SocialSecurityChangeAdetailEntity> socialSecurityChangeAdetailList;
            List<SocialSecurityChangeSdetailEntity> socialSecurityChangeSdetailList = socialSecurityChangeEntity.getSocialSecurityChangeSdetailList();
            if (CollectionUtils.isNotEmpty(socialSecurityChangeSdetailList)) {
                List rosterSocialSecurityEntities = BeanMapper.mapList(socialSecurityChangeSdetailList, RosterSocialSecurityEntity.class);
                this.socialSecurityService.updateSocialSecurity(rosterSocialSecurityEntities);
            }
            if (CollectionUtils.isNotEmpty(socialSecurityChangeAdetailList = socialSecurityChangeEntity.getSocialSecurityChangeAdetailList())) {
                List rosterAccumulationFundEntities = BeanMapper.mapList(socialSecurityChangeAdetailList, RosterAccumulationFundEntity.class);
                this.accumulationFundService.updateAccumulationFund(rosterAccumulationFundEntities);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u6b64\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

