/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.JspayableDetailEntity;
import com.ejianc.business.salary.bean.JspayableEntity;
import com.ejianc.business.salary.bean.JspayableSourceEntity;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.service.IJspayableAdjustService;
import com.ejianc.business.salary.service.IJspayableService;
import com.ejianc.business.salary.service.IJspayableSourceService;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.util.DetailIndexExcelReader;
import com.ejianc.business.salary.vo.JspayableDetailVO;
import com.ejianc.business.salary.vo.JspayableSourceVO;
import com.ejianc.business.salary.vo.JspayableVO;
import com.ejianc.business.salary.vo.RosterAttendanceVO;
import com.ejianc.business.salary.vo.RosterSbVO;
import com.ejianc.business.salary.vo.SourceDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"jspayable"})
public class JspayableController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "YFGZJS_CODE";
    @Autowired
    private IJspayableService service;
    @Autowired
    private IJspayableSourceService jspayableSourceService;
    @Autowired
    private IJspayableAdjustService jspayableAdjustService;
    @Autowired
    private IPayableDetailService payableDetailService;
    @Autowired
    private IRosterService rosterService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JspayableVO> saveOrUpdate(@RequestBody JspayableVO saveOrUpdateVO) {
        List list;
        JspayableEntity entity = (JspayableEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, JspayableEntity.class));
        LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
        lambdaQueryWrapper1.eq(JspayableEntity::getMonth, (Object)saveOrUpdateVO.getMonth());
        if (null != entity.getId()) {
            lambdaQueryWrapper1.ne(BaseEntity::getId, (Object)entity.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)lambdaQueryWrapper1)))) {
            throw new BusinessException("\u8be5\u6708\u4efd\u5df2\u5b58\u5728\u5e94\u53d1\u5de5\u8d44\u8ba1\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<JspayableDetailEntity> jspayableDetailVOList = entity.getJspayableDetailList();
        if (CollectionUtils.isNotEmpty(jspayableDetailVOList)) {
            ArrayList idCardList = new ArrayList();
            jspayableDetailVOList.forEach(e -> idCardList.add(e.getIdCard()));
            LambdaQueryWrapper lambdaQueryWrapper2 = new LambdaQueryWrapper();
            lambdaQueryWrapper2.eq(JspayableSourceEntity::getPeriod, (Object)entity.getMonth());
            lambdaQueryWrapper2.in(JspayableSourceEntity::getIdCard, idCardList);
            List jspayableSourceEntityList = this.jspayableSourceService.list((Wrapper)lambdaQueryWrapper2);
            if (CollectionUtils.isNotEmpty((Collection)jspayableSourceEntityList)) {
                HashSet detailIdSet = new HashSet();
                jspayableSourceEntityList.forEach(e -> detailIdSet.add(e.getSourceDetailId()));
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.in((Object)"id", detailIdSet);
                updateWrapper.set((Object)"detail_collect_status", (Object)1);
                this.payableDetailService.update((Wrapper)updateWrapper);
            }
        }
        JspayableVO vo = (JspayableVO)BeanMapper.map((Object)((Object)entity), JspayableVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JspayableVO> queryDetail(Long id) {
        JspayableEntity entity = (JspayableEntity)((Object)this.service.selectById(id));
        JspayableVO vo = (JspayableVO)BeanMapper.map((Object)((Object)entity), JspayableVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/querySumDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JspayableDetailVO>> querySumDetail(String yf) {
        Date month = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            month = dateFormat.parse(yf);
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        List<Object> res = new ArrayList();
        List<JspayableSourceVO> sourceList = this.service.getDetailSource(month);
        if (CollectionUtils.isNotEmpty(sourceList)) {
            HashSet idCards = new HashSet();
            sourceList.forEach(e -> idCards.add(e.getIdCard()));
            LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
            lambdaQueryWrapper1.eq(JspayableSourceEntity::getPeriod, (Object)month);
            lambdaQueryWrapper1.in(JspayableSourceEntity::getIdCard, idCards);
            this.jspayableSourceService.remove((Wrapper)lambdaQueryWrapper1);
            List jspayableSourceEntityList = BeanMapper.mapList(sourceList, JspayableSourceEntity.class);
            jspayableSourceEntityList.forEach(e -> e.setId(null));
            this.jspayableSourceService.saveBatch(jspayableSourceEntityList);
            res = this.service.getDetailSum(month);
            List<RosterAttendanceVO> attendanceVOList = this.service.queryAttendanceDetail(month, idCards.stream().collect(Collectors.toList()));
            Map<Object, Object> attendanceMap = new HashMap();
            attendanceMap = attendanceVOList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            List<RosterSbVO> sbVOList = this.service.querySbDetail(idCards.stream().collect(Collectors.toList()));
            Map<Object, Object> sbMap = new HashMap();
            sbMap = sbVOList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            Map<Object, Object> gjjMap = new HashMap();
            List<RosterSbVO> gjjVOList = this.service.queryGjjDetail(idCards.stream().collect(Collectors.toList()));
            gjjMap = gjjVOList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            ArrayList<JspayableAdjustEntity> adjustEntityList = new ArrayList<JspayableAdjustEntity>();
            if (CollectionUtils.isNotEmpty(res)) {
                for (JspayableDetailVO jspayableDetailVO : res) {
                    JspayableAdjustEntity entity = new JspayableAdjustEntity();
                    jspayableDetailVO.setRowState("add");
                    entity.setSbcdOrgId(jspayableDetailVO.getSbcdOrgId());
                    entity.setSbcdOrgCode(jspayableDetailVO.getSbcdOrgCode());
                    entity.setSbcdOrgName(jspayableDetailVO.getSbcdOrgName());
                    entity.setIdCard(jspayableDetailVO.getIdCard());
                    entity.setPeriod(month);
                    entity.setScale(new BigDecimal(1));
                    entity.setIsDefault("1");
                    if (attendanceMap.containsKey(jspayableDetailVO.getIdCard())) {
                        jspayableDetailVO.setNeedAttendanceDays(((RosterAttendanceVO)attendanceMap.get(jspayableDetailVO.getIdCard())).getShouldDay());
                        jspayableDetailVO.setActualAttendanceDays(((RosterAttendanceVO)attendanceMap.get(jspayableDetailVO.getIdCard())).getActualDay());
                    }
                    if (sbMap.containsKey(jspayableDetailVO.getIdCard())) {
                        jspayableDetailVO.setPersonEndowmentMny(((RosterSbVO)sbMap.get(jspayableDetailVO.getIdCard())).getPersonAnnuityMoney());
                        jspayableDetailVO.setPersonMedicalMny(((RosterSbVO)sbMap.get(jspayableDetailVO.getIdCard())).getPersonMedicalMoney());
                        jspayableDetailVO.setPersonUnemploymentMny(((RosterSbVO)sbMap.get(jspayableDetailVO.getIdCard())).getPersonUnemploymentMoney());
                        jspayableDetailVO.setCompanyBirthMny(((RosterSbVO)sbMap.get(jspayableDetailVO.getIdCard())).getCompanyChildbirthMoney());
                        jspayableDetailVO.setCompanyEndowmentMny(((RosterSbVO)sbMap.get(jspayableDetailVO.getIdCard())).getCompanyAnnuityMoney());
                        jspayableDetailVO.setCompanyInjureMny(((RosterSbVO)sbMap.get(jspayableDetailVO.getIdCard())).getCompanyInjuryMoney());
                        jspayableDetailVO.setCompanyMedicalMny(((RosterSbVO)sbMap.get(jspayableDetailVO.getIdCard())).getCompanyMedicalMoney());
                        jspayableDetailVO.setCompanyUnemploymentMny(((RosterSbVO)sbMap.get(jspayableDetailVO.getIdCard())).getCompanyUnemploymentMoney());
                        entity.setPersonEndowmentMny(jspayableDetailVO.getPersonEndowmentMny());
                        entity.setPersonMedicalMny(jspayableDetailVO.getPersonMedicalMny());
                        entity.setPersonUnemploymentMny(jspayableDetailVO.getPersonUnemploymentMny());
                        entity.setCompanyBirthMny(jspayableDetailVO.getCompanyBirthMny());
                        entity.setCompanyEndowmentMny(jspayableDetailVO.getCompanyEndowmentMny());
                        entity.setCompanyInjureMny(jspayableDetailVO.getCompanyInjureMny());
                        entity.setCompanyMedicalMny(jspayableDetailVO.getCompanyMedicalMny());
                        entity.setCompanyUnemploymentMny(jspayableDetailVO.getCompanyUnemploymentMny());
                    } else if (gjjMap.containsKey(jspayableDetailVO.getIdCard())) {
                        jspayableDetailVO.setPersonHouseMny(((RosterSbVO)gjjMap.get(jspayableDetailVO.getIdCard())).getPersonMoney());
                        jspayableDetailVO.setCompanyHouseMny(((RosterSbVO)gjjMap.get(jspayableDetailVO.getIdCard())).getCompanyMoney());
                        entity.setPersonHouseMny(jspayableDetailVO.getPersonHouseMny());
                        entity.setCompanyHouseMny(jspayableDetailVO.getCompanyHouseMny());
                    }
                    adjustEntityList.add(entity);
                }
                LambdaQueryWrapper lambdaQueryWrapper2 = new LambdaQueryWrapper();
                lambdaQueryWrapper2.eq(JspayableAdjustEntity::getPeriod, (Object)month);
                lambdaQueryWrapper2.in(JspayableAdjustEntity::getIdCard, idCards);
                this.jspayableAdjustService.remove((Wrapper)lambdaQueryWrapper2);
                this.jspayableAdjustService.saveBatch(adjustEntityList);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", res);
    }

    @RequestMapping(value={"/querySourceDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SourceDetailVO>> querySourceDetail(String idCard, String period) {
        Date month = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            month = dateFormat.parse(period);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.querySourceDetail(idCard, month));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<JspayableVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (JspayableVO vo : vos) {
                JspayableEntity entity = (JspayableEntity)((Object)this.service.selectById(vo.getId()));
                List<JspayableDetailEntity> jspayableDetailVOList = entity.getJspayableDetailList();
                if (!CollectionUtils.isNotEmpty(jspayableDetailVOList)) continue;
                ArrayList idCardList = new ArrayList();
                jspayableDetailVOList.forEach(e -> idCardList.add(e.getIdCard()));
                LambdaQueryWrapper lambdaQueryWrapper2 = new LambdaQueryWrapper();
                lambdaQueryWrapper2.eq(JspayableSourceEntity::getPeriod, (Object)entity.getMonth());
                lambdaQueryWrapper2.in(JspayableSourceEntity::getIdCard, idCardList);
                List jspayableSourceEntityList = this.jspayableSourceService.list((Wrapper)lambdaQueryWrapper2);
                if (!CollectionUtils.isNotEmpty((Collection)jspayableSourceEntityList)) continue;
                HashSet detailIdSet = new HashSet();
                jspayableSourceEntityList.forEach(e -> detailIdSet.add(e.getSourceDetailId()));
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.in((Object)"id", detailIdSet);
                updateWrapper.set((Object)"detail_collect_status", (Object)0);
                this.payableDetailService.update((Wrapper)updateWrapper);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JspayableVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JspayableVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Jspayable-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refJspayableData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<JspayableVO>> refJspayableData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JspayableVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"JspayableDetail-import.xlsx", (String)"\u5e94\u53d1\u5de5\u8d44\u8ba1\u7b97-\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<JspayableDetailVO> successList = new ArrayList<JspayableDetailVO>();
        ArrayList<JspayableDetailVO> errorList = new ArrayList<JspayableDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<String> idCardList = new ArrayList<String>();
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                idCardList.add(datas.get(1).trim());
            }
            Map<Object, Object> map = new HashMap();
            LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
            lambdaQueryWrapper1.eq(RosterEntity::getHrState, (Object)1);
            lambdaQueryWrapper1.in(RosterEntity::getIdCard, idCardList);
            lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
            List rosterEntityList = this.rosterService.list((Wrapper)lambdaQueryWrapper1);
            map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            this.logger.info("\u4eba\u5458map: {}", (Object)JSONObject.toJSONString(map));
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                JspayableDetailVO detailVO = new JspayableDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                try {
                    String idCard = datas.get(1).trim();
                    detailVO.setIdCard(idCard);
                    if (ObjectUtils.isEmpty((Object)map.get(idCard))) {
                        throw new Exception("\u6ca1\u6709\u8be5\u4eba\u5458\u4fe1\u606f\uff01");
                    }
                    detailVO.setDetailEmployeeId(((RosterEntity)((Object)map.get(idCard))).getUserId());
                    detailVO.setDetailEmployeeName(datas.get(0));
                    detailVO.setDetailEmployeeCode(((RosterEntity)((Object)map.get(idCard))).getUserCode());
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6ca1\u6709\u8be5\u4eba\u5458\u4fe1\u606f\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String criticalIllnessMny = datas.get(2);
                    detailVO.setCriticalIllnessMny(StringUtils.isNotBlank((CharSequence)criticalIllnessMny) ? new BigDecimal(criticalIllnessMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5927\u75c5\u533b\u4fdd\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setRowState("add");
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

