/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.bean.PayrollPersonEntity;
import com.ejianc.business.salary.bean.TaxDetailEntity;
import com.ejianc.business.salary.bean.TaxEntity;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tax")
public class TaxBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ITaxService taxService;
    @Autowired
    private IPayrollService payrollService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TaxEntity taxEntity = (TaxEntity)((Object)this.taxService.selectById(billId));
        Map taxDetailMap = taxEntity.getDetailList().stream().collect(Collectors.toMap(p -> p.getYfgzjsBillDetailId(), Function.identity()));
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.getOne((Wrapper)new QueryWrapper().eq((Object)"yfgzjs_bill_id", (Object)taxEntity.getYfgzjsBillId())));
        payrollEntity = (PayrollEntity)((Object)this.payrollService.selectById(payrollEntity.getId()));
        List<PayrollPersonEntity> payrollPersonList = payrollEntity.getPayrollPersonList();
        for (PayrollPersonEntity payrollPersonEntity : payrollPersonList) {
            if (!taxDetailMap.containsKey(payrollPersonEntity.getYfgzjsBillDetailId())) continue;
            payrollPersonEntity.setTotalButuiTaxMny(((TaxDetailEntity)((Object)taxDetailMap.get(payrollPersonEntity.getYfgzjsBillDetailId()))).getTotalButuiTaxMny());
            payrollPersonEntity.setYfmsMny(((TaxDetailEntity)((Object)taxDetailMap.get(payrollPersonEntity.getYfgzjsBillDetailId()))).getYfmsMny());
            payrollPersonEntity.setYfmsSalaryMny(((TaxDetailEntity)((Object)taxDetailMap.get(payrollPersonEntity.getYfgzjsBillDetailId()))).getYfmsSalaryMny());
            payrollPersonEntity.setTotalZxkcMny(((TaxDetailEntity)((Object)taxDetailMap.get(payrollPersonEntity.getYfgzjsBillDetailId()))).getTotalZxkcMny());
            payrollPersonEntity.setActualMny(ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeSub((BigDecimal)payrollPersonEntity.getYfSalaryMny(), (BigDecimal[])new BigDecimal[]{payrollPersonEntity.getPersonEndowmentMny(), payrollPersonEntity.getPersonUnemploymentMny(), payrollPersonEntity.getPersonMedicalMny(), payrollPersonEntity.getPersonHouseMny(), payrollPersonEntity.getCertificateMny()}), (BigDecimal)payrollPersonEntity.getYfmsMny()));
            payrollPersonEntity.setLeftMny(payrollPersonEntity.getActualMny());
        }
        payrollEntity.setActualSumMny(payrollPersonList.stream().filter(p -> p.getActualMny() != null).map(PayrollPersonEntity::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        payrollEntity.setLeftSumMny(payrollEntity.getActualSumMny());
        this.payrollService.saveOrUpdate((Object)payrollEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        TaxEntity taxEntity = (TaxEntity)((Object)this.taxService.selectById(billId));
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.getOne((Wrapper)new QueryWrapper().eq((Object)"yfgzjs_bill_id", (Object)taxEntity.getYfgzjsBillId())));
        if (payrollEntity.getBillState() == 1 || payrollEntity.getBillState() == 3 || payrollEntity.getBillState() == 2 || payrollEntity.getBillState() == 5) {
            return CommonResponse.error((String)"\u5de5\u8d44\u5355\u5ba1\u6279\u4e2d\u6216\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

