/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.salary.bean.TaxDetailEntity;
import com.ejianc.business.salary.bean.TaxEntity;
import com.ejianc.business.salary.mapper.TaxMapper;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.business.salary.vo.TaxDetailImportVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="taxService")
public class TaxServiceImpl
extends BaseServiceImpl<TaxMapper, TaxEntity>
implements ITaxService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<TaxDetailImportVO> successList = new ArrayList<TaxDetailImportVO>();
        ArrayList<TaxDetailImportVO> errorList = new ArrayList<TaxDetailImportVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 18) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 1000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            Long taxId = Long.valueOf(request.getParameter("taxId"));
            this.logger.info("taxId: {}", (Object)JSONObject.toJSONString((Object)taxId));
            TaxEntity taxEntity = (TaxEntity)((Object)super.selectById((Serializable)taxId));
            Map personMap = taxEntity.getDetailList().stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            this.logger.info("\u4eba\u5458map: {}", (Object)JSONObject.toJSONString(personMap));
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                TaxDetailImportVO importVO = new TaxDetailImportVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    errorMessage.append("[\u4eba\u5458\u59d3\u540d\u4e3a\u5fc5\u586b\u9879]");
                } else if (((String)datas.get(0)).length() > 50) {
                    importVO.setErrorMessage("\u586b\u5199\u4eba\u5458\u59d3\u540d\u957f\u5ea6\u4e3a1~50\u5b57");
                } else {
                    importVO.setDetailEmployeeName((String)datas.get(0));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    errorMessage.append("[\u8bc1\u4ef6\u53f7\u7801\u4e3a\u5fc5\u586b\u9879]");
                } else if (((String)datas.get(1)).length() > 20) {
                    importVO.setErrorMessage("\u586b\u5199\u8bc1\u4ef6\u53f7\u7801\u957f\u5ea6\u4e3a1~20");
                } else {
                    importVO.setIdCard((String)datas.get(1));
                    if (ObjectUtils.isEmpty(personMap.get(datas.get(1)))) {
                        importVO.setErrorMessage("\u6ca1\u6709\u8be5\u8eab\u4efd\u8bc1\u53f7\u7684\u4eba\u5458\u4fe1\u606f");
                    } else if (!importVO.getDetailEmployeeName().equals(((TaxDetailEntity)((Object)personMap.get(datas.get(1)))).getDetailEmployeeName())) {
                        importVO.setErrorMessage("\u4eba\u5458\u548c\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u5339\u914d");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    try {
                        importVO.setTotalNeedTaxMny(new BigDecimal((String)datas.get(2)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u5e94\u7f34\u7a0e\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    try {
                        importVO.setTotalAlreadyTaxMny(new BigDecimal((String)datas.get(3)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u5df2\u7f34\u7a0e\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    try {
                        importVO.setTotalButuiTaxMny(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u5e94\u8865/\u9000\u7a0e\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        importVO.setTotalZxkcMny(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u4e13\u9879\u6263\u9664\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        importVO.setTotalZnjyMny(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u5b50\u5973\u6559\u80b2\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        importVO.setTotalJxjyMny(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u7ee7\u7eed\u6559\u80b2\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        importVO.setTotalZfdkMny(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u4f4f\u623f\u8d37\u6b3e\u5229\u606f\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    try {
                        importVO.setTotalZfzjMny(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u4f4f\u623f\u79df\u91d1\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    try {
                        importVO.setTotalSylrMny(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u8d61\u517b\u8001\u4eba\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    try {
                        importVO.setTotalYezhMny(new BigDecimal((String)datas.get(11)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba13\u5c81\u4ee5\u4e0b\u5a74\u5e7c\u513f\u7167\u62a4\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    try {
                        importVO.setTotalYljMny(new BigDecimal((String)datas.get(12)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u517b\u8001\u91d1\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    try {
                        importVO.setQynjMny(new BigDecimal((String)datas.get(13)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u4f01\u4e1a(\u804c\u4e1a)\u5e74\u91d1\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14)))) {
                    try {
                        importVO.setSyylMny(new BigDecimal((String)datas.get(14)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7a0e\u5ef6\u517b\u8001\u4fdd\u9669\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15)))) {
                    try {
                        importVO.setOtherMny(new BigDecimal((String)datas.get(15)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u5176\u4ed6\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16)))) {
                    try {
                        importVO.setZykcMny(new BigDecimal((String)datas.get(16)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u51c6\u4e88\u6263\u9664\u7684\u6350\u8d60\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16)))) {
                    try {
                        importVO.setJmseMny(new BigDecimal((String)datas.get(16)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u51cf\u514d\u7a0e\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                importVO.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    successList.add(importVO);
                    continue;
                }
                importVO.setErrorMessage(String.valueOf(errorMessage));
                errorList.add(importVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

